/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world;

import com.matez.wildnature.client.gui.screen.ScreenUtils;
import com.matez.wildnature.util.config.CommonConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class WNGeneratorWarningScreen
extends Screen {
    private static final ResourceLocation SCREENSHOT = new ResourceLocation("wildnature:textures/gui/images/generator_screenshot.png");
    private int centerWidth;
    private int centerHeight;
    private int screenX1;
    private int screenY1;
    private int screenX2;
    private int screenY2;
    private int imageWidth = 904;
    private int imageHeight = 506;
    private String header = TextFormatting.BOLD + "WildNature " + "3.0-EA3";
    private String body1 = "Choose World Generator";
    private String body2 = "New generator makes your world insane!";
    private String body3 = "It's still being developed, so it's not a final version.";
    private String body4 = "Terrain may still change in future." + TextFormatting.LIGHT_PURPLE + "It's experimental!";
    private String body5 = TextFormatting.RED + "WARNING: " + TextFormatting.RESET + "This makes your world incompatible with already existing worlds.";
    private String configInfo1 = TextFormatting.WHITE + "You can still change this setting whenever you want.";
    private String configInfo2 = TextFormatting.GRAY + "See " + TextFormatting.ITALIC + ".minecraft/config/wildnature-common.toml" + TextFormatting.RESET + TextFormatting.GRAY + " at " + TextFormatting.ITALIC + "generator.generatorType";
    private String buttonNewText = TextFormatting.GOLD + "Use new generator";
    private String buttonOldText = TextFormatting.RED + "Use old generator";
    private Button buttonNew;
    private Button buttonOld;

    public WNGeneratorWarningScreen() {
        super((ITextComponent)new StringTextComponent("Generator Warning"));
    }

    public static CompletableFuture<Void> loadAsync(TextureManager texMngr, Executor backgroundExecutor) {
        return CompletableFuture.allOf(texMngr.func_215268_a(SCREENSHOT, backgroundExecutor));
    }

    public void removed() {
        NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.loading.done", (Object[])new Object[0]));
    }

    public void fill(int x1, int y1, int x2, int y2) {
        WNGeneratorWarningScreen.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)-1072689136);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected void init() {
        this.centerWidth = this.width / 2;
        this.centerHeight = this.height / 2;
        int properWidth = ScreenUtils.getWidthByResolution(this.width, this.height - 65 - 80, 16, 9);
        this.screenX1 = this.centerWidth - properWidth;
        this.screenX2 = this.centerWidth + properWidth;
        this.screenY1 = 80;
        this.screenY2 = this.height - 65;
        this.buttonNew = (Button)this.addButton((Widget)new Button(this.centerWidth - 130, this.height - 60, 120, 20, this.buttonNewText, button -> this.action(true)));
        this.buttonOld = (Button)this.addButton((Widget)new Button(this.centerWidth + 130 - 120, this.height - 60, 120, 20, this.buttonOldText, button -> this.action(false)));
    }

    private void action(boolean clickedNew) {
        CommonConfig.generatorType.set((Object)(clickedNew ? "new" : "old"));
        CommonConfig.generatorWarning.set((Object)true);
        this.onClose();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderUIScreen();
        this.renderInterface();
        super.render(mouseX, mouseY, partialTicks);
    }

    private void renderUIScreen() {
        this.renderBackground();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SCREENSHOT);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtils.drawInscribedRect((int)this.screenX1, (int)this.screenY1, (int)(this.screenX2 - this.screenX1), (int)(this.screenY2 - this.screenY1), (int)this.imageWidth, (int)this.imageHeight, (boolean)true, (boolean)false);
    }

    private void renderInterface() {
        this.drawCenteredString(this.font, this.header, this.centerWidth, 10, 0xFFFFFF);
        this.drawCenteredString(this.font, this.body1, this.centerWidth, 15, 0xFFFFFF);
        this.drawCenteredString(this.font, this.body2, this.centerWidth, 35, 0xFFFFFF);
        this.drawCenteredString(this.font, this.body3, this.centerWidth, 45, 0xFFFFFF);
        this.drawCenteredString(this.font, this.body4, this.centerWidth, 55, 0xFFFFFF);
        this.drawCenteredString(this.font, this.body5, this.centerWidth, 65, 0xFFFFFF);
        this.drawCenteredString(this.font, this.configInfo1, this.centerWidth, this.height - 30, 0xFFFFFF);
        this.drawCenteredString(this.font, this.configInfo2, this.centerWidth, this.height - 15, 0xFFFFFF);
    }
}

