/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.BushBase;
import com.matez.wildnature.common.blocks.FloweringBushBase;
import com.matez.wildnature.common.blocks.config.ConfigSettings;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.other.Utilities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AnemonePlant
extends BushBase
implements IGrowable {
    public static final long MORNING_START = 0L;
    public static final long MORNING_END = 1500L;
    public static final long DAYTIME_START = 1500L;
    public static final long DAYTIME_END = 9000L;
    public static final long SUNSET_START = 9000L;
    public static final long SUNSET_END = 12000L;
    public static final long NIGHT_START = 12000L;
    public static final long NIGHT_END = 0L;
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"bloom", (int)0, (int)3);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};
    public static final BooleanProperty FLOWERING = BooleanProperty.func_177716_a((String)"flowering");

    public AnemonePlant(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties, builder, regName);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{AGE}).func_206894_a(new IProperty[]{FLOWERING});
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)FLOWERING)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(this.getAgeByTime(this.getTimeByLong(world.func_72820_D())))));
            } else if (Utilities.chance(ConfigSettings.floweringChance)) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (state.func_177230_c() instanceof FloweringBushBase && ((Boolean)state.func_177229_b((IProperty)FLOWERING)).booleanValue() && ((Boolean)CommonConfig.flowerDisappearsOnWalk.get()).booleanValue() && !(entityIn instanceof ItemEntity)) {
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(false)));
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_219625_by, SoundCategory.BLOCKS, 0.3f, (float)Utilities.rdoub(0.7, 1.3), false);
        }
    }

    private AnemoneTime getTimeByLong(long currentTime) {
        if (Utilities.dBetween(0.0, 1500.0, currentTime)) {
            return AnemoneTime.MORNING;
        }
        if (Utilities.dBetween(1500.0, 9000.0, currentTime)) {
            return AnemoneTime.DAYTIME;
        }
        if (Utilities.dBetween(9000.0, 12000.0, currentTime)) {
            return AnemoneTime.SUNSET;
        }
        return AnemoneTime.NIGHT;
    }

    private int getAgeByTime(AnemoneTime time) {
        if (time == AnemoneTime.MORNING) {
            return 2;
        }
        if (time == AnemoneTime.DAYTIME) {
            return 3;
        }
        if (time == AnemoneTime.SUNSET) {
            return 2;
        }
        return 1;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (Utilities.rint(0, (Integer)CommonConfig.flowerBloomChance.get()) == 0) {
            if (!((Boolean)state.func_177229_b((IProperty)FLOWERING)).booleanValue()) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(true)));
            } else {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                AnemonePlant.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            if (placer instanceof PlayerEntity && ((PlayerEntity)placer).func_184812_l_()) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(true)));
            }
            if (((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)FLOWERING)).booleanValue()) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(this.getAgeByTime(this.getTimeByLong(worldIn.func_72820_D())))));
            }
        }
    }

    public static enum AnemoneTime {
        MORNING,
        DAYTIME,
        SUNSET,
        NIGHT;

    }
}

