/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.matez.wildnature.client.gui.tileEntities.CustomPistonTileEntity;
import com.matez.wildnature.client.sounds.SoundRegistry;
import com.matez.wildnature.common.blocks.CustomMovingPistonBlock;
import com.matez.wildnature.common.blocks.CustomPistonHeadBlock;
import com.matez.wildnature.init.Main;
import com.matez.wildnature.util.other.CustomPistonBlockStructureHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomPistonBlock
extends DirectionalBlock {
    public static final BooleanProperty EXTENDED = BlockStateProperties.field_208181_h;
    protected static final VoxelShape PISTON_BASE_EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_WEST_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape PISTON_BASE_NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_UP_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_DOWN_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final boolean isSticky;
    private static Block piston;
    private static Block head;
    private static Block moving;
    private ResourceLocation loc;
    private ResourceLocation hea;
    private ResourceLocation movi;

    public CustomPistonBlock(boolean sticky, Block.Properties properties, ResourceLocation location, ResourceLocation head, ResourceLocation moving) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176387_N, (Comparable)Direction.NORTH)).func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(false)));
        this.isSticky = sticky;
        this.setRegistryName(location);
        this.loc = location;
        this.hea = head;
        this.movi = moving;
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)EXTENDED) == false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
            switch ((Direction)state.func_177229_b((IProperty)field_176387_N)) {
                case DOWN: {
                    return PISTON_BASE_DOWN_AABB;
                }
                default: {
                    return PISTON_BASE_UP_AABB;
                }
                case NORTH: {
                    return PISTON_BASE_NORTH_AABB;
                }
                case SOUTH: {
                    return PISTON_BASE_SOUTH_AABB;
                }
                case WEST: {
                    return PISTON_BASE_WEST_AABB;
                }
                case EAST: 
            }
            return PISTON_BASE_EAST_AABB;
        }
        return VoxelShapes.func_197868_b();
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        piston = Main.getBlockByID(this.loc + "");
        head = Main.getBlockByID(this.hea + "");
        moving = Main.getBlockByID(this.movi + "");
        if (!worldIn.field_72995_K) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)context.func_196010_d().func_176734_d())).func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(false));
    }

    private void checkForMove(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_176387_N);
        boolean flag = this.shouldBeExtended(worldIn, pos, direction);
        if (flag && !((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
            if (new CustomPistonBlockStructureHelper(worldIn, pos, direction, true).canMove()) {
                worldIn.func_175641_c(pos, (Block)this, 0, direction.func_176745_a());
            }
        } else if (!flag && ((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
            CustomPistonTileEntity pistontileentity;
            TileEntity tileentity;
            BlockPos blockpos = pos.func_177967_a(direction, 2);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            int i = 1;
            if (blockstate.func_177230_c() == moving && blockstate.func_177229_b((IProperty)field_176387_N) == direction && (tileentity = worldIn.func_175625_s(blockpos)) instanceof CustomPistonTileEntity && (pistontileentity = (CustomPistonTileEntity)tileentity).isExtending() && (pistontileentity.getProgress(0.0f) < 0.5f || worldIn.func_82737_E() == pistontileentity.getLastTicked() || ((ServerWorld)worldIn).func_211158_j_())) {
                i = 2;
            }
            worldIn.func_175641_c(pos, (Block)this, i, direction.func_176745_a());
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !worldIn.func_175709_b(pos.func_177972_a(direction), direction)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_176387_N);
        if (!worldIn.field_72995_K) {
            boolean flag = this.shouldBeExtended(worldIn, pos, direction);
            if (flag && (id == 1 || id == 2)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (ForgeEventFactory.onPistonMovePre((World)worldIn, (BlockPos)pos, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.doMove(worldIn, pos, direction, true)) {
                return false;
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(true)), 67);
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundRegistry.PISTON_2s_OPEN, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1 || id == 2) {
            if (ForgeEventFactory.onPistonMovePre((World)worldIn, (BlockPos)pos, (Direction)direction, (boolean)false)) {
                return false;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(pos.func_177972_a(direction));
            if (tileentity1 instanceof CustomPistonTileEntity) {
                System.out.println("somet1");
                ((CustomPistonTileEntity)tileentity1).clearPistonTileEntity();
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)moving.func_176223_P().func_206870_a((IProperty)CustomMovingPistonBlock.FACING, (Comparable)direction)).func_206870_a(CustomMovingPistonBlock.TYPE, (Comparable)(this.isSticky ? PistonType.STICKY : PistonType.DEFAULT)), 3);
            worldIn.func_175690_a(pos, CustomMovingPistonBlock.createTilePiston((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)Direction.func_82600_a((int)(param & 7))), direction, false, true));
            if (this.isSticky) {
                CustomPistonTileEntity pistontileentity;
                TileEntity tileentity;
                BlockPos blockpos = pos.func_177982_a(direction.func_82601_c() * 2, direction.func_96559_d() * 2, direction.func_82599_e() * 2);
                BlockState blockstate = worldIn.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                boolean flag1 = false;
                if (block == moving && (tileentity = worldIn.func_175625_s(blockpos)) instanceof CustomPistonTileEntity && (pistontileentity = (CustomPistonTileEntity)tileentity).getFacing() == direction && pistontileentity.isExtending()) {
                    System.out.println("somet2");
                    pistontileentity.clearPistonTileEntity();
                    flag1 = true;
                }
                if (!flag1) {
                    if (id != 1 || blockstate.isAir((IBlockReader)worldIn, blockpos) || !CustomPistonBlock.canPush(blockstate, worldIn, blockpos, direction.func_176734_d(), false, direction) || blockstate.func_185905_o() != PushReaction.NORMAL && block != piston) {
                        worldIn.func_217377_a(pos.func_177972_a(direction), false);
                    } else {
                        this.doMove(worldIn, pos, direction, false);
                    }
                }
            } else {
                worldIn.func_217377_a(pos.func_177972_a(direction), false);
            }
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundRegistry.PISTON_2s_CLOSE, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        ForgeEventFactory.onPistonMovePost((World)worldIn, (BlockPos)pos, (Direction)direction, (id == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean canPush(BlockState blockStateIn, World worldIn, BlockPos pos, Direction facing, boolean destroyBlocks, Direction p_185646_5_) {
        Block block = blockStateIn.func_177230_c();
        if (block == Blocks.field_150343_Z) {
            return false;
        }
        if (!worldIn.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (pos.func_177956_o() >= 0 && (facing != Direction.DOWN || pos.func_177956_o() != 0)) {
            if (pos.func_177956_o() <= worldIn.func_217301_I() - 1 && (facing != Direction.UP || pos.func_177956_o() != worldIn.func_217301_I() - 1)) {
                if (block != piston) {
                    if (blockStateIn.func_185887_b((IBlockReader)worldIn, pos) == -1.0f) {
                        return false;
                    }
                    switch (blockStateIn.func_185905_o()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == p_185646_5_;
                        }
                    }
                } else if (((Boolean)blockStateIn.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
                    return false;
                }
                return !blockStateIn.hasTileEntity();
            }
            return false;
        }
        return false;
    }

    private boolean doMove(World worldIn, BlockPos pos, Direction directionIn, boolean extending) {
        CustomPistonBlockStructureHelper CustomPistonBlockStructureHelper2;
        BlockPos blockpos = pos.func_177972_a(directionIn);
        if (!extending && worldIn.func_180495_p(blockpos).func_177230_c() == head) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(CustomPistonBlockStructureHelper2 = new CustomPistonBlockStructureHelper(worldIn, pos, directionIn, extending)).canMove()) {
            return false;
        }
        List<BlockPos> list = CustomPistonBlockStructureHelper2.getBlocksToMove();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = list.get(i);
            list1.add(worldIn.func_180495_p(blockpos1));
        }
        List<BlockPos> list2 = CustomPistonBlockStructureHelper2.getBlocksToDestroy();
        int k = list.size() + list2.size();
        BlockState[] ablockstate = new BlockState[k];
        Direction direction = extending ? directionIn : directionIn.func_176734_d();
        HashSet set = Sets.newHashSet(list);
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos2 = list2.get(j);
            BlockState blockstate = worldIn.func_180495_p(blockpos2);
            TileEntity tileentity = blockstate.hasTileEntity() ? worldIn.func_175625_s(blockpos2) : null;
            CustomPistonBlock.func_220059_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos2, (TileEntity)tileentity);
            worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 18);
            ablockstate[--k] = blockstate;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            BlockState blockstate3 = worldIn.func_180495_p(blockpos3);
            blockpos3 = blockpos3.func_177972_a(direction);
            set.remove(blockpos3);
            worldIn.func_180501_a(blockpos3, (BlockState)moving.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)directionIn), 68);
            worldIn.func_175690_a(blockpos3, CustomMovingPistonBlock.createTilePiston((BlockState)list1.get(l), directionIn, extending, false));
            ablockstate[--k] = blockstate3;
        }
        if (extending) {
            PistonType pistontype = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockstate1 = (BlockState)((BlockState)head.func_176223_P().func_206870_a((IProperty)CustomPistonHeadBlock.field_176387_N, (Comparable)directionIn)).func_206870_a(CustomPistonHeadBlock.TYPE, (Comparable)pistontype);
            BlockState blockstate4 = (BlockState)((BlockState)moving.func_176223_P().func_206870_a((IProperty)CustomMovingPistonBlock.FACING, (Comparable)directionIn)).func_206870_a(CustomMovingPistonBlock.TYPE, (Comparable)(this.isSticky ? PistonType.STICKY : PistonType.DEFAULT));
            set.remove(blockpos);
            worldIn.func_180501_a(blockpos, blockstate4, 68);
            worldIn.func_175690_a(blockpos, CustomMovingPistonBlock.createTilePiston(blockstate1, directionIn, true, true));
        }
        for (BlockPos blockpos4 : set) {
            worldIn.func_180501_a(blockpos4, Blocks.field_150350_a.func_176223_P(), 66);
        }
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockstate2 = ablockstate[k++];
            BlockPos blockpos5 = list2.get(i1);
            blockstate2.func_196948_b((IWorld)worldIn, blockpos5, 2);
            worldIn.func_195593_d(blockpos5, blockstate2.func_177230_c());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            worldIn.func_195593_d(list.get(j1), ablockstate[k++].func_177230_c());
        }
        if (extending) {
            worldIn.func_195593_d(blockpos, head);
        }
        return true;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (Boolean)state.func_177229_b((IProperty)EXTENDED) != false ? state : super.rotate(state, world, pos, direction);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N, EXTENDED});
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EXTENDED);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

