/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.VineBase;
import com.matez.wildnature.common.blocks.config.ConfigSettings;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNItems;
import com.matez.wildnature.util.other.Utilities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GrapeVine
extends VineBase
implements IGrowable {
    public static final BooleanProperty FLOWERING = BooleanProperty.func_177716_a((String)"flowering");
    public VineType type;

    public GrapeVine(Block.Properties properties, Item.Properties builder, ResourceLocation regName, VineType type) {
        super(properties, builder, regName);
        this.type = type;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FLOWERING});
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if (Utilities.chance(ConfigSettings.floweringChance) && state.func_177230_c() instanceof GrapeVine) {
            try {
                worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(true)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (Utilities.rint(0, (Integer)CommonConfig.flowerBloomChance.get()) == 0) {
            if (!((Boolean)state.func_177229_b((IProperty)FLOWERING)).booleanValue()) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(true)));
            } else {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                GrapeVine.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity && ((PlayerEntity)placer).func_184812_l_()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(true)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity p_220051_4_, Hand p_220051_5_, BlockRayTraceResult p_220051_6_) {
        if (((Boolean)state.func_177229_b((IProperty)FLOWERING)).booleanValue()) {
            if (this.type == VineType.PURPLE) {
                GrapeVine.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)WNItems.GRAPES_PURPLE, 1));
            } else if (this.type == VineType.YELLOW) {
                GrapeVine.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)WNItems.GRAPES_YELLOW, 1));
            }
            world.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)FLOWERING, (Comparable)Boolean.valueOf(false)), 2);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static enum VineType implements IStringSerializable
    {
        YELLOW("yellow"),
        PURPLE("purple");

        private final String name;

        private VineType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

