/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.init.Main;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiome;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiomeManager;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class CaveBiomeListCommand {
    private int maxPages;
    private PlayerEntity entity;
    private ArrayList<URBiome> list = new ArrayList<URBiome>(URBiomeManager.riverBiomes.getObjects());

    public CaveBiomeListCommand(PlayerEntity entity) {
        int a = 0;
        while (a < this.list.size()) {
            a += 10;
            ++this.maxPages;
        }
        this.entity = entity;
    }

    public int showPage(int page) {
        if (this.maxPages < page) {
            Main.sendChatMessage(this.entity, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown page. Use values from " + TextFormatting.GOLD + "1" + TextFormatting.RED + " to " + TextFormatting.GOLD + this.maxPages + TextFormatting.RED + ".")));
            return 0;
        }
        StringTextComponent s = new StringTextComponent(TextFormatting.GREEN + "Biome List " + TextFormatting.GRAY + " - - - " + TextFormatting.LIGHT_PURPLE + " page " + TextFormatting.AQUA + page + TextFormatting.DARK_AQUA + "/" + TextFormatting.AQUA + this.maxPages);
        StringTextComponent hovermsg = new StringTextComponent(TextFormatting.GRAY + "Showing " + TextFormatting.DARK_AQUA + this.list.size() + TextFormatting.GRAY + " underground river biomes");
        s.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hovermsg));
        StringTextComponent s2 = new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + " >>>");
        s2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Click to show next page")));
        s2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wn undergroundRiverBiome list " + (page + 1) + ""));
        ITextComponent s3 = new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s);
        if (page < this.maxPages) {
            s3.func_150257_a((ITextComponent)s2);
        }
        Main.sendChatMessage(this.entity, s3);
        int startIndex = page * 10 - 10;
        for (int i = 0; i < 10; ++i) {
            try {
                this.showListLine(this.list.get(startIndex + i), startIndex + i + 1 + "");
                continue;
            }
            catch (Exception e) {
                this.showListLine(null, "-");
            }
        }
        return 1;
    }

    public void showListLine(URBiome biome, String index) {
        if (biome == null) {
            Main.sendChatMessage(this.entity, new StringTextComponent(TextFormatting.DARK_GRAY + "[" + index + "]").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + " ")));
        } else {
            String wiki = "https://wildnaturemod.com/" + biome.getName().replace("_", "-");
            String search = "/wn undergroundRiverBiome locate wildnature:" + biome.getName();
            StringTextComponent wikicomponent = null;
            wikicomponent = new StringTextComponent(TextFormatting.LIGHT_PURPLE + "W");
            wikicomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "Click to see the wiki page for this biome")));
            wikicomponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, wiki));
            StringTextComponent searchcomponent = new StringTextComponent(TextFormatting.GREEN + "T");
            searchcomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_GREEN + "Click to teleport")));
            searchcomponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, search));
            TextFormatting t = TextFormatting.AQUA;
            StringTextComponent infocomponent = new StringTextComponent(t + "wildnature:" + biome.getName());
            infocomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new StringTextComponent(TextFormatting.GOLD + "--- INFORMATION ---").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "id: wildnature:" + biome.getName())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "index: " + this.list.indexOf(biome))).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "category: " + biome.getCategory())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "temp category: " + biome.getTempCategory())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "rarity: " + biome.getRarity()))));
            Main.sendChatMessage(this.entity, new StringTextComponent(TextFormatting.DARK_GRAY + "[" + index + "] ").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + "|")).func_150257_a((ITextComponent)wikicomponent).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + ":")).func_150257_a((ITextComponent)searchcomponent).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + "|")).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + " - ")).func_150257_a((ITextComponent)infocomponent));
        }
    }

    public static ArrayList<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        File folder = new File(FMLPaths.CONFIGDIR.get().resolve("wildnature/export").toString());
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) continue;
            files.add(fileEntry.getName());
        }
        return files;
    }
}

