/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.init;

import com.matez.wildnature.client.gui.container.PouchContainer;
import com.matez.wildnature.client.gui.initGuis;
import com.matez.wildnature.client.gui.tileEntities.CustomPistonTileEntity;
import com.matez.wildnature.client.gui.tileEntities.DungeonCommanderTileEntity;
import com.matez.wildnature.client.gui.tileEntities.GravityShroomTileEntity;
import com.matez.wildnature.client.gui.tileEntities.HydrothermalVentTileEntity;
import com.matez.wildnature.client.gui.tileEntities.item.ItemTileEntity;
import com.matez.wildnature.client.particles.CrystalSparkParticle;
import com.matez.wildnature.client.particles.DungeonHeartParticle;
import com.matez.wildnature.client.particles.DustParticle;
import com.matez.wildnature.client.particles.FuzzballExplosionParticle;
import com.matez.wildnature.client.particles.GeyserParticle;
import com.matez.wildnature.client.particles.PollenParticle;
import com.matez.wildnature.client.particles.SlimeshroomParticle;
import com.matez.wildnature.client.particles.SteamParticle;
import com.matez.wildnature.client.particles.ThermalParticle;
import com.matez.wildnature.client.render.WNBlockRenderLayer;
import com.matez.wildnature.client.sounds.SoundRegistry;
import com.matez.wildnature.common.blocks.config.ConfigSettings;
import com.matez.wildnature.common.colors.WNBlockColors;
import com.matez.wildnature.common.colors.WNItemColors;
import com.matez.wildnature.common.commands.BiomeArgument;
import com.matez.wildnature.common.commands.WNCommand;
import com.matez.wildnature.common.compatibility.WNMinecraftCopatibility;
import com.matez.wildnature.common.compatibility.WNMobSpawnFix;
import com.matez.wildnature.common.compatibility.WNMobSpawning;
import com.matez.wildnature.common.entity.EntityRegistry;
import com.matez.wildnature.common.entity.render.RenderRegistry;
import com.matez.wildnature.common.items.recipes.DyeableRecipe;
import com.matez.wildnature.common.items.recipes.GiftCrafting;
import com.matez.wildnature.common.items.recipes.KnifeCrafting;
import com.matez.wildnature.common.items.recipes.PotCrafting;
import com.matez.wildnature.common.items.recipes.cooking.CraftingTweaker;
import com.matez.wildnature.common.items.recipes.cooking.WNCookingRecipe;
import com.matez.wildnature.common.items.recipes.cooking.WNCookingRecipeSerializer;
import com.matez.wildnature.common.items.recipes.cooking.WNCookingSmelting;
import com.matez.wildnature.common.registry.WNRegistry;
import com.matez.wildnature.common.registry.blocks.BuildingRegistry;
import com.matez.wildnature.common.registry.blocks.FlowerRegistry;
import com.matez.wildnature.common.registry.blocks.FurnitureRegistry;
import com.matez.wildnature.common.registry.blocks.GrassRegistry;
import com.matez.wildnature.common.registry.blocks.OreRegistry;
import com.matez.wildnature.common.registry.blocks.OtherRegistry;
import com.matez.wildnature.common.registry.blocks.RockRegistry;
import com.matez.wildnature.common.registry.blocks.SaplingRegistry;
import com.matez.wildnature.common.registry.blocks.WoodRegistry;
import com.matez.wildnature.common.registry.items.FoodRegistry;
import com.matez.wildnature.common.registry.items.GemRegistry;
import com.matez.wildnature.common.registry.items.ItemRegistry;
import com.matez.wildnature.common.registry.items.WaterlilyRegistry;
import com.matez.wildnature.common.registry.particles.ParticleRegistry;
import com.matez.wildnature.network.proxy.ClientProxy;
import com.matez.wildnature.network.proxy.IProxy;
import com.matez.wildnature.network.proxy.ServerProxy;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.config.WNConfig;
import com.matez.wildnature.util.dataFixer.WNDataFixer;
import com.matez.wildnature.util.event.FogEvent;
import com.matez.wildnature.util.event.GuiEvent;
import com.matez.wildnature.util.event.KeyEvent;
import com.matez.wildnature.util.event.ParticleFactoryEvent;
import com.matez.wildnature.util.event.PlayerEventHandler;
import com.matez.wildnature.util.event.RenderCapeHandler;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.world.generation.biome.setup.WNBiomes;
import com.matez.wildnature.world.generation.carvers.CarverRegistry;
import com.matez.wildnature.world.generation.chunk.WNChunkGeneratorType;
import com.matez.wildnature.world.generation.feature.FeatureRegistry;
import com.matez.wildnature.world.generation.feature.features.RockGen;
import com.matez.wildnature.world.generation.provider.WNBiomeProviderType;
import com.matez.wildnature.world.generation.provider.WNWorldType;
import com.matez.wildnature.world.generation.structures.nature.FallenRegistry;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import com.matez.wildnature.world.generation.surface.SurfaceRegistry;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="wildnature")
public class Main {
    public static Main instance;
    public static final String modid = "wildnature";
    public static final String version = "3.0-EA3";
    public static final Logger LOGGER;
    public static final String WildNaturePrefix;
    public static WorldType WNWorldType;
    private static WNChunkGeneratorType chunkGeneratorType;
    private static WNBiomeProviderType biomeProviderType;
    public static ArrayList<SchemFeature> treesList;
    public static IProxy proxy;
    public static boolean gotInfoAboutWorld;
    public static boolean loadedNewVersion;
    public ArrayList<String> supportedLanguages = new ArrayList();
    public static boolean usesFancyGraphics;
    public static StringTextComponent WNPrefix;
    public static boolean canShowAdvancedTooltip;
    public static World runningWorld;
    public static WNDataFixer dataFixer;

    public Main() {
        LOGGER.info("Initializing WildNature mod");
        instance = this;
        this.addSupportedLanguages();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onServerStarting);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerParticles);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetup);
        File f = new File(FMLPaths.GAMEDIR.get().resolve("wildnature/").toString());
        if (!f.exists()) {
            new File(FMLPaths.GAMEDIR.get().resolve("wildnature/").toString()).mkdirs();
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        WNConfig.register(ModLoadingContext.get());
        ConfigSettings.applyCfgs();
        MinecraftForge.EVENT_BUS.register((Object)this);
        WNPrefix.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "WildNature " + TextFormatting.LIGHT_PURPLE + version)));
        WNPrefix.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://wildnaturemod.com"));
        dataFixer = new WNDataFixer();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setup...");
        RockGen.setupRocks();
        MinecraftForge.EVENT_BUS.addListener(new ParticleFactoryEvent()::registerParticles);
        dataFixer.registerDataFixer();
        ArgumentTypes.func_218136_a((String)"biome_argument", BiomeArgument.class, (IArgumentSerializer)new ArgumentSerializer(BiomeArgument::createArgument));
        LOGGER.info("Using Version " + CommonConfig.currentVersion + " / " + version);
        if (!((String)CommonConfig.currentVersion.get()).equals(version)) {
            loadedNewVersion = true;
            LOGGER.info("Using new version! Current: 3.0-EA3");
            CommonConfig.currentVersion.set((Object)version);
        }
        CommonConfig.compile();
        FallenRegistry.registerAll();
        WNBiomes.registerAll();
        WNMinecraftCopatibility.init();
        LOGGER.info("Re-registering entity spawns. Found " + EntitySpawnPlacementRegistry.field_209347_a.size());
        WNMobSpawnFix.fixAll();
        WNMobSpawning.registerAll();
        EntityRegistry.registerEntitySpawns();
        WNBiomes.unregisterBlacklisted();
        proxy.init();
        Main.wnInfo("Setup completed");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        LOGGER.info("Client setup...");
        WNBlockColors blockColors = new WNBlockColors();
        WNItemColors itemColors = new WNItemColors();
        MinecraftForge.EVENT_BUS.addListener(new GuiEvent()::guiScreenEvent);
        MinecraftForge.EVENT_BUS.addListener(new KeyEvent()::onKey);
        MinecraftForge.EVENT_BUS.addListener(new FogEvent()::fogEvent);
        MinecraftForge.EVENT_BUS.addListener(new FogEvent()::fogColorEvent);
        MinecraftForge.EVENT_BUS.addListener(new RenderCapeHandler()::onRender);
        RenderRegistry.registryEntityRenders();
        RenderRegistry.registryTileEntityRenders();
        ForgeRegistries.BLOCKS.forEach(WNBlockRenderLayer::setProperRenderLayer);
        Main.wnInfo("Client setup completed");
    }

    @SubscribeEvent
    public void enqueueIMC(InterModEnqueueEvent event) {
        proxy.enqueueIMC(event);
    }

    private void addSupportedLanguages() {
        this.supportedLanguages.add("en_us");
        this.supportedLanguages.add("pl_pl");
        this.supportedLanguages.add("ru_ru");
        this.supportedLanguages.add("de_de");
    }

    public ArrayList<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @SubscribeEvent
    public void registerParticles(ParticleFactoryRegisterEvent event) {
        LOGGER.info("Registering particle factories...");
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.DUNGEON_HEART, DungeonHeartParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.CRYSTAL_SPARK, CrystalSparkParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.CRYSTAL, CrystalSparkParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.GEYSER, GeyserParticle.GeyserParticleFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.STEAM, SteamParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.FLOWERING_LEAF_WHITE_DUST, DustParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a(ParticleRegistry.POLLEN, PollenParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.WISTERIA_PINK, DustParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.SLIMESHROOM_GREEN, SlimeshroomParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.SLIMESHROOM_BLUE, SlimeshroomParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.THERMAL_SMOKE, ThermalParticle.ThermalParticleFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.FUZZBALL_EXPLOSION, FuzzballExplosionParticle.Factory::new);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent e) {
        LOGGER.debug("Registering commands");
        MinecraftForge.EVENT_BUS.addListener(new PlayerEventHandler()::onPlayerJoin);
        MinecraftForge.EVENT_BUS.addListener(new PlayerEventHandler()::onPlayerExit);
        MinecraftForge.EVENT_BUS.addListener(new CraftingTweaker()::playerCraftedEvent);
        WNCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        Main.wnInfo("Successfully initialized server-side");
    }

    @SubscribeEvent
    public void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
        ServerProperties serverProperties = ((DedicatedServer)event.getServerSupplier().get()).func_213221_d_();
        if (((Boolean)CommonConfig.useWNOnServer.get()).booleanValue()) {
            Main.wnInfo("Using WildNature generator on server.");
            LOGGER.info(String.format("Using WildNature on server. Original value: %s", serverProperties.field_219023_q.func_211888_a()));
            serverProperties.field_73672_b.setProperty("level-type", modid);
            serverProperties.field_219023_q = WNWorldType;
        } else {
            Main.wnInfo("WN Server Generator disabled");
        }
    }

    public static Block getBlockByID(String resLoc) {
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(resLoc));
    }

    public static Item getItemByID(String resLoc) {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(resLoc));
    }

    public static Biome getBiomeByID(String resLoc) {
        return (Biome)Registry.field_212624_m.func_82594_a(new ResourceLocation(resLoc));
    }

    public static ParticleType getParticleByID(String resLoc) {
        return (ParticleType)Registry.field_212632_u.func_82594_a(new ResourceLocation(resLoc));
    }

    public static SoundEvent getSoundByID(String resLoc) {
        return (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation(resLoc));
    }

    public static void sendServerChatMessage(MinecraftServer server, PlayerEntity playerEntity, String message) {
        if (Main.hasEffect((LivingEntity)playerEntity, Effects.field_76441_p)) {
            LOGGER.debug("---> Player is invisible, message won't be send");
            return;
        }
        if (server != null) {
            server.func_145747_a((ITextComponent)new StringTextComponent(message));
            for (PlayerEntity p : server.func_184103_al().func_181057_v()) {
                if (p == playerEntity) continue;
                Main.sendChatMessage(p, message);
            }
        } else {
            LOGGER.debug("---> Cannot send message. Server == null");
        }
    }

    public static void sendServerChatMessage(MinecraftServer server, PlayerEntity playerEntity, ITextComponent message) {
        LOGGER.debug("Sending Message to server");
        if (Main.hasEffect((LivingEntity)playerEntity, Effects.field_76441_p)) {
            LOGGER.debug("---> Player is invisible, message won't be send");
            return;
        }
        if (server != null) {
            server.func_145747_a(message);
            for (PlayerEntity p : server.func_184103_al().func_181057_v()) {
                if (p == playerEntity) continue;
                Main.sendChatMessage(p, message);
            }
        } else {
            LOGGER.debug("---> Cannot send message. Server == null");
        }
    }

    public static void sendChatMessage(PlayerEntity entity, String message) {
        entity.func_145747_a((ITextComponent)new StringTextComponent(message));
    }

    public static void sendChatMessage(PlayerEntity entity, ITextComponent message) {
        entity.func_145747_a(message);
    }

    public static boolean hasEffect(LivingEntity entity, Effect effect) {
        ArrayList<Object> effects = new ArrayList<Object>(Arrays.asList(entity.func_70651_bq().toArray()));
        for (Object e : effects) {
            if (!(e instanceof EffectInstance) || ((EffectInstance)e).func_188419_a() != effect) continue;
            return true;
        }
        return false;
    }

    public static String readFromURL(String sURL) {
        if (!Main.netIsAvailable()) {
            LOGGER.warn("Internet connection unavailable");
            return null;
        }
        try {
            URL url = new URL(sURL);
            URLConnection con = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = in.readLine();
            StringBuilder builder = new StringBuilder();
            do {
                builder.append(line + "\n");
            } while ((line = in.readLine()) != null);
            in.close();
            return builder.toString();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot connect! Is the server unreachable?");
            return null;
        }
    }

    private static boolean netIsAvailable() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean is404(String url) {
        LOGGER.debug("Testing " + url + " for 404 exception...");
        if (Main.netIsAvailable()) {
            try {
                URL u = new URL(url);
                HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("GET");
                huc.connect();
                int code = huc.getResponseCode();
                LOGGER.debug("Response code: " + code);
                return code == 404;
            }
            catch (Exception e) {
                LOGGER.warn("Exception during 404 test: " + e.getLocalizedMessage());
            }
        } else {
            LOGGER.debug("Internet not available");
        }
        return true;
    }

    public static void wnInfo(String data) {
        LOGGER.info(TextFormatting.AQUA + "---------------------------------");
        LOGGER.info(TextFormatting.GREEN + " WildNature " + version + " // " + ForgeVersion.getVersion());
        LOGGER.info(TextFormatting.GREEN + " https://wildnaturemod.com");
        LOGGER.info(TextFormatting.DARK_AQUA + "---");
        LOGGER.info(TextFormatting.YELLOW + data);
        LOGGER.info(TextFormatting.DARK_AQUA + "---");
        LOGGER.info(TextFormatting.AQUA + "---------------------------------");
    }

    public static void fixResources() {
        ArrayList enabledPacks;
        ArrayList orderedPacks = enabledPacks = new ArrayList(Minecraft.func_71410_x().func_195548_H().func_198980_d());
        int vanillaIndex = 0;
        int modResIndex = 0;
        for (int i = 0; i < enabledPacks.size(); ++i) {
            if (((ClientResourcePackInfo)enabledPacks.get(i)).func_195790_f().equals("vanilla")) {
                vanillaIndex = i;
                orderedPacks.set(0, enabledPacks.get(i));
                continue;
            }
            if (((ClientResourcePackInfo)enabledPacks.get(i)).func_195790_f().equals("mod_resources")) {
                modResIndex = i;
                orderedPacks.set(1, enabledPacks.get(i));
                continue;
            }
            orderedPacks.set(i, enabledPacks.get(i));
        }
        Minecraft.func_71410_x().func_195548_H().func_198985_a(orderedPacks);
    }

    static {
        LOGGER = LogManager.getLogger((String)modid);
        WildNaturePrefix = TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + "[" + TextFormatting.GREEN.toString() + TextFormatting.BOLD.toString() + "WN" + TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + "] " + TextFormatting.AQUA.toString();
        WNWorldType = new WNWorldType(modid).func_205392_a(true);
        chunkGeneratorType = new WNChunkGeneratorType();
        biomeProviderType = new WNBiomeProviderType();
        treesList = new ArrayList();
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        gotInfoAboutWorld = true;
        loadedNewVersion = false;
        usesFancyGraphics = true;
        WNPrefix = new StringTextComponent(WildNaturePrefix);
        canShowAdvancedTooltip = false;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static RegistryEvent.Register<Item> itemEvent;
        public static RegistryEvent.Register<Block> blockEvent;
        public static RegistryEvent.Register<Biome> biomeEvent;
        public static RockRegistry rockRegistry;
        private static final List<ContainerType<?>> CONTAINER_TYPES;

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            LOGGER.info("Registering items...");
            itemEvent = event;
            for (Item itemblock : WNBlocks.ITEMBLOCKS) {
                WNRegistry.registerItems(event, itemblock);
            }
            GemRegistry gems = new GemRegistry();
            FoodRegistry food = new FoodRegistry();
            WaterlilyRegistry waterlily = new WaterlilyRegistry();
            ItemRegistry item = new ItemRegistry();
            WNRegistry.registerItems(event, gems.getItems());
            WNRegistry.registerItems(event, food.getItems());
            WNRegistry.registerItems(event, waterlily.getItems());
            WNRegistry.registerItems(event, item.getItems());
            EntityRegistry.registerSpawningEggs(event);
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            LOGGER.info("Registering recipe serializers...");
            event.getRegistry().register(new SpecialRecipeSerializer(GiftCrafting::new).setRegistryName("wildnature:gift_crafting"));
            event.getRegistry().register(new SpecialRecipeSerializer(DyeableRecipe::new).setRegistryName("wildnature:dyeable_recipe"));
            event.getRegistry().register(new SpecialRecipeSerializer(PotCrafting::new).setRegistryName("wildnature:pot_crafting"));
            event.getRegistry().register(new SpecialRecipeSerializer(KnifeCrafting::new).setRegistryName("wildnature:knife_chopping"));
            event.getRegistry().register(new WNCookingRecipeSerializer<WNCookingRecipe>(WNCookingRecipe::new, 200).setRegistryName("wildnature:cooking"));
            event.getRegistry().register(new SpecialRecipeSerializer(WNCookingSmelting::new).setRegistryName("wildnature:furnace_cooking"));
            event.getRegistry().register(new SpecialRecipeSerializer(WNCookingSmelting::new).setRegistryName("wildnature:smoker_cooking"));
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            LOGGER.info("Registering entities...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{EntityRegistry.SEAT, EntityRegistry.GOBLIN, EntityRegistry.DRAKE, EntityRegistry.DUCK, EntityRegistry.DUCKLING, EntityRegistry.BOAR, EntityRegistry.PIRANHA, EntityRegistry.DRAGONFLY, EntityRegistry.SPARROW_MALE, EntityRegistry.BUCK, EntityRegistry.DOE, EntityRegistry.FAWN});
        }

        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            LOGGER.info("Registering features...");
            FeatureRegistry.registerAll(event);
        }

        @SubscribeEvent
        public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            LOGGER.info("Registering surface builders...");
            SurfaceRegistry.registerAll(event);
        }

        @SubscribeEvent
        public static void registerCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
            LOGGER.info("Registering carvers...");
            CarverRegistry.registerAll(event);
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            LOGGER.info("Registering blocks...");
            blockEvent = event;
            WoodRegistry woodRegistry = new WoodRegistry();
            FlowerRegistry flowerRegistry = new FlowerRegistry();
            SaplingRegistry saplingRegistry = new SaplingRegistry();
            FurnitureRegistry furnitureRegistry = new FurnitureRegistry();
            GrassRegistry grassRegistry = new GrassRegistry();
            BuildingRegistry buildingRegistry = new BuildingRegistry();
            OtherRegistry otherRegistry = new OtherRegistry();
            OreRegistry oreRegistry = new OreRegistry();
            WNRegistry.registerBlocks(event, woodRegistry.getWoods());
            WNRegistry.registerBlocks(event, furnitureRegistry.getBlock());
            WNRegistry.registerBlocks(event, saplingRegistry.getSaplings());
            WNRegistry.registerBlocks(event, rockRegistry.getRocks());
            WNRegistry.registerBlocks(event, oreRegistry.getOres());
            WNRegistry.registerBlocks(event, flowerRegistry.getFlowers());
            WNRegistry.registerBlocks(event, grassRegistry.getGrass());
            WNRegistry.registerBlocks(event, buildingRegistry.getBlocks());
            WNRegistry.registerBlocks(event, rockRegistry.getDecos());
            WNRegistry.registerBlocks(event, otherRegistry.getBlock());
        }

        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            LOGGER.info("Registering biomes...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{WNBiomes.River, WNBiomes.FrozenRiver, WNBiomes.AmazonRiver, WNBiomes.NileRiver, WNBiomes.CanyonRiver, WNBiomes.IcelandRiver, WNBiomes.DaintreeRiver, WNBiomes.TatraStream});
            for (int x = 0; x < WNBiomes.registerBiomes.size(); ++x) {
                Biome b = WNBiomes.registerBiomes.get(x);
                event.getRegistry().register((IForgeRegistryEntry)b);
            }
            WNBiomes.registerBiomes();
        }

        @SubscribeEvent
        public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
            LOGGER.info("Registering particles...");
            BasicParticleType type = ParticleRegistry.DUNGEON_HEART;
            type = ParticleRegistry.CRYSTAL_SPARK;
            type = ParticleRegistry.GEYSER;
            type = ParticleRegistry.STEAM;
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> evt) {
            LOGGER.info("Registering tileEntities...");
            TileEntityType piston_type = TileEntityType.Builder.func_223042_a(CustomPistonTileEntity::new, (Block[])new Block[]{WNBlocks.RS_PISTON1_MOVING}).func_206865_a(null);
            piston_type.setRegistryName(Main.modid, "rs_piston1");
            evt.getRegistry().register((IForgeRegistryEntry)piston_type);
            initGuis.PISTON_TYPE = piston_type;
            TileEntityType dungeonCommander = TileEntityType.Builder.func_223042_a(DungeonCommanderTileEntity::new, (Block[])new Block[]{WNBlocks.DUNGEON_COMMANDER}).func_206865_a(null);
            dungeonCommander.setRegistryName(Main.modid, "dungeon_commander");
            evt.getRegistry().register((IForgeRegistryEntry)dungeonCommander);
            initGuis.DUNGEON_COMMANDER = dungeonCommander;
            TileEntityType hydrothermalVent = TileEntityType.Builder.func_223042_a(HydrothermalVentTileEntity::new, (Block[])new Block[]{WNBlocks.HYDROTHERMAL_VENT}).func_206865_a(null);
            hydrothermalVent.setRegistryName(Main.modid, "hydrothermal_vent");
            evt.getRegistry().register((IForgeRegistryEntry)hydrothermalVent);
            initGuis.HYDROTHERMAL_VENT_TILE_ENTITY = hydrothermalVent;
            TileEntityType gravityShroom = TileEntityType.Builder.func_223042_a(GravityShroomTileEntity::new, (Block[])new Block[]{WNBlocks.GRAVITYSHROOM}).func_206865_a(null);
            gravityShroom.setRegistryName(Main.modid, "gravityshroom");
            evt.getRegistry().register((IForgeRegistryEntry)gravityShroom);
            initGuis.GRAVITY_SHROOM_TILE_ENTITY = gravityShroom;
            TileEntityType itemTile = TileEntityType.Builder.func_223042_a(ItemTileEntity::new, (Block[])ItemTileEntity.SUPPORTED_BLOCKS.toArray(new Block[0])).func_206865_a(null);
            itemTile.setRegistryName(Main.modid, "item_tile_entity");
            evt.getRegistry().register((IForgeRegistryEntry)itemTile);
            initGuis.ITEM_TILE_ENTITY = itemTile;
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            LOGGER.info("Registering containers...");
            RegistryEvents.registerContainer("wildnature:pouch", PouchContainer::new);
            CONTAINER_TYPES.forEach(container_type -> event.getRegistry().register((IForgeRegistryEntry)container_type));
        }

        private static <T extends Container> void registerContainer(String name, IContainerFactory<T> container) {
            ContainerType type = IForgeContainerType.create(container);
            type.setRegistryName(name);
            CONTAINER_TYPES.add(type);
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            LOGGER.info("Registering sounds...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])SoundRegistry.register());
        }

        public static ResourceLocation location(String name) {
            return new ResourceLocation(Main.modid, name);
        }

        static {
            rockRegistry = new RockRegistry();
            CONTAINER_TYPES = new ArrayList();
        }
    }
}

