/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.other;

import java.util.ArrayList;
import java.util.function.Consumer;

public class WeightedList<T> {
    private ArrayList<T> objects = new ArrayList();
    private ArrayList<Integer> rarity = new ArrayList();

    public void add(T obj, int rarity) {
        this.objects.add(obj);
        this.rarity.add(rarity);
    }

    public void clear() {
        this.objects.clear();
        this.rarity.clear();
    }

    public int getRarityFor(T obj) {
        return this.checkIfEquals() ? this.rarity.get(this.objects.indexOf(obj)) : -1;
    }

    public boolean isEmpty() {
        return this.checkIfEquals() && this.objects.isEmpty();
    }

    public Integer size() {
        if (this.checkIfEquals()) {
            return this.objects.size();
        }
        throw new NullPointerException("Array sizes don't match! " + this.objects.size() + "/" + this.rarity.size());
    }

    public boolean checkIfEquals() {
        return this.objects.size() == this.rarity.size();
    }

    public ArrayList<Integer> getRarity() {
        return this.rarity;
    }

    public ArrayList<T> getObjects() {
        return this.objects;
    }

    public ArrayList<T> getSimplifedArray() {
        ArrayList<T> simplified = new ArrayList<T>();
        for (int x = 0; x < this.size(); ++x) {
            int a = this.getRarity().get(x);
            for (int z = 0; z < a; ++z) {
                simplified.add(this.getObjects().get(x));
            }
        }
        return simplified;
    }

    public void forEach(Consumer<? super T> action) {
        this.objects.forEach((Consumer<T>)action);
    }
}

