/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup;

import com.matez.wildnature.init.Main;
import com.matez.wildnature.util.other.BlockWeighList;
import com.matez.wildnature.util.other.TreeWeighList;
import com.matez.wildnature.world.generation.biome.setup.LogType;
import com.matez.wildnature.world.generation.biome.setup.WNBiomeBuilder;
import com.matez.wildnature.world.generation.biome.setup.WNBiomes;
import com.matez.wildnature.world.generation.feature.FeatureRegistry;
import com.matez.wildnature.world.generation.feature.configs.BlockWeightListConfig;
import com.matez.wildnature.world.generation.feature.configs.TreeWeightListConfig;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class WNBiome
extends Biome {
    public WNBiomeBuilder wnBiomeBuilder;
    public BlockWeighList plants = new BlockWeighList();
    public int plantRate = 1;
    public TreeWeighList trees = new TreeWeighList();
    public int treeRate = 6;
    public float treeExtraChance = 0.1f;
    public int treeExtra = 1;
    public final ArrayList<LogType> logTypes;

    private static Biome.Builder analyseBuilder(Biome.Builder builder) {
        WNBiomeBuilder wnbuilder = (WNBiomeBuilder)builder;
        if (wnbuilder.getFog() == null) {
            wnbuilder.fog(new WNBiomeBuilder.Fog(1, -1, -1.0f));
        }
        if (wnbuilder.getTopography() == null) {
            wnbuilder.topography(wnbuilder.getUnknownTopography());
        }
        if (wnbuilder.getClimate() == null) {
            wnbuilder.climate(wnbuilder.getUnknownClimate());
        }
        return wnbuilder;
    }

    public static WNBiomeBuilder getWNBuilder(Biome.Builder builder) {
        WNBiomeBuilder wnbuilder = (WNBiomeBuilder)builder;
        if (wnbuilder.getFog() == null) {
            wnbuilder.fog(new WNBiomeBuilder.Fog(1, -1, -1.0f));
        }
        if (wnbuilder.getTopography() == null) {
            wnbuilder.topography(wnbuilder.getUnknownTopography());
        }
        if (wnbuilder.getClimate() == null) {
            wnbuilder.climate(wnbuilder.getUnknownClimate());
        }
        return wnbuilder;
    }

    public WNBiome(String name, WNBiomeBuilder biomeBuilder) {
        super(biomeBuilder.getBiomeBuilder());
        this.wnBiomeBuilder = biomeBuilder;
        this.setRegistryName(Main.RegistryEvents.location(name));
        WNBiomes.registerBiomes.add(this);
        WNBiomes.biomesString.add(this.getRegistryName().func_110623_a());
        this.logTypes = biomeBuilder.getLogTypes();
    }

    public ArrayList<LogType> getLogTypes() {
        return this.logTypes;
    }

    public void applyPlants() {
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockWeightListConfig(this.plants)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(this.plantRate))));
    }

    public void applyTrees() {
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.TREE_FEATURE.func_225566_b_((IFeatureConfig)new TreeWeightListConfig(this.trees)).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(this.treeRate, this.treeExtraChance, this.treeExtra))));
    }

    public int getCelsiusTemperature(float temp) {
        return (int)(temp * 100.0f) - 15;
    }

    public int customColor(double noise, double modifier, int color1, int color2) {
        return noise < modifier ? color1 : color2;
    }

    public int customColor3x(double noise, double modFrom, double modTo, int color1, int color2, int color3) {
        if (noise < modFrom) {
            return color1;
        }
        if (noise > modTo) {
            return color2;
        }
        return color3;
    }

    public int func_225528_a_(double x, double z) {
        return this.getGrassColor(new BlockPos(x, 0.0, z));
    }

    public int getGrassColor(BlockPos pos) {
        return super.func_225528_a_((double)pos.func_177958_n(), (double)pos.func_177952_p());
    }

    public int func_225527_a_() {
        return this.getFoliageColor(new BlockPos(0, 0, 0));
    }

    public int getFoliageColor(BlockPos pos) {
        return super.func_225527_a_();
    }
}

