/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup;

import com.google.common.collect.Lists;
import com.matez.wildnature.common.blocks.FloweringBushBase;
import com.matez.wildnature.common.blocks.FormationBase;
import com.matez.wildnature.common.blocks.FormationType;
import com.matez.wildnature.common.blocks.RockBase;
import com.matez.wildnature.common.blocks.SaltOreBlock;
import com.matez.wildnature.init.Main;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.BlockWeighList;
import com.matez.wildnature.util.other.TreeWeighList;
import com.matez.wildnature.util.other.WeightedList;
import com.matez.wildnature.world.generation.biome.setup.LogType;
import com.matez.wildnature.world.generation.biome.setup.WNBiome;
import com.matez.wildnature.world.generation.biome.setup.WNBiomes;
import com.matez.wildnature.world.generation.carvers.CarverRegistry;
import com.matez.wildnature.world.generation.feature.FeatureRegistry;
import com.matez.wildnature.world.generation.feature.configs.BlockFeatureConfig;
import com.matez.wildnature.world.generation.feature.configs.BlockVeinFeatureConfig;
import com.matez.wildnature.world.generation.feature.configs.BlockWeightListAndSpawnChanceConfig;
import com.matez.wildnature.world.generation.feature.configs.ReverseBushConfig;
import com.matez.wildnature.world.generation.feature.configs.StructureWeightListConfig;
import com.matez.wildnature.world.generation.feature.configs.TreeWeightListConfig;
import com.matez.wildnature.world.generation.feature.configs.WNBlobConfig;
import com.matez.wildnature.world.generation.feature.configs.WNOreFeatureConfig;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue1;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue2;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue3;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue4;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue5;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue6;
import com.matez.wildnature.world.generation.structures.dungeons.easter.estatue7;
import com.matez.wildnature.world.generation.structures.nature.FallenRegistry;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import com.matez.wildnature.world.generation.structures.nature.fallen.FallenSchemFeature;
import com.matez.wildnature.world.generation.structures.nature.rocks.basalt_rock;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_1;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_2;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_3;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_4;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_5;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_6;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_7;
import com.matez.wildnature.world.generation.structures.nature.rocks.big_rock_8;
import com.matez.wildnature.world.generation.structures.nature.rocks.conglomerate_rock;
import com.matez.wildnature.world.generation.structures.nature.rocks.gneiss_rock;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock1;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock2;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock3;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock4;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock5;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock6;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock7;
import com.matez.wildnature.world.generation.structures.nature.rocks.rock8;
import com.matez.wildnature.world.generation.structures.nature.rocks.slate_rock;
import com.matez.wildnature.world.generation.structures.nature.woods.glowing_cave_oak.GlowingCaveOakSpawner;
import com.matez.wildnature.world.generation.structures.nature.woods.glowshroom.GlowshroomSpawner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.state.IProperty;
import net.minecraft.world.biome.BeachBiome;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureConfig;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;

public class WNBiomeFeatures
extends DefaultBiomeFeatures {
    public static ArrayList<Biome> defaultPlantBlacklist = new ArrayList();
    public static ArrayList<Biome> lakeBiomes = new ArrayList();
    public static ArrayList<Biome> springBiomes = new ArrayList();

    public static void removeAllDefaultFlowers(Biome biomeIn) {
        defaultPlantBlacklist.add(biomeIn);
    }

    public static void addMineshafts(Biome biomeIn, MineshaftStructure.Type type) {
        biomeIn.func_226711_a_(Feature.field_202329_g.func_225566_b_((IFeatureConfig)new MineshaftConfig(0.004, type)));
    }

    public static void addStrongholds(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_202335_m.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addVillages(Biome biomeIn, String villageType, int size) {
        biomeIn.func_226711_a_(Feature.field_214550_p.func_225566_b_((IFeatureConfig)new VillageConfig(villageType, size)));
    }

    public static void addPillagerOutposts(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_214536_b.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addDesertPyramids(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_202332_j.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addIgloos(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_202333_k.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addJungleTemples(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Feature.field_202331_i.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addShipwrecks(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_204751_l.func_225566_b_((IFeatureConfig)new ShipwreckConfig(true)));
    }

    public static void addBuriedTreasures(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_214549_o.func_225566_b_((IFeatureConfig)new BuriedTreasureConfig(0.01f)));
    }

    public static void addWoodlandMansions(Biome biomeIn) {
        biomeIn.func_226711_a_(Feature.field_202330_h.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addSwampHuts(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Feature.field_202334_l.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addBerryBushes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SCATTERED_PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig((BlockState)Blocks.field_222434_lW.func_176223_P().func_206870_a((IProperty)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(3)))).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addGrass(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_150349_c.func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(9))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:medium_grass").func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:small_grass").func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addLotsOfGrass(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_150349_c.func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(14))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:medium_grass").func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(6))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:small_grass").func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.DOUBLE_GRASS_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_196804_gh.func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
    }

    public static void addBlob(Biome biomeIn, BlockState block, int startRadius, boolean surfaceBlob, boolean undergroundBlob, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FeatureRegistry.BLOB_FEATURE.func_225566_b_((IFeatureConfig)new WNBlobConfig(block, startRadius, surfaceBlob, undergroundBlob)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addBlobWithCountRangePlacement(Biome biomeIn, BlockState block, int startRadius, boolean surfaceBlob, boolean undergroundBlob, int count, int bottom, int top) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FeatureRegistry.BLOB_FEATURE.func_225566_b_((IFeatureConfig)new WNBlobConfig(block, startRadius, surfaceBlob, undergroundBlob)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, bottom, 0, top))));
    }

    public static void addTatraStoneTypes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150351_n.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 0, 0, 256))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196650_c.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(16, 0, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196654_e.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 0, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196656_g.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 0, 0, 80))));
    }

    public static void addLavender(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.LAVENDER_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(77))));
    }

    public static void addGeysers(Biome biomeIn, int count) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GEYSER_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, 64, 0, 90))));
    }

    public static void addMarigold(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.MARIGOLD_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(90))));
    }

    public static void addMelons(Biome biomeIn, int count) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.MELON_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }

    public static void addWisterias(Biome biomeIn, int count) {
        biomeIn.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, FeatureRegistry.WISTERIA_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(WNBlocks.WISTERIA_PINK.func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, 65, 0, 80))));
    }

    public static void addTreeVines(Biome biomeIn, BlockState vine, int count, int maxHeight) {
        biomeIn.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, FeatureRegistry.TREE_VINES_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(vine)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, 65, 0, maxHeight))));
    }

    public static void addBlob(Biome biomeIn, BlockState block, int startRadius, boolean surfaceBlob, boolean undergroundBlob, boolean flatInTerrain, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FeatureRegistry.BLOB_FEATURE.func_225566_b_((IFeatureConfig)new WNBlobConfig(block, startRadius, surfaceBlob, undergroundBlob, flatInTerrain)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addCattail(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.CATTAIL_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addCactus(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.CACTUS_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addDeadBushes(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.DEAD_BUSH_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addMoai(Biome biomeIn) {
        WeightedList<SchemFeature> moais = new WeightedList<SchemFeature>();
        moais.add(new estatue1(), 1);
        moais.add(new estatue2(), 1);
        moais.add(new estatue3(), 1);
        moais.add(new estatue4(), 1);
        moais.add(new estatue5(), 1);
        moais.add(new estatue6(), 1);
        moais.add(new estatue7(), 1);
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureRegistry.STRUCTURE_FEATURE.func_225566_b_((IFeatureConfig)new StructureWeightListConfig(moais)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(7, 70, 0, 80))));
    }

    public static void addBigRocks(Biome biomeIn) {
        WeightedList<SchemFeature> rocks = new WeightedList<SchemFeature>();
        rocks.add(new big_rock_1(), 1);
        rocks.add(new big_rock_2(), 1);
        rocks.add(new big_rock_3(), 1);
        rocks.add(new big_rock_4(), 1);
        rocks.add(new big_rock_5(), 1);
        rocks.add(new big_rock_6(), 1);
        rocks.add(new big_rock_7(), 1);
        rocks.add(new big_rock_8(), 1);
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureRegistry.STRUCTURE_FEATURE.func_225566_b_((IFeatureConfig)new StructureWeightListConfig(rocks)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 64, 0, 130))));
    }

    public static void addRocks(Biome biomeIn) {
        WeightedList<SchemFeature> rocks = new WeightedList<SchemFeature>();
        rocks.add(new rock1(), 1);
        rocks.add(new rock2(), 1);
        rocks.add(new rock3(), 1);
        rocks.add(new rock4(), 1);
        rocks.add(new rock5(), 1);
        rocks.add(new rock6(), 1);
        rocks.add(new rock7(), 1);
        rocks.add(new rock8(), 1);
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureRegistry.STRUCTURE_FEATURE.func_225566_b_((IFeatureConfig)new StructureWeightListConfig(rocks)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(80, 64, 0, 90))));
    }

    public static void addSunflowers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.DOUBLE_PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_196800_gd.func_176223_P())).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
    }

    public static void addHugeMushrooms(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(Feature.field_202318_R.func_225566_b_((IFeatureConfig)field_226767_ab_), Feature.field_202319_S.func_225566_b_((IFeatureConfig)field_226768_ac_))).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addSinglePlantFeature(Biome biomeIn, BlockWeighList list, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SINGLE_PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockWeightListAndSpawnChanceConfig(list, 0)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addFreezeLeaf(Biome biomeIn, int count) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.LEAF_FREEZE_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(count)).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(50, 60, 0, 150))));
    }

    public static void addCandyCane(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FeatureRegistry.CANDY_CANE_FEATURE.func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addScatteredPlant(Biome biomeIn, BlockState state, int chance) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SCATTERED_PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(state)).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(chance))));
    }

    public static void addSeagrass(Biome biomeIn, int count) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(count, 0.4)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addSeagrass(Biome biomeIn, int count, double tallProbability) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(count, tallProbability)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addMushrooms(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_150338_P.func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_150337_Q.func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom1").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom2").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom4").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom5").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom6").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom7").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom8").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom9").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:psilocybin_mushroom").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(1))));
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:mushroom3").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:fuzzball").func_176223_P())).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(1))));
    }

    public static void addLakes(Biome biomeIn) {
        lakeBiomes.add(biomeIn);
    }

    public static void addSprings(Biome p_222337_0_) {
        springBiomes.add(p_222337_0_);
    }

    public static void addGrass(Biome biomeIn, int rate) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_150349_c.func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(rate))));
    }

    public static void addGrass(Biome biomeIn, int rate, BlockState grass) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.GRASS.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(grass)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(rate))));
    }

    public static void addGrass(Biome biomeIn, int rate, BlockState grass, boolean isDouble) {
        if (isDouble) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.DOUBLE_GRASS_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(grass)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(rate))));
        } else {
            WNBiomeFeatures.addGrass(biomeIn, rate, grass);
        }
    }

    public static void addPlant(Biome biomeIn, BlockState state, int frequency) {
        if (biomeIn instanceof WNBiome) {
            ((WNBiome)biomeIn).plants.add(state, frequency);
        }
    }

    public static void addDoublePlant(Biome biomeIn, BlockState state, int frequency) {
        if (biomeIn instanceof WNBiome) {
            ((WNBiome)biomeIn).plants.add(state, frequency);
        }
    }

    public static void addFloodedForestDecorations(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(128, 0.6)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(Blocks.field_150435_aG.func_176223_P(), 4, 1, (List)Lists.newArrayList((Object[])new BlockState[]{Main.getBlockByID("wildnature:mold_dirt").func_176223_P()}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addWaterlilies(Biome biome, Block waterlily, int count) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.WATERLILY_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(waterlily.func_176223_P())).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }

    public static void addWaterlilies(Biome biome, BlockState waterlily, int count) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.WATERLILY_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(waterlily)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }

    public static void addTree(Biome biomeIn, SchemFeature tree, int frequency) {
        if (biomeIn instanceof WNBiome) {
            ((WNBiome)biomeIn).trees.add(tree, frequency);
        }
    }

    public static void addNewStoneVariants(Biome biomeIn) {
        int seaLevel = 40;
        int worldHeight = 255;
        ArrayList<Block> rocks = new ArrayList<Block>(Arrays.asList(Main.RegistryEvents.rockRegistry.rocks));
        for (int i = 0; i < rocks.size(); ++i) {
            Block b = Main.getBlockByID(rocks.get(i).getRegistryName().toString());
            RockBase r = null;
            if (!(b instanceof RockBase)) continue;
            r = (RockBase)b;
            if (!((Boolean)CommonConfig.generateRocks.get()).booleanValue()) continue;
            boolean gen = true;
            if (!((Boolean)CommonConfig.genBasalt.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("basalt")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genGneiss.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("gneiss")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genMarble.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("marble")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genLimestone.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("limestone")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.getQuartzite.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("quartzite")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genBlueSlate.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("slate_blue")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genPurpleSlate.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("slate_purple")) {
                gen = false;
            }
            if (!gen) continue;
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, b.func_176223_P(), r.getSize())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(r.getCount(), r.getMinYByType(seaLevel), 0, r.getMaxYByType(seaLevel, worldHeight)))));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150403_cj.func_176223_P(), (Integer)CommonConfig.rockSize.get() * 2)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.rockChance.get()).intValue(), 25, 0, seaLevel - seaLevel / 4))));
        }
    }

    public static void addCarvers(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(CarverRegistry.CAVE_CARVER, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    public static void addCaveVines(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM && BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.JUNGLE)) {
            if (biomeIn != WNBiomes.Polders) {
                biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_VINE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 10, 0, 35))));
                biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.VINES_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Blocks.field_150395_bd.func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 10, 0, 35))));
            }
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_VINE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 10, 0, 35))));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.MEDIUM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_VINE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 10, 0, 35))));
        }
    }

    public static void addCrystals(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CRYSTAL_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 10, 0, 35))));
        }
    }

    public static void addCobweb(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.COBWEB_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(30, 10, 0, 35))));
        }
    }

    public static void addStalagmites(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.STALAGMITE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(100, 10, 0, 50))));
        }
    }

    public static void addPebbles(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.PEBBLE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(70, 10, 0, 50))));
        }
    }

    public static void addNewOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.TIN_ORE.func_176223_P(), 7)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.tinRarity.get()).intValue(), 40, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.COPPER_ORE.func_176223_P(), 6)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.copperRarity.get()).intValue(), 0, 0, 70))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, (BlockState)WNBlocks.SALT_ORE.func_176223_P().func_206870_a(SaltOreBlock.SALT_VARIANT, (Comparable)((Object)SaltOreBlock.SaltVariant.STONE)), 5)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.saltStoneRarity.get()).intValue(), 20, 0, 55))));
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.SAPPHIRE_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.SMALL)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.sapphireSmallRarity.get()).intValue(), 0, 0, 40))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.SAPPHIRE_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.SMALL)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.sapphireBigRarity.get()).intValue(), 0, 0, 30))));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.RUBY_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.SMALL)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.rubySmallRarity.get()).intValue(), 0, 0, 40))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.RUBY_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.SMALL)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.rubyBigRarity.get()).intValue(), 0, 0, 30))));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.AMETHYST_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.SMALL)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.amethystSmallRarity.get()).intValue(), 0, 0, 14))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.AMETHYST_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.BIG)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.amethystBigRarity.get()).intValue(), 0, 0, 10))));
        if (biomeIn instanceof BeachBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.ORE_FEATURE.func_225566_b_((IFeatureConfig)new WNOreFeatureConfig(WNOreFeatureConfig.FillerBlockType.SAND, WNBlocks.AMBER_ORE.func_176223_P(), 3)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.amberRarity.get()).intValue(), 50, 0, 65))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.ORE_FEATURE.func_225566_b_((IFeatureConfig)new WNOreFeatureConfig(WNOreFeatureConfig.FillerBlockType.SAND, (BlockState)WNBlocks.SALT_ORE.func_176223_P().func_206870_a(SaltOreBlock.SALT_VARIANT, (Comparable)((Object)SaltOreBlock.SaltVariant.SAND)), 7)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.saltSandRarity.get()).intValue(), 50, 0, 65))));
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.RIVER) || BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.OCEAN)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FeatureRegistry.GEM_FORMATION_FEATURE.func_225566_b_((IFeatureConfig)new BlockVeinFeatureConfig((BlockState)WNBlocks.MALACHITE_FORMATION.func_176223_P().func_206870_a(FormationBase.TYPE, (Comparable)((Object)FormationType.SMALL)), 1, 1)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.malachiteRarity.get()).intValue(), 0, 0, 40))));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.SILVER_ORE.func_176223_P(), 6)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.silverRarity.get()).intValue(), 20, 0, 35))));
    }

    public static void addRockFormations(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new basalt_rock().func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 64, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new conglomerate_rock().func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 64, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new gneiss_rock().func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 64, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, new slate_rock().func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 64, 0, 80))));
    }

    public static void addRiverCane(Biome biomeIn) {
        if (biomeIn.func_76736_e() || BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.RIVER) || biomeIn == WNBiomes.River || biomeIn == WNBiomes.AmazonRiver || biomeIn == WNBiomes.NileRiver || biomeIn == WNBiomes.TropicalLake || biomeIn == WNBiomes.WarmLake || biomeIn == WNBiomes.MangroveForest) {
            biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureRegistry.RIVER_CANE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.riverCaneRarity.get()).intValue(), 55, 0, 65))));
        }
    }

    public static void addRiverPlants(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.RIVER) || biomeIn == WNBiomes.River || biomeIn == WNBiomes.AmazonRiver || biomeIn == WNBiomes.NileRiver || biomeIn == WNBiomes.TropicalLake || biomeIn == WNBiomes.WarmLake || biomeIn == WNBiomes.ColdLake) {
            biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureRegistry.REEDS_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.riverCaneRarity.get()).intValue(), 55, 0, 65))));
        }
    }

    public static void addFruits(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.FRUIT_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.fruitBushRarity.get()).intValue(), 64, 0, 100))));
    }

    public static void addVeggies(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.VEGE_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.vegeCropRarity.get()).intValue(), 64, 0, 100))));
    }

    public static void addPoisonIves(Biome biomeIn) {
        BlockWeighList l = new BlockWeighList();
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            l.add((BlockState)Main.getBlockByID("wildnature:poison_ivy").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
            l.add((BlockState)Main.getBlockByID("wildnature:spidergrass").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM || biomeIn.func_150561_m() == Biome.TempCategory.MEDIUM) {
            l.add((BlockState)Main.getBlockByID("wildnature:grass_thistle").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
        }
        if (biomeIn.func_150561_m() != Biome.TempCategory.COLD) {
            l.add((BlockState)Main.getBlockByID("wildnature:nettle").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 2);
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SINGLE_PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockWeightListAndSpawnChanceConfig(l, 5)).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(((Integer)CommonConfig.poisonIvyRarity.get()).intValue()))));
    }

    public static void addSmallCacti(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.SANDY) && biomeIn.func_150561_m() == Biome.TempCategory.WARM && biomeIn != Biomes.field_76787_r && biomeIn != WNBiomes.TintedDesert && biomeIn != WNBiomes.TintedDesertHills || biomeIn == WNBiomes.WhiteBeach || biomeIn == WNBiomes.Oasis) {
            BlockWeighList l = new BlockWeighList();
            l.add(Main.getBlockByID("wildnature:small_cacti").func_176223_P(), 1);
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SINGLE_PLANT_FEATURE.func_225566_b_((IFeatureConfig)new BlockWeightListAndSpawnChanceConfig(l, 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(((Integer)CommonConfig.smallCactiRarity.get()).intValue()))));
        }
    }

    public static void addCavePlants(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:icycle").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 35, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:large_icycle").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 40, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:ice_grass").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(35, 30, 0, 45))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:ice_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 30, 0, 45))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 10, 0, 45))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_blue").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_green").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_blue").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_green").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:sunshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 10, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.LAVALILY_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(WNBlocks.MAGMA_PAD.func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 2, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_STAR_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:cave_star").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(9, 15, 0, 23))));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(11, 10, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.DOUBLE_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new ReverseBushConfig(Main.getBlockByID("wildnature:large_glowshroom").func_176223_P(), false)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 10, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_blue").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_green").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_blue").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.SLIME_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_green").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:sunshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 10, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.LAVALILY_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(WNBlocks.MAGMA_PAD.func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(9, 2, 0, 20))));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:poison_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 10, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:sulfur_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 20, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:dragon_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 10, 0, 15))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:gravityshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 5, 0, 20))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_STAR_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:cave_star").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 15, 0, 23))));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:sulfur_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 20, 0, 50))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:dragon_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 10, 0, 15))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.JELLYSHROOM_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:jellyshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 2, 0, 15))));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:stone_grass").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(40, 10, 0, 50))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:stalagmite").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 10, 0, 50))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:stalactite").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 10, 0, 50))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.DOUBLE_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new ReverseBushConfig(Main.getBlockByID("wildnature:large_stalagmite").func_176223_P(), false)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 10, 0, 50))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.DOUBLE_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new ReverseBushConfig(Main.getBlockByID("wildnature:large_stalactite").func_176223_P(), true)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 10, 0, 50))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:roots").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 55, 0, 52))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.DOUBLE_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new ReverseBushConfig(Main.getBlockByID("wildnature:large_root").func_176223_P(), true)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 55, 0, 52))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:magma_shroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 5, 0, 16))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:glowing_shadowshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 3, 0, 10))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:cave_lily").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 5, 0, 20))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.UNDERWATER_CAVE_BUSH_FEATURE.func_225566_b_((IFeatureConfig)new BlockFeatureConfig(Main.getBlockByID("wildnature:tubeshroom").func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 2, 0, 12))));
    }

    public static void addGlowingCaveOaks(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, new GlowingCaveOakSpawner(NoFeatureConfig::func_214639_a, false, true).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 5, 0, 35))));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.WARM && biomeIn.func_201856_r() != Biome.Category.DESERT && biomeIn.func_201856_r() != Biome.Category.MESA) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, new GlowingCaveOakSpawner(NoFeatureConfig::func_214639_a, false, false).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 5, 0, 35))));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, new GlowingCaveOakSpawner(NoFeatureConfig::func_214639_a, false, false).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 5, 0, 35))));
        }
    }

    public static void addGlowshrooms(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM && biomeIn.func_201856_r() != Biome.Category.DESERT && biomeIn.func_201856_r() != Biome.Category.MESA) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, new GlowshroomSpawner(NoFeatureConfig::func_214639_a, false).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(7, 5, 0, 45))));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, new GlowshroomSpawner(NoFeatureConfig::func_214639_a, false).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 5, 0, 35))));
        }
    }

    public static void addWater(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, FeatureRegistry.WATER_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(24)).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(50, 60, 0, 150))));
    }

    public static void addWater(Biome biomeIn, int count) {
        biomeIn.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, FeatureRegistry.WATER_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(count)).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(50, 60, 0, 150))));
    }

    public static void addShells(Biome biomeIn) {
        if (biomeIn == Biomes.field_76787_r || biomeIn == WNBiomes.WhiteBeach) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.SHELL_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.shellRarity.get()).intValue(), 50, 0, 69))));
        }
    }

    public static void addMoss(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.MOSS_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(32)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.mossRarityDense.get()).intValue(), 64, 0, 180))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.LICHEN_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(32)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.treeLichenRarityDense.get()).intValue(), 64, 0, 180))));
        } else if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.MOSS_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.mossRarity.get()).intValue(), 64, 0, 180))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.LICHEN_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.treeLichenRarityDense.get()).intValue(), 64, 0, 180))));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, FeatureRegistry.MOSS_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(64)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.mossRarityDense.get()).intValue(), 10, 0, 40))));
        }
    }

    public static void addBeehives(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE)) {
                biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BEEHIVE_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(4)).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(63, 60, 0, 150))));
            } else {
                biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.BEEHIVE_FEATURE.func_225566_b_((IFeatureConfig)new CountConfig(8)).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(63, 60, 0, 150))));
            }
        }
    }

    public static void addFallenTrees(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            boolean isDense = BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE);
            TreeWeighList trees = new TreeWeighList();
            ArrayList<LogType> logTypes = biomeIn instanceof WNBiome ? ((WNBiome)biomeIn).getLogTypes() : new ArrayList();
            for (LogType logType : logTypes) {
                for (FallenSchemFeature fallenSchemFeature : FallenRegistry.getTreesFor(logType)) {
                    trees.add(fallenSchemFeature, 1);
                }
            }
            if (trees.size() != 0) {
                biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FeatureRegistry.TREE_FEATURE.func_225566_b_((IFeatureConfig)new TreeWeightListConfig(trees)).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(isDense ? 0 : 0, isDense ? 0.6f : 0.3f, isDense ? 1 : 1))));
            }
        }
    }

    public static void addDefaultFlowersForBiome(Biome biomeIn) {
        if (defaultPlantBlacklist.contains(biomeIn)) {
            return;
        }
        Biome.TempCategory category = biomeIn.func_150561_m();
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST) && !BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.JUNGLE) && !BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS)) {
            if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE)) {
                if (category == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_BLUE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_WHITE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PINK.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PURPLE.func_176223_P(), 1);
                } else {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_PINK.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_PURPLE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_WHITE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.ANEMONE.func_176223_P(), 2);
                if (category == Biome.TempCategory.MEDIUM) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PRIMROSE_WHITE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PRIMROSE_BLUE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.FORGET_ME_NOT_BLUE.func_176223_P(), 1);
                if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SNOWDROP.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BLUEBELL.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATH_PURPLE.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATH_PINK.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATH_WHITE.func_176223_P(), 2);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GRASS_FERNSPROUT.func_176223_P(), 3);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB.func_176223_P(), 4);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB_TALL.func_176223_P(), 4);
            } else {
                if (category == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PURPLE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PINK.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_VIOLET.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.VIOLET_PURPLE.func_176223_P(), 1);
                } else {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_YELLOW.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_WHITE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.ANEMONE.func_176223_P(), 1);
                if (category == Biome.TempCategory.MEDIUM) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PRIMROSE_PINK.func_176223_P(), 2);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.FORGET_ME_NOT_PINK.func_176223_P(), 1);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GRASS_FERNSPROUT.func_176223_P(), 3);
                if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SNOWDROP.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BLUEBELL.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_PURPLE.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_PINK.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_WHITE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_YELLOW.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.VIOLET_PURPLE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB.func_176223_P(), 2);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB_TALL.func_176223_P(), 2);
            }
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.WILD_ROSE.func_176223_P(), 1);
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS) && !BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.JUNGLE)) {
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.CHAMOMILE_WHITE.func_176223_P(), 2);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.CHAMOMILE_DOUBLE_WHITE.func_176223_P(), 1);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GOLDENROD.func_176223_P(), 3);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.TANSY.func_176223_P(), 1);
            if (category == Biome.TempCategory.MEDIUM) {
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.CATNIP.func_176223_P(), 2);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BUTTERCUP_YELLOW.func_176223_P(), 1);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.FORGET_ME_NOT_WHITE.func_176223_P(), 1);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GIANT_HOGWEED.func_176223_P(), 2);
            }
            if (category == Biome.TempCategory.COLD) {
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.VIOLET_PURPLE.func_176223_P(), 2);
            }
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BOXWOOD.func_176223_P(), 3);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB.func_176223_P(), 1);
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS) && BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.WET)) {
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.MISCANTHUS_GRASS.func_176223_P(), 2);
        }
    }
}

