/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup;

import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.biome.setup.WNBiomeFeatures;
import com.matez.wildnature.world.generation.feature.features.WNFruitFeature;
import com.matez.wildnature.world.generation.feature.features.WNVegeFeature;
import net.minecraft.block.Blocks;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class WNGlobalBiomeFeatures {
    public static void setup() {
        WNFruitFeature.init();
        WNVegeFeature.init();
        Registry.field_212624_m.forEach(biome -> {
            WNBiomeFeatures.addMushrooms(biome);
            WNBiomeFeatures.addDefaultFlowersForBiome(biome);
            if (((Boolean)CommonConfig.generateVines.get()).booleanValue()) {
                WNBiomeFeatures.addCaveVines(biome);
            }
            if (((Boolean)CommonConfig.generateCrystals.get()).booleanValue()) {
                WNBiomeFeatures.addCrystals(biome);
            }
            if (((Boolean)CommonConfig.generateStalagmites.get()).booleanValue()) {
                WNBiomeFeatures.addStalagmites(biome);
            }
            if (((Boolean)CommonConfig.generatePebbles.get()).booleanValue()) {
                WNBiomeFeatures.addPebbles(biome);
            }
            if (((Boolean)CommonConfig.generateCobweb.get()).booleanValue()) {
                WNBiomeFeatures.addCobweb(biome);
            }
            if (((Boolean)CommonConfig.generateRockFormations.get()).booleanValue()) {
                WNBiomeFeatures.addRockFormations(biome);
            }
            if (((Boolean)CommonConfig.generateFruitBushes.get()).booleanValue()) {
                WNBiomeFeatures.addFruits(biome);
            }
            if (((Boolean)CommonConfig.generateVegeCrops.get()).booleanValue()) {
                WNBiomeFeatures.addVeggies(biome);
            }
            if (((Boolean)CommonConfig.generatePoisonIves.get()).booleanValue()) {
                WNBiomeFeatures.addPoisonIves(biome);
            }
            if (((Boolean)CommonConfig.generateOres.get()).booleanValue()) {
                WNBiomeFeatures.addNewOres(biome);
            }
            if (((Boolean)CommonConfig.generateUndergroundPlants.get()).booleanValue()) {
                WNBiomeFeatures.addCavePlants(biome);
            }
            if (((Boolean)CommonConfig.generateRiverCanes.get()).booleanValue()) {
                WNBiomeFeatures.addRiverCane(biome);
                WNBiomeFeatures.addRiverPlants(biome);
            }
            if (((Boolean)CommonConfig.generateSmallCacti.get()).booleanValue()) {
                WNBiomeFeatures.addSmallCacti(biome);
            }
            if (((Boolean)CommonConfig.replaceDefaultTrees.get()).booleanValue()) {
                // empty if block
            }
            if (((Boolean)CommonConfig.generateShells.get()).booleanValue()) {
                WNBiomeFeatures.addShells(biome);
            }
            if (((Boolean)CommonConfig.generateMoss.get()).booleanValue()) {
                WNBiomeFeatures.addMoss(biome);
            }
            if (((Boolean)CommonConfig.generateGlowingCaveOaks.get()).booleanValue()) {
                WNBiomeFeatures.addGlowingCaveOaks(biome);
            }
            if (((Boolean)CommonConfig.generateBigGlowshrooms.get()).booleanValue()) {
                WNBiomeFeatures.addGlowshrooms(biome);
            }
            if (((Boolean)CommonConfig.generateFallenTrees.get()).booleanValue()) {
                WNBiomeFeatures.addFallenTrees(biome);
            }
            if (((Boolean)CommonConfig.generateBeehives.get()).booleanValue()) {
                WNBiomeFeatures.addBeehives(biome);
            }
            if (((Boolean)CommonConfig.generateUndergroundRivers.get()).booleanValue()) {
                // empty if block
            }
        });
        for (Biome biome2 : WNBiomeFeatures.lakeBiomes) {
            if (((Boolean)CommonConfig.waterLakeGeneration.get()).booleanValue()) {
                biome2.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
            }
            if (!((Boolean)CommonConfig.lavaLakeGeneration.get()).booleanValue()) continue;
            biome2.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150353_l.func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(80))));
        }
        for (Biome biome2 : WNBiomeFeatures.springBiomes) {
            if (((Boolean)CommonConfig.waterSpringGeneration.get()).booleanValue()) {
                biome2.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226736_X_).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(50, 8, 8, 256))));
            }
            if (!((Boolean)CommonConfig.lavaSpringGeneration.get()).booleanValue()) continue;
            biome2.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226737_Y_).func_227228_a_(Placement.field_215030_p.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 8, 16, 256))));
        }
    }
}

