/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk;

import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.generators.carves.PathGenerator;
import com.matez.wildnature.world.generation.noise.sponge.module.source.Perlin;
import com.matez.wildnature.world.generation.noise.sponge.module.source.RidgedMulti;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiome;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiomeManager;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public abstract class WNNoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_222557_0_ -> {
        int a = 24;
        int b = 12;
        for (int i = 0; i < a; ++i) {
            for (int j = 0; j < a; ++j) {
                for (int k = 0; k < a; ++k) {
                    p_222557_0_[i * a * a + j * a + k] = (float)WNNoiseChunkGenerator.func_222554_b(j - b, k - b, i - b);
                }
            }
        }
    });
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final SharedSeedRandom randomSeed;
    private final OctavesNoiseGenerator field_222568_o;
    private final OctavesNoiseGenerator field_222569_p;
    private final OctavesNoiseGenerator field_222570_q;
    private final INoiseGenerator surfaceDepthNoise;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private double frequency = (Double)CommonConfig.pathFrequency.get();
    private final RidgedMulti ridgedMultiNoise;
    private static RidgedMulti ridgedMultiNoiseCopy;
    private final Perlin perlinNoise;
    private final Perlin biomeNoise;
    private double latestBiomeNoise = -1.0;
    private final PathGenerator pathGenerator;
    public static double maxNoise;
    public Random random = new Random(this.field_222541_b);

    public WNNoiseChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, int p_i49931_3_, int p_i49931_4_, int p_i49931_5_, T p_i49931_6_, boolean usePerlin) {
        super(worldIn, biomeProviderIn, p_i49931_6_);
        this.verticalNoiseGranularity = p_i49931_4_;
        this.horizontalNoiseGranularity = p_i49931_3_;
        this.defaultBlock = p_i49931_6_.func_205532_l();
        this.defaultFluid = p_i49931_6_.func_205533_m();
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = p_i49931_5_ / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.field_222568_o = new OctavesNoiseGenerator(this.randomSeed, 16, 0);
        this.field_222569_p = new OctavesNoiseGenerator(this.randomSeed, 16, 0);
        this.field_222570_q = new OctavesNoiseGenerator(this.randomSeed, 8, 0);
        this.surfaceDepthNoise = usePerlin ? new PerlinNoiseGenerator(this.randomSeed, 4, 0) : new OctavesNoiseGenerator(this.randomSeed, 4, 0);
        this.ridgedMultiNoise = new RidgedMulti();
        this.ridgedMultiNoise.setSeed((int)worldIn.func_72905_C());
        this.ridgedMultiNoise.setFrequency(0.005);
        this.ridgedMultiNoise.setOctaveCount(1);
        this.ridgedMultiNoise.setLacunarity(0.0);
        ridgedMultiNoiseCopy = this.ridgedMultiNoise;
        this.perlinNoise = new Perlin();
        this.perlinNoise.setSeed((int)worldIn.func_72905_C());
        this.perlinNoise.setFrequency(0.1);
        this.perlinNoise.setOctaveCount(2);
        this.perlinNoise.setLacunarity(0.0);
        this.perlinNoise.setPersistence(-0.4);
        this.biomeNoise = new Perlin();
        this.biomeNoise.setSeed((int)worldIn.func_72905_C());
        this.biomeNoise.setFrequency(0.002);
        this.biomeNoise.setOctaveCount(2);
        this.biomeNoise.setLacunarity(0.0);
        this.biomeNoise.setPersistence(0.0);
        this.pathGenerator = new PathGenerator(worldIn);
    }

    public static RidgedMulti getCaveNoise() {
        return ridgedMultiNoiseCopy;
    }

    private double calcNoiseColumn(int p_222552_1_, int p_222552_2_, int p_222552_3_, double coordScale, double heightScale, double p_222552_8_, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double mainNoiseRegion = 0.0;
        double d3 = 1.0;
        double scaleXZ = 0.01;
        double scaleY = 1.0;
        for (int i = 0; i < 16; ++i) {
            double d4 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_1_ * coordScale * d3));
            double d5 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_2_ * heightScale * d3));
            double d6 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_3_ * coordScale * d3));
            double d7 = heightScale * d3;
            d0 += this.field_222568_o.func_215463_a(i).func_215456_a(d4, d5, d6, d7, (double)p_222552_2_ * d7) / d3;
            d1 += this.field_222569_p.func_215463_a(i).func_215456_a(d4, d5, d6, d7, (double)p_222552_2_ * d7) / d3;
            if (i < 8) {
                mainNoiseRegion += this.field_222570_q.func_215463_a(i).func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_1_ * scaleXZ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_2_ * scaleY * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_3_ * scaleXZ * d3)), p_222552_10_ * d3, (double)p_222552_2_ * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((mainNoiseRegion / 10.0 + 1.0) / 2.0));
    }

    protected double[] func_222547_b(int p_222547_1_, int p_222547_2_) {
        double[] adouble = new double[this.noiseSizeY + 1];
        this.fillNoiseColumn(adouble, p_222547_1_, p_222547_2_);
        return adouble;
    }

    protected void func_222546_a(double[] p_222546_1_, int p_222546_2_, int p_222546_3_, double p_222546_4_, double p_222546_6_, double p_222546_8_, double p_222546_10_, int p_222546_12_, int p_222546_13_) {
        double[] biomeNoiseColumn = this.getBiomeNoiseColumn(p_222546_2_, p_222546_3_);
        double biomeDepth = biomeNoiseColumn[0];
        double biomeScale = biomeNoiseColumn[1];
        double d2 = this.func_222551_g();
        double d3 = this.func_222553_h();
        for (int i = 0; i < this.func_222550_i(); ++i) {
            double d4 = this.calcNoiseColumn(p_222546_2_, i, p_222546_3_, p_222546_4_, p_222546_6_, p_222546_8_, p_222546_10_);
            d4 -= this.func_222545_a(biomeDepth, biomeScale, i);
            if ((double)i > d2) {
                d4 = MathHelper.func_151238_b((double)d4, (double)p_222546_13_, (double)(((double)i - d2) / (double)p_222546_12_));
            } else if ((double)i < d3) {
                d4 = MathHelper.func_151238_b((double)d4, (double)-30.0, (double)((d3 - (double)i) / (d3 - 1.0)));
            }
            p_222546_1_[i] = d4;
        }
    }

    protected abstract double[] getBiomeNoiseColumn(int var1, int var2);

    protected abstract double func_222545_a(double var1, double var3, int var5);

    protected double func_222551_g() {
        return this.func_222550_i() - 4;
    }

    protected double func_222553_h() {
        return 0.0;
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type p_222529_3_) {
        int i = Math.floorDiv(p_222529_1_, this.horizontalNoiseGranularity);
        int j = Math.floorDiv(p_222529_2_, this.horizontalNoiseGranularity);
        int k = Math.floorMod(p_222529_1_, this.horizontalNoiseGranularity);
        int l = Math.floorMod(p_222529_2_, this.horizontalNoiseGranularity);
        double d0 = (double)k / (double)this.horizontalNoiseGranularity;
        double d1 = (double)l / (double)this.horizontalNoiseGranularity;
        double[][] adouble = new double[][]{this.func_222547_b(i, j), this.func_222547_b(i, j + 1), this.func_222547_b(i + 1, j), this.func_222547_b(i + 1, j + 1)};
        int i1 = this.func_222530_f();
        for (int j1 = this.noiseSizeY - 1; j1 >= 0; --j1) {
            double d2 = adouble[0][j1];
            double d3 = adouble[1][j1];
            double d4 = adouble[2][j1];
            double d5 = adouble[3][j1];
            double d6 = adouble[0][j1 + 1];
            double d7 = adouble[1][j1 + 1];
            double d8 = adouble[2][j1 + 1];
            double d9 = adouble[3][j1 + 1];
            for (int k1 = this.verticalNoiseGranularity - 1; k1 >= 0; --k1) {
                double d10 = (double)k1 / (double)this.verticalNoiseGranularity;
                double d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int l1 = j1 * this.verticalNoiseGranularity + k1;
                if (!(d11 > 0.0) && l1 >= i1) continue;
                BlockState blockstate = d11 > 0.0 ? this.defaultBlock : this.defaultFluid;
                if (!p_222529_3_.func_222684_d().test(blockstate)) continue;
                return l1 + 1;
            }
        }
        return 0;
    }

    protected abstract void fillNoiseColumn(double[] var1, int var2, int var3);

    public int func_222550_i() {
        return this.noiseSizeY + 1;
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunkIn.func_76632_l();
        int xChunkPos = chunkpos1.func_180334_c();
        int zChunkPos = chunkpos1.func_180333_d();
        double d0 = 0.0625;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int relativeX = 0; relativeX < 16; ++relativeX) {
            for (int relativeZ = 0; relativeZ < 16; ++relativeZ) {
                int a;
                int startPointY;
                int height;
                BlockPos pos;
                int x = xChunkPos + relativeX;
                int z = zChunkPos + relativeZ;
                int startHeight = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, relativeX, relativeZ) + 1;
                double d1 = this.surfaceDepthNoise.func_215460_a((double)x * 0.0625, (double)z * 0.0625, 0.0625, (double)startHeight * 0.0625) * 15.0;
                Biome biome = worldGenRegion.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(xChunkPos + relativeX, startHeight, zChunkPos + relativeZ));
                biome.func_206854_a((Random)sharedseedrandom, chunkIn, x, z, startHeight, d1, this.func_201496_a_().func_205532_l(), this.func_201496_a_().func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
                this.pathGenerator.generate(x, startHeight, z, biome, chunkIn);
                if (!((Boolean)CommonConfig.generateUndergroundRivers.get()).booleanValue()) continue;
                URBiome riverBiome = URBiomeManager.getBiomeAt(chunkIn, new BlockPos(x, 1, z), this.field_222540_a.func_72905_C());
                double vnoise = this.ridgedMultiNoise.getValue(x, 1.0, z);
                if (vnoise >= 0.6 && vnoise <= 2.0) {
                    pos = new BlockPos(x, 13, z);
                    height = riverBiome.getNoiseHeight(vnoise, 0.6, 0.625, 1, 10, 17, 0.63, this.random, this.field_222541_b, pos);
                    if (height == 10 || height == 9) {
                        double pnoise = this.perlinNoise.getValue(x, 1.0, z);
                        if (pnoise >= 0.3) {
                            ++height;
                            if (pnoise >= 0.38) {
                                ++height;
                            }
                        } else if (pnoise < 0.16) {
                            --height;
                        }
                    }
                    startPointY = -height / 2;
                    for (a = pos.func_177956_o() - startPointY; a > pos.func_177956_o() - height; --a) {
                        if (a > 10) {
                            chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p()), Blocks.field_201941_jj.func_176223_P(), false);
                            continue;
                        }
                        chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
                    }
                }
                if (!(vnoise >= 0.58) || !(vnoise <= 2.0) || riverBiome.getElevationBlock(this.field_222541_b, this.random, pos = new BlockPos(x, 13, z)).func_177230_c() == Blocks.field_150348_b && riverBiome.getUnderwaterBlock(this.field_222541_b, this.random, pos).func_177230_c() == Blocks.field_150348_b) continue;
                height = riverBiome.getNoiseHeight(vnoise, 0.59, 0.635, 1, 13, 17, 0.64, this.random, this.field_222541_b, pos);
                startPointY = -height / 2;
                for (a = pos.func_177956_o() - startPointY; a > pos.func_177956_o() - height; --a) {
                    riverBiome.elevate(pos, a, chunkIn, this.random, this.field_222541_b);
                }
            }
        }
        this.makeBedrock(chunkIn, (Random)sharedseedrandom);
    }

    private int getMaxHeightNearPathBlock(int x, int y, int z, IChunk chunk) {
        int highest = 0;
        int terrainPosDiffCheck = 4;
        block0: for (int i = 0; i < 4; ++i) {
            int ty;
            int xChange = 0;
            int zChange = 0;
            if (i == 0) {
                xChange = terrainPosDiffCheck;
            } else if (i == 1) {
                xChange = -terrainPosDiffCheck;
            } else {
                zChange = i == 2 ? terrainPosDiffCheck : -terrainPosDiffCheck;
            }
            int rx = x + xChange;
            int rz = z + zChange;
            if (!(this.ridgedMultiNoise.getValue(rx, 1.0, rz) >= 0.62) || !(this.ridgedMultiNoise.getValue(rx, 1.0, rz) <= 0.65) || rx < chunk.func_76632_l().func_180334_c() || rz < chunk.func_76632_l().func_180333_d() || rx >= chunk.func_76632_l().func_180334_c() + 16 || rx >= chunk.func_76632_l().func_180333_d() + 16) continue;
            int n = ty = highest == 0 ? y : highest;
            while (ty > 0 && ty <= 256) {
                if (chunk.func_180495_p(new BlockPos(rx, ty, rz)).func_200132_m() && ty > highest) {
                    highest = ty;
                    continue block0;
                }
                ++ty;
            }
        }
        return highest == 0 ? y : highest;
    }

    private int getMinHeightNearPathBlock(int x, int y, int z, IChunk chunk) {
        int lowest = 256;
        int terrainPosDiffCheck = 4;
        block0: for (int i = 0; i < 4; ++i) {
            int ty;
            int xChange = 0;
            int zChange = 0;
            if (i == 0) {
                xChange = terrainPosDiffCheck;
            } else if (i == 1) {
                xChange = -terrainPosDiffCheck;
            } else {
                zChange = i == 2 ? terrainPosDiffCheck : -terrainPosDiffCheck;
            }
            int rx = x + xChange;
            int rz = z + zChange;
            if (!(this.ridgedMultiNoise.getValue(rx, 1.0, rz) >= 0.62) || !(this.ridgedMultiNoise.getValue(rx, 1.0, rz) <= 0.65) || rx < chunk.func_76632_l().func_180334_c() || rz < chunk.func_76632_l().func_180333_d() || rx >= chunk.func_76632_l().func_180334_c() + 16 || rx >= chunk.func_76632_l().func_180333_d() + 16) continue;
            int n = ty = lowest == 256 ? y : lowest;
            while (ty > 0 && ty <= 256) {
                if (chunk.func_180495_p(new BlockPos(rx, ty, rz)).func_200132_m() && chunk.func_180495_p(new BlockPos(rx, ty + 1, rz)).func_196958_f() && ty < lowest) {
                    lowest = ty;
                    continue block0;
                }
                --ty;
            }
        }
        return lowest == 256 ? y : lowest;
    }

    private int calculateHeight(double noise, double minNoise, double maxNoise, int minHeight, int maxHeight) {
        double maxNoiseCalc = maxNoise - minNoise;
        double noiseCalc = noise - minNoise;
        double noisePercent = noiseCalc / maxNoiseCalc;
        int maxHeightCalc = maxHeight - minHeight;
        double height = (double)maxHeightCalc * noisePercent;
        return (int)Math.round(height) + minHeight;
    }

    private int calculateHeightByCenter(double noise, double minNoise, double maxNoise, int minHeight, int maxHeight) {
        double noiseCenter = (maxNoise - minNoise) / 2.0 + minNoise;
        double noisePercent = 0.0;
        noisePercent = noiseCenter > noise ? this.calculatePercent(noise, minNoise, noiseCenter) : (noiseCenter < noise ? this.calculatePercent(noise, maxHeight, noiseCenter) : 1.0);
        int maxHeightCalc = maxHeight - minHeight;
        double height = (double)maxHeightCalc * noisePercent;
        return (int)Math.round(height) + minHeight;
    }

    private double calculatePercent(double noise, double minNoise, double maxNoise) {
        double maxNoiseCalc = maxNoise - minNoise;
        double noiseCalc = noise - minNoise;
        return noiseCalc / maxNoiseCalc;
    }

    protected void makeBedrock(IChunk chunkIn, Random rand) {
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        GenerationSettings t = this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        int i = this.func_222530_f();
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        objectlist.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= l - 12 || l1 <= i1 - 12 || k1 >= l + 15 + 12 || l1 >= i1 + 15 + 12) continue;
                        objectlist1.add((Object)jigsawjunction);
                    }
                }
            }
        }
        double[][][] adouble = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int j5 = 0; j5 < this.noiseSizeZ + 1; ++j5) {
            adouble[0][j5] = new double[this.noiseSizeY + 1];
            this.fillNoiseColumn(adouble[0][j5], j * this.noiseSizeX, k * this.noiseSizeZ + j5);
            adouble[1][j5] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunkIn;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        for (int k5 = 0; k5 < this.noiseSizeX; ++k5) {
            for (int l5 = 0; l5 < this.noiseSizeZ + 1; ++l5) {
                this.fillNoiseColumn(adouble[1][l5], j * this.noiseSizeX + k5 + 1, k * this.noiseSizeZ + l5);
            }
            for (int i6 = 0; i6 < this.noiseSizeZ; ++i6) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int j6 = this.noiseSizeY - 1; j6 >= 0; --j6) {
                    double d16 = adouble[0][i6][j6];
                    double d17 = adouble[0][i6 + 1][j6];
                    double d18 = adouble[1][i6][j6];
                    double d0 = adouble[1][i6 + 1][j6];
                    double d1 = adouble[0][i6][j6 + 1];
                    double d2 = adouble[0][i6 + 1][j6 + 1];
                    double d3 = adouble[1][i6][j6 + 1];
                    double d4 = adouble[1][i6 + 1][j6 + 1];
                    for (int i2 = this.verticalNoiseGranularity - 1; i2 >= 0; --i2) {
                        int j2 = j6 * this.verticalNoiseGranularity + i2;
                        int k2 = j2 & 0xF;
                        int l2 = j2 >> 4;
                        if (chunksection.func_222632_g() >> 4 != l2) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(l2);
                            chunksection.func_222635_a();
                        }
                        double d5 = (double)i2 / (double)this.verticalNoiseGranularity;
                        double d6 = MathHelper.func_219803_d((double)d5, (double)d16, (double)d1);
                        double d7 = MathHelper.func_219803_d((double)d5, (double)d18, (double)d3);
                        double d8 = MathHelper.func_219803_d((double)d5, (double)d17, (double)d2);
                        double d9 = MathHelper.func_219803_d((double)d5, (double)d0, (double)d4);
                        for (int i3 = 0; i3 < this.horizontalNoiseGranularity; ++i3) {
                            int j3 = l + k5 * this.horizontalNoiseGranularity + i3;
                            int k3 = j3 & 0xF;
                            double d10 = (double)i3 / (double)this.horizontalNoiseGranularity;
                            double d11 = MathHelper.func_219803_d((double)d10, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)d10, (double)d8, (double)d9);
                            for (int l3 = 0; l3 < this.horizontalNoiseGranularity; ++l3) {
                                int l4;
                                int k4;
                                int i4 = i1 + i6 * this.horizontalNoiseGranularity + l3;
                                int j4 = i4 & 0xF;
                                double d13 = (double)l3 / (double)this.horizontalNoiseGranularity;
                                double d14 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                                double d15 = MathHelper.func_151237_a((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                d15 = d15 / 2.0 - d15 * d15 * d15 / 24.0;
                                while (objectlistiterator.hasNext()) {
                                    AbstractVillagePiece abstractvillagepiece1 = (AbstractVillagePiece)objectlistiterator.next();
                                    MutableBoundingBox mutableboundingbox = abstractvillagepiece1.func_74874_b();
                                    k4 = Math.max(0, Math.max(mutableboundingbox.field_78897_a - j3, j3 - mutableboundingbox.field_78893_d));
                                    l4 = j2 - (mutableboundingbox.field_78895_b + abstractvillagepiece1.func_214830_d());
                                    int i5 = Math.max(0, Math.max(mutableboundingbox.field_78896_c - i4, i4 - mutableboundingbox.field_78892_f));
                                    d15 += WNNoiseChunkGenerator.func_222556_a(k4, l4, i5) * 0.8;
                                }
                                objectlistiterator.back(objectlist.size());
                                while (objectlistiterator1.hasNext()) {
                                    JigsawJunction jigsawjunction1 = (JigsawJunction)objectlistiterator1.next();
                                    int k6 = j3 - jigsawjunction1.func_214895_a();
                                    k4 = j2 - jigsawjunction1.func_214896_b();
                                    l4 = i4 - jigsawjunction1.func_214893_c();
                                    d15 += WNNoiseChunkGenerator.func_222556_a(k6, k4, l4) * 0.4;
                                }
                                objectlistiterator1.back(objectlist1.size());
                                BlockState blockstate = d15 > 0.0 ? this.defaultBlock : (j2 < i ? this.defaultFluid : AIR);
                                if (blockstate == AIR) continue;
                                if (blockstate.func_185906_d() != 0) {
                                    blockpos$mutableblockpos.func_181079_c(j3, j2, i4);
                                    chunkprimer.func_201637_h((BlockPos)blockpos$mutableblockpos);
                                }
                                chunksection.func_177484_a(k3, k2, j4, blockstate, false);
                                heightmap.func_202270_a(k3, j2, j4, blockstate);
                                heightmap1.func_202270_a(k3, j2, j4, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = adouble[0];
            adouble[0] = adouble[1];
            adouble[1] = adouble1;
        }
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }

    public void func_222528_a(IWorld worldIn, IChunk chunkIn) {
        int i = 8;
        int j = chunkIn.func_76632_l().field_77276_a;
        int k = chunkIn.func_76632_l().field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.func_77272_a((int)j1, (int)k1);
                for (Map.Entry entry : worldIn.func_212866_a_(j1, k1).func_201609_c().entrySet()) {
                    StructureStart structurestart = (StructureStart)entry.getValue();
                    if (structurestart == StructureStart.field_214630_a || !structurestart.func_75071_a().func_78885_a(l, i1, l + 15, i1 + 15)) continue;
                    chunkIn.func_201583_a((String)entry.getKey(), l1);
                    DebugPacketSender.func_218804_a((IWorld)worldIn, (StructureStart)structurestart);
                }
            }
        }
    }

    static {
        maxNoise = 0.0;
    }
}

