/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk.generation;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Function;
import net.minecraft.util.Util;

public class ChunkArraySampler {
    public static final int CHUNK_SIZE = 16;
    public static final int SAMPLE_WIDTH = 4;
    public static final int CHUNK_SQUARE = 24;
    public static final int SAMPLE_SQUARE = 9;
    public static final double[] WEIGHT_FIELD = (double[])Util.func_200696_a((Object)new double[81], array -> {
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                array[x + 9 * z] = 0.0211640211641 * (1.0 - 0.03125 * (double)((z - 4) * (z - 4) + (x - 4) * (x - 4)));
            }
        }
    });

    public static <T> T[] fillSampledArray(T[] array, CoordinateAccessor<T> accessor) {
        if (array.length != 576) {
            throw new IllegalArgumentException("Array input is not sized correctly, should be 24");
        }
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                array[i + 24 * j] = accessor.get(i - 4, j - 4);
            }
        }
        return array;
    }

    public static <T> T[] fillSampledArray(T[] array, CoordinateAccessor<T> accessor, int resolutionBits) {
        if (resolutionBits == 0) {
            throw new IllegalArgumentException("Call fillSampledArray(T[], CoordinateAccessor<T>) instead, it will build the correct size array for direct sampling");
        }
        int arrayWidth = (16 >> resolutionBits) + 9;
        if (array.length != arrayWidth * arrayWidth) {
            throw new IllegalArgumentException("Array input is not sized correctly, should be " + arrayWidth * arrayWidth);
        }
        for (int i = 0; i < arrayWidth; ++i) {
            for (int j = 0; j < arrayWidth; ++j) {
                array[i + arrayWidth * j] = accessor.get(i - 4 << resolutionBits, j - 4 << resolutionBits);
            }
        }
        return array;
    }

    public static <T> void fillSampledWeightMap(T[] sampledArray, Object2DoubleMap<T> weightMap, int localX, int localZ) {
        weightMap.clear();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                double weight = WEIGHT_FIELD[i + 9 * j];
                weightMap.mergeDouble(sampledArray[i + localX + 24 * (j + localZ)], weight, Double::sum);
            }
        }
    }

    public static <T> void fillSampledWeightMap(T[] sampledArray, Object2DoubleMap<T> weightMap, int resolutionBits, int localX, int localZ) {
        if (resolutionBits == 0) {
            throw new IllegalArgumentException("Call fillSampledWeightMap(T[], Object2DoubleMap<T>, int, int) instead, it will use the correct size array for direct sampling");
        }
        int coordX = localX >> resolutionBits;
        int coordZ = localZ >> resolutionBits;
        int deltaMax = 1 << resolutionBits;
        float deltaX = ((float)localX - (float)(coordX << resolutionBits)) / (float)deltaMax;
        float deltaZ = ((float)localZ - (float)(coordZ << resolutionBits)) / (float)deltaMax;
        int arrayWidth = (16 >> resolutionBits) + 9;
        if (sampledArray.length != arrayWidth * arrayWidth) {
            throw new IllegalArgumentException("Array was of size " + sampledArray.length + " but expected the side length to be " + arrayWidth);
        }
        weightMap.clear();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                double weight = WEIGHT_FIELD[i + 9 * j];
                weightMap.mergeDouble(sampledArray[i + (coordX + 1) + arrayWidth * (j + (coordZ + 1))], weight * (double)deltaX * (double)deltaZ, Double::sum);
                weightMap.mergeDouble(sampledArray[i + coordX + arrayWidth * (j + (coordZ + 1))], weight * (double)(1.0f - deltaX) * (double)deltaZ, Double::sum);
                weightMap.mergeDouble(sampledArray[i + (coordX + 1) + arrayWidth * (j + coordZ)], weight * (double)deltaX * (double)(1.0f - deltaZ), Double::sum);
                weightMap.mergeDouble(sampledArray[i + coordX + arrayWidth * (j + coordZ)], weight * (double)(1.0f - deltaX) * (double)(1.0f - deltaZ), Double::sum);
            }
        }
    }

    public static <T, G extends Enum<G>> void reduceGroupedWeightMap(Object2DoubleMap<T> weightMap, Object2DoubleMap<T> groupWeightMap, Function<T, G> groupFunction, int groups) {
        double[] maxWeights = new double[groups];
        for (Object2DoubleMap.Entry entry : groupWeightMap.object2DoubleEntrySet()) {
            Enum group = (Enum)groupFunction.apply(entry.getKey());
            if (group == null) continue;
            int n = group.ordinal();
            maxWeights[n] = maxWeights[n] + entry.getDoubleValue();
        }
        double[] actualWeights = new double[groups];
        ObjectIterator iterator = weightMap.object2DoubleEntrySet().iterator();
        while (iterator.hasNext()) {
            Object2DoubleMap.Entry entry = (Object2DoubleMap.Entry)iterator.next();
            Enum group = (Enum)groupFunction.apply(entry.getKey());
            if (group == null) continue;
            int n = group.ordinal();
            actualWeights[n] = actualWeights[n] + entry.getDoubleValue();
            iterator.remove();
        }
        for (Object2DoubleMap.Entry entry : groupWeightMap.object2DoubleEntrySet()) {
            Enum group = (Enum)groupFunction.apply(entry.getKey());
            if (group == null || !(actualWeights[group.ordinal()] > 0.0) || !(maxWeights[group.ordinal()] > 0.0)) continue;
            weightMap.put(entry.getKey(), entry.getDoubleValue() * actualWeights[group.ordinal()] / maxWeights[group.ordinal()]);
        }
    }

    public static interface CoordinateAccessor<T> {
        public T get(int var1, int var2);
    }
}

