/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk.generation;

import com.matez.wildnature.world.generation.biome.layer.ColumnBiomeContainer;
import com.matez.wildnature.world.generation.biome.layer.SmoothColumnBiomeMagnifier;
import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import com.matez.wildnature.world.generation.biome.setup.WNGenSettings;
import com.matez.wildnature.world.generation.chunk.generation.ChunkArraySampler;
import com.matez.wildnature.world.generation.chunk.generation.landscape.ChunkLandscape;
import com.matez.wildnature.world.generation.generators.carves.PathGenerator;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import com.matez.wildnature.world.generation.generators.rivers.surface.RiverGenerator;
import com.matez.wildnature.world.generation.processors.TerrainProcessor;
import com.matez.wildnature.world.generation.processors.ThermalErosionProcessor;
import com.matez.wildnature.world.generation.processors.ThermalErosionTestProcessor;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class WNSimplexChunkGenerator
extends ChunkGenerator<WNGenSettings> {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected IChunk chunk = null;
    private WNGenSettings settings;
    private final int verticalNoiseResolution;
    private final int horizontalNoiseResolution;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    private final PerlinNoiseGenerator surfaceDepthNoise;
    protected HashMap<Long, int[]> noiseCache = new HashMap();
    private static TerrainProcessor thermalErosionProcessor = new ThermalErosionProcessor();
    private static TerrainProcessor thermalErosionTestProcessor = new ThermalErosionTestProcessor();
    private SharedSeedRandom randomSeed;
    private PathGenerator pathGenerator;
    private RiverGenerator riverGenerator;

    public WNSimplexChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, WNGenSettings generationSettingsIn) {
        super(worldIn, biomeProviderIn, (GenerationSettings)generationSettingsIn);
        this.settings = generationSettingsIn;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.verticalNoiseResolution = 8;
        this.horizontalNoiseResolution = 4;
        this.noiseSizeX = 16 / this.horizontalNoiseResolution;
        this.noiseSizeY = 256 / this.verticalNoiseResolution;
        this.noiseSizeZ = 16 / this.horizontalNoiseResolution;
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.randomSeed, 3, 0);
        this.pathGenerator = new PathGenerator(worldIn);
        this.riverGenerator = new RiverGenerator(worldIn);
        thermalErosionProcessor.init(this, this.field_222541_b);
        thermalErosionTestProcessor.init(this, this.field_222541_b);
    }

    public void func_222539_a(IChunk chunkIn) {
        ((ChunkPrimer)chunkIn).func_225548_a_((BiomeContainer)new ColumnBiomeContainer(chunkIn.func_76632_l(), this.field_222542_c));
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        int xChunkPos = chunkpos.func_180334_c();
        int zChunkPos = chunkpos.func_180333_d();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int relativeX = 0; relativeX < 16; ++relativeX) {
            for (int relativeZ = 0; relativeZ < 16; ++relativeZ) {
                int x = xChunkPos + relativeX;
                int z = zChunkPos + relativeZ;
                int startHeight = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, relativeX, relativeZ) + 1;
                double noise = this.surfaceDepthNoise.func_215460_a((double)x * 0.0625, (double)z * 0.0625, 0.0625, (double)startHeight * 0.0625) * 15.0;
                Biome biome = worldGenRegion.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(xChunkPos + relativeX, startHeight, zChunkPos + relativeZ));
                if (x != 0 || z == 0) {
                    // empty if block
                }
                biome.func_206854_a((Random)sharedseedrandom, chunkIn, x, z, startHeight, noise, ((WNGenSettings)this.func_201496_a_()).func_205532_l(), ((WNGenSettings)this.func_201496_a_()).func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
                this.pathGenerator.generate(x, startHeight, z, biome, chunkIn);
            }
        }
        this.makeBedrock(chunkIn, (Random)sharedseedrandom);
    }

    protected void makeBedrock(IChunk chunkIn, Random rand) {
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        WNGenSettings t = (WNGenSettings)this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public int func_205470_d() {
        return this.func_222530_f() + 1;
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        this.chunk = chunkIn;
        ObjectArrayList structurePieces = new ObjectArrayList(10);
        ObjectArrayList jigsaws = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int chunkStartX = chunkX << 4;
        int chunkStartZ = chunkZ << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        structurePieces.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= chunkStartX - 12 || l1 <= chunkStartZ - 12 || k1 >= chunkStartX + 15 + 12 || l1 >= chunkStartZ + 15 + 12) continue;
                        jigsaws.add((Object)jigsawjunction);
                    }
                }
            }
        }
        this.generateTerrain(worldIn, chunkIn, this.getHeightsInChunk(chunkpos, worldIn));
    }

    public void generateTerrain(IWorld world, IChunk chunk, int[] noise) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = noise[x * 16 + z];
                for (int y = 0; y < 256; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (y > height) {
                        if (y >= this.func_222530_f()) continue;
                        chunk.func_177436_a(pos, this.settings.func_205533_m(), false);
                        continue;
                    }
                    chunk.func_177436_a(pos, this.settings.func_205532_l(), false);
                }
            }
        }
    }

    protected void erode(IWorld world, IChunk chunk, int[] noise) {
        int i;
        int threads = 8;
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (i = 0; i < threads; ++i) {
            int position = i;
            futures[i] = CompletableFuture.runAsync(() -> this.runErosion(world, chunk, position * 16 / threads, 16 / threads, noise));
        }
        for (i = 0; i < futures.length; ++i) {
            futures[i].join();
        }
    }

    private void runErosion(IWorld world, IChunk chunk, int start, int size, int[] noise) {
        for (int x = start; x < start + size; ++x) {
            for (int z = 0; z < 16; ++z) {
                thermalErosionTestProcessor.process(world, chunk, new Random(this.field_222541_b), chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, x, z, noise);
            }
        }
    }

    protected int[] getHeightsInChunk(ChunkPos pos, IWorld worldIn) {
        int i;
        int[] res = this.noiseCache.get(pos.func_201841_a());
        if (res != null) {
            return res;
        }
        int[] vals = new int[256];
        int threads = 4;
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (i = 0; i < threads; ++i) {
            int position = i;
            futures[i] = CompletableFuture.runAsync(() -> this.useNoise(vals, pos, position * 16 / threads, 16 / threads, worldIn));
        }
        for (i = 0; i < futures.length; ++i) {
            futures[i].join();
        }
        this.noiseCache.put(pos.func_201841_a(), vals);
        return vals;
    }

    public void useNoise(int[] noise, ChunkPos pos, int start, int size, IWorld worldIn) {
        Object2DoubleOpenHashMap weightMap16 = new Object2DoubleOpenHashMap(4);
        Object2DoubleOpenHashMap weightMap4 = new Object2DoubleOpenHashMap(2);
        Object2DoubleOpenHashMap weightMap1 = new Object2DoubleOpenHashMap();
        ChunkArraySampler.CoordinateAccessor<LerpConfiguration> biomeAccessor = (x, z) -> {
            Biome biome = SmoothColumnBiomeMagnifier.SMOOTH.func_225532_a_(worldIn.func_72905_C(), pos.func_180334_c() + x, 0, pos.func_180333_d() + z, (BiomeManager.IBiomeReader)worldIn);
            LerpConfiguration configuration = new LerpConfiguration(biome);
            return configuration;
        };
        LerpConfiguration[] sampledBiomes16 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[100], biomeAccessor, 4);
        LerpConfiguration[] sampledBiomes4 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[169], biomeAccessor, 2);
        LerpConfiguration[] sampledBiomes1 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[576], biomeAccessor);
        for (int x2 = start; x2 < start + size; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes16, weightMap16, 4, x2, z2);
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes4, weightMap4, 2, x2, z2);
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes1, weightMap1, x2, z2);
                Function<LerpConfiguration, BiomeVariants> variantAccessor = LerpConfiguration::getBiomeVariants;
                ChunkArraySampler.reduceGroupedWeightMap(weightMap4, weightMap16, variantAccessor.andThen(BiomeVariants::getLargeGroup), BiomeVariants.LargeGroup.SIZE);
                ChunkArraySampler.reduceGroupedWeightMap(weightMap1, weightMap4, variantAccessor.andThen(BiomeVariants::getSmallGroup), BiomeVariants.SmallGroup.SIZE);
                noise[x2 * 16 + z2] = this.getTerrainHeight(pos.field_77276_a * 16 + x2, pos.field_77275_b * 16 + z2, (Object2DoubleMap<LerpConfiguration>)weightMap1, variantAccessor);
            }
        }
    }

    public int getTerrainHeight(int x, int z, Object2DoubleMap<LerpConfiguration> weightMap1, Function<LerpConfiguration, BiomeVariants> variantAccessor) {
        Biome biome = this.field_222542_c.func_225526_b_(x / 4, 1, z / 4);
        ChunkLandscape landscape = ChunkLandscape.getOrCreate(x, z, this.field_222541_b, this.func_222530_f(), biome, this.chunk);
        int height = (int)landscape.generateHeightmap(this.field_222542_c, weightMap1, variantAccessor);
        return height;
    }

    public void applyHeightBasedBiomes(int height, int x, int z, Biome currentBiome) {
        float scale;
        float depth;
        if (height >= this.func_222530_f() || (depth = currentBiome.func_185355_j()) - (scale = currentBiome.func_185360_m()) < 0.0f) {
            // empty if block
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmap) {
        return this.func_222530_f();
    }
}

