/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk.primers;

import com.matez.wildnature.world.generation.chunk.primers.IChunkDelegate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class FastChunkPrimer
implements IChunkDelegate {
    private static final BlockState VOID_AIR = Blocks.field_201940_ji.func_176223_P();
    private final ChunkPrimer chunk;
    private final int chunkX;
    private final int chunkZ;
    private final Heightmap oceanFloorHeightMap;
    private final Heightmap worldSurfaceHeightMap;
    private final BlockPos.Mutable mutablePos;

    public static FastChunkPrimer deslowificate(IChunk chunk) {
        if (chunk instanceof FastChunkPrimer) {
            return (FastChunkPrimer)chunk;
        }
        if (chunk instanceof ChunkPrimer) {
            return new FastChunkPrimer((ChunkPrimer)chunk);
        }
        throw new IllegalStateException("Tried to deslowificate a chunk which could not be deslowificated! It was: " + chunk);
    }

    public static void updateChunkHeightMaps(IChunk chunk) {
        if (chunk instanceof FastChunkPrimer) {
            ((FastChunkPrimer)chunk).updateHeightMaps();
        }
    }

    public FastChunkPrimer(ChunkPrimer chunk) {
        this.chunk = chunk;
        this.chunkX = chunk.func_76632_l().func_180334_c();
        this.chunkZ = chunk.func_76632_l().func_180333_d();
        this.oceanFloorHeightMap = chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        this.worldSurfaceHeightMap = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        this.mutablePos = new BlockPos.Mutable();
    }

    @Override
    public IChunk getDelegate() {
        return this.chunk;
    }

    @Override
    @Nullable
    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            ChunkSection chunkSection = this.chunk.func_217332_a(pos.func_177956_o() >> 4);
            chunkSection.func_222635_a();
            int localX = pos.func_177958_n() & 0xF;
            int localY = pos.func_177956_o() & 0xF;
            int localZ = pos.func_177952_p() & 0xF;
            if (state.getLightValue((IBlockReader)this.chunk, pos) > 0) {
                this.mutablePos.func_181079_c(this.chunkX | localX, pos.func_177956_o(), this.chunkZ | localZ);
                this.chunk.func_201637_h((BlockPos)this.mutablePos);
            }
            BlockState prevState = chunkSection.func_177484_a(localX, localY, localZ, state, false);
            chunkSection.func_222637_b();
            return prevState;
        }
        return VOID_AIR;
    }

    public void updateHeightMaps() {
        int maxY = this.chunk.func_76625_h() + 16;
        for (int localX = 0; localX < 16; ++localX) {
            block1: for (int localZ = 0; localZ < 16; ++localZ) {
                boolean reachedTopSurface = false;
                for (int y = maxY - 1; y >= 0; --y) {
                    this.mutablePos.func_181079_c(localX, y, localZ);
                    BlockState state = this.chunk.func_180495_p((BlockPos)this.mutablePos);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    if (!reachedTopSurface) {
                        this.worldSurfaceHeightMap.func_202272_a(localX, localZ, y + 1);
                        reachedTopSurface = true;
                    }
                    if (!Heightmap.Type.OCEAN_FLOOR_WG.func_222684_d().test(state)) continue;
                    this.oceanFloorHeightMap.func_202272_a(localX, localZ, y + 1);
                    continue block1;
                }
            }
        }
    }
}

