/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.common.blocks.CornPlant;
import com.matez.wildnature.common.blocks.GreenBeansBush;
import com.matez.wildnature.util.other.BlockWeighList;
import com.matez.wildnature.world.generation.feature.FeatureRegistry;
import com.matez.wildnature.world.generation.feature.configs.BlockFeatureConfig;
import com.matez.wildnature.world.generation.feature.configs.BlockWeightListConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WNBushFeature
extends Feature<BlockFeatureConfig> {
    public WNBushFeature(Function<Dynamic<?>, ? extends BlockFeatureConfig> p_i49908_1_) {
        super(p_i49908_1_);
        this.setRegistryName("wildnature", "wn_bush_feature");
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockFeatureConfig config) {
        int i = 0;
        BlockState blockstate = config.state;
        if (config.state.func_177230_c() instanceof GreenBeansBush) {
            return FeatureRegistry.GREEN_BEAN_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new NoFeatureConfig());
        }
        if (config.state.func_177230_c() instanceof CornPlant) {
            return FeatureRegistry.CORN_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new NoFeatureConfig());
        }
        if (config.state.func_177230_c() instanceof DoublePlantBlock) {
            BlockWeighList l = new BlockWeighList();
            l.add(config.state, 1);
            return FeatureRegistry.PLANT_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new BlockWeightListConfig(l));
        }
        for (int j = 0; j < 64; ++j) {
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(blockpos) || worldIn.func_201675_m().func_177495_o() && blockpos.func_177956_o() >= worldIn.func_201672_e().func_201675_m().getHeight() || !blockstate.func_196955_c((IWorldReader)worldIn, blockpos)) continue;
            worldIn.func_180501_a(blockpos, blockstate, 2);
            ++i;
        }
        return i > 0;
    }
}

