/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.noise;

import com.matez.wildnature.world.generation.noise.ModuleBase;

public class Voronoi
extends ModuleBase {
    static final double DEFAULT_VORONOI_DISPLACEMENT = 1.0;
    static final double DEFAULT_VORONOI_FREQUENCY = 1.0;
    static final int DEFAULT_VORONOI_SEED = 0;
    private static final double SQRT_3 = 1.7320508075688772;
    double displacement;
    boolean enableDistance;
    double frequency;
    int seed;
    static final int X_NOISE_GEN = 1619;
    static final int Y_NOISE_GEN = 31337;
    static final int Z_NOISE_GEN = 6971;
    static final int SEED_NOISE_GEN = 1013;

    public Voronoi() {
        super(0);
        this.displacement = 1.0;
        this.enableDistance = false;
        this.frequency = 1.0;
        this.seed = 0;
    }

    public Voronoi(double displacement, boolean enableDistance, double frequency, int seed) {
        super(0);
        this.displacement = displacement;
        this.enableDistance = enableDistance;
        this.frequency = frequency;
        this.seed = seed;
    }

    @Override
    public double getValue(double x, double y, double z) {
        double value;
        int xInt = x > 0.0 ? (int)x : (int)(x *= this.frequency) - 1;
        int yInt = y > 0.0 ? (int)y : (int)(y *= this.frequency) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= this.frequency) - 1;
        double minDist = 2.147483647E9;
        double xCandidate = 0.0;
        double yCandidate = 0.0;
        double zCandidate = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double zPos;
                    double zDist;
                    double yPos;
                    double yDist;
                    double xPos = (double)xCur + Voronoi.ValueNoise3D(xCur, yCur, zCur, this.seed);
                    double xDist = xPos - x;
                    double dist = xDist * xDist + (yDist = (yPos = (double)yCur + Voronoi.ValueNoise3D(xCur, yCur, zCur, this.seed + 1)) - y) * yDist + (zDist = (zPos = (double)zCur + Voronoi.ValueNoise3D(xCur, yCur, zCur, this.seed + 2)) - z) * zDist;
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    xCandidate = xPos;
                    yCandidate = yPos;
                    zCandidate = zPos;
                }
            }
        }
        if (this.enableDistance) {
            double xDist = xCandidate - x;
            double yDist = yCandidate - y;
            double zDist = zCandidate - z;
            value = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist) * 1.7320508075688772 - 1.0;
        } else {
            value = 0.0;
        }
        return value + this.displacement * Voronoi.ValueNoise3D((int)Math.floor(xCandidate), (int)Math.floor(yCandidate), (int)Math.floor(zCandidate), this.seed);
    }

    public static double ValueNoise3D(int x, int y, int z, int seed) {
        return 1.0 - (double)Voronoi.IntValueNoise3D(x, y, z, seed) / 1.073741824E9;
    }

    public static int IntValueNoise3D(int x, int y, int z, int seed) {
        int n = 1619 * x + 31337 * y + 6971 * z + 1013 * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return n * (n * n * 60493 + 19990303) + 1376312589 & Integer.MAX_VALUE;
    }

    public void enableDistance(boolean enable) {
        this.enableDistance = enable;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public double GetFrequency() {
        return this.frequency;
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean IsDistanceEnabled() {
        return this.enableDistance;
    }

    public void setDisplacement(double displacement) {
        this.displacement = displacement;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }
}

