/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.surface.builders;

import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.surface.configs.CustomSurfaceBuilderConfig;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class CustomSurfaceBuilder
extends SurfaceBuilder<CustomSurfaceBuilderConfig> {
    public CustomSurfaceBuilder(Function<Dynamic<?>, ? extends CustomSurfaceBuilderConfig> p_i51312_1_) {
        super(p_i51312_1_);
        this.setRegistryName("wildnature", "custom_surface_builder");
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, CustomSurfaceBuilderConfig config) {
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)this.getConfig(random, new ArrayList<BlockCfg>(Arrays.asList(config.getCfgs()))));
    }

    private SurfaceBuilderConfig getConfig(Random rand, ArrayList<BlockCfg> cfgs) {
        ArrayList<SurfaceBuilderConfig> states = new ArrayList<SurfaceBuilderConfig>();
        for (int x = 0; x < cfgs.size(); ++x) {
            int a = cfgs.get(x).chance;
            for (int z = 0; z < a; ++z) {
                states.add(cfgs.get(x).config);
            }
        }
        if (states.size() != 0) {
            int block = Utilities.rint(0, states.size() - 1, rand);
            return (SurfaceBuilderConfig)states.get(block);
        }
        return field_215425_v;
    }

    public static class BlockCfg {
        private int chance;
        private SurfaceBuilderConfig config;

        public BlockCfg(SurfaceBuilderConfig config, int chance) {
            this.chance = chance;
            this.config = config;
        }

        public int getChance() {
            return this.chance;
        }

        public SurfaceBuilderConfig getConfig() {
            return this.config;
        }
    }
}

