/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.undergroundBiomes.setup;

import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.util.other.WeightedList;
import com.matez.wildnature.world.generation.noise.sponge.module.source.Voronoi;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.BasaltRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.CrystalRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.IcyRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.SandstoneRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.SkeletonRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.StalagmiteRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.biomes.TropicalRiver;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiome;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class URBiomeManager {
    public static Voronoi biomeNoise = new Voronoi();
    public static WeightedList<URBiome> riverBiomes = new WeightedList();
    public static ArrayList<URBiomeEntry> riverBiomesCategorized = new ArrayList();
    public static URBiome STONE_RIVER = URBiomeManager.register(new URBiome("stone_river", null, null, 30, 1.0f, 0x123123, 0x321321));
    public static URBiome BASALT_RIVER = URBiomeManager.register(new BasaltRiver("basalt_river", null, null, 7, 1.0f));
    public static URBiome CRYSTAL_RIVER = URBiomeManager.register(new CrystalRiver("crystal_river", null, null, 2, 1.0f));
    public static URBiome SKELETON_RIVER = URBiomeManager.register(new SkeletonRiver("skeleton_river", Biome.Category.JUNGLE, null, 1, 1.0f));
    public static URBiome STALAGMITE_RIVER = URBiomeManager.register(new StalagmiteRiver("stalagmite_river", null, null, 5, 1.0f, 0x123123, 0x321321));
    public static URBiome SANDSTONE_RIVER = URBiomeManager.register(new SandstoneRiver("sandstone_river", Biome.Category.DESERT, null, 30, 1.0f, 0x123123, 0x321321));
    public static URBiome TROPICAL_RIVER = URBiomeManager.register(new TropicalRiver("tropical_river", Biome.Category.JUNGLE, null, 30, 1.0f, 0x123123, 0x321321));
    public static URBiome ICY_RIVER = URBiomeManager.register(new IcyRiver("icy_river", null, Biome.TempCategory.COLD, 15, 1.0f, 0x123123, 0x321321));

    private static URBiome register(URBiome biome) {
        riverBiomes.add(biome, biome.getRarity());
        return biome;
    }

    public static URBiome getBiomeAt(IChunk chunk, BlockPos pos, long seed) {
        Biome.Category category = Utilities.getBiomeOnPos(chunk.func_225549_i_(), pos.func_177958_n(), pos.func_177952_p()).func_201856_r();
        Biome.TempCategory tempCategory = Utilities.getBiomeOnPos(chunk.func_225549_i_(), pos.func_177958_n(), pos.func_177952_p()).func_150561_m();
        URBiomeEntry entry = null;
        for (URBiomeEntry urBiomeEntry : riverBiomesCategorized) {
            if (urBiomeEntry.tempCategory != tempCategory || urBiomeEntry.category != category) continue;
            entry = urBiomeEntry;
        }
        if (entry == null || entry.list.isEmpty()) {
            return STONE_RIVER;
        }
        biomeNoise.setSeed((int)seed);
        URBiome biome = (URBiome)Utilities.getWeightedEntry(entry.list, new Random(seed + (long)((int)(biomeNoise.getValue(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) * 1000.0))));
        return biome;
    }

    static {
        URBiome[] biomes = new URBiome[]{STONE_RIVER, BASALT_RIVER, CRYSTAL_RIVER, SKELETON_RIVER, STALAGMITE_RIVER, SANDSTONE_RIVER, TROPICAL_RIVER, ICY_RIVER};
        biomeNoise.setFrequency(0.004);
        for (Biome.TempCategory tempCategory : Biome.TempCategory.values()) {
            for (Biome.Category value : Biome.Category.values()) {
                WeightedList<URBiome> list = new WeightedList<URBiome>();
                riverBiomes.forEach(urBiome -> {
                    if (urBiome.getCategory() == null) {
                        if (urBiome.getTempCategory() == null) {
                            list.add((URBiome)urBiome, riverBiomes.getRarityFor((URBiome)urBiome));
                        } else if (tempCategory == urBiome.getTempCategory()) {
                            list.add((URBiome)urBiome, riverBiomes.getRarityFor((URBiome)urBiome));
                        }
                    } else if (value == urBiome.getCategory()) {
                        if (urBiome.getTempCategory() == null) {
                            list.add((URBiome)urBiome, riverBiomes.getRarityFor((URBiome)urBiome));
                        } else if (tempCategory == urBiome.getTempCategory()) {
                            list.add((URBiome)urBiome, riverBiomes.getRarityFor((URBiome)urBiome));
                        }
                    }
                });
                riverBiomesCategorized.add(new URBiomeEntry(value, tempCategory, list));
            }
        }
    }

    public static class URBiomeEntry {
        private Biome.Category category;
        private Biome.TempCategory tempCategory;
        private WeightedList<URBiome> list;

        public URBiomeEntry(Biome.Category category, Biome.TempCategory tempCategory, WeightedList<URBiome> list) {
            this.category = category;
            this.tempCategory = tempCategory;
            this.list = list;
        }
    }
}

