/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import snownee.kiwi.Kiwi;
import snownee.kiwi.util.Util;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class KiwiConfig {
    static final ForgeConfigSpec spec;
    public static ResourceLocation contributorEffect;
    public static boolean globalTooltip;
    public static int tooltipWrapWidth;
    public static boolean debugTooltip;
    public static String debugTooltipNBTFormatter;
    public static ForgeConfigSpec.ConfigValue<String> contributorEffectCfg;
    private static ForgeConfigSpec.BooleanValue globalTooltipCfg;
    private static ForgeConfigSpec.IntValue tooltipWrapWidthCfg;
    private static ForgeConfigSpec.BooleanValue debugTooltipCfg;
    private static ForgeConfigSpec.ConfigValue<String> debugTooltipNBTFormatterCfg;
    public static Map<ResourceLocation, ForgeConfigSpec.BooleanValue> modules;

    private KiwiConfig(ForgeConfigSpec.Builder builder) {
        builder.push("modules");
        for (Map.Entry<ResourceLocation, Boolean> entry : Kiwi.defaultOptions.entrySet()) {
            ResourceLocation rl = entry.getKey();
            modules.put(rl, builder.define(rl.func_110624_b() + "." + rl.func_110623_a(), entry.getValue() == false));
        }
        builder.pop();
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER || EffectiveSide.get() == LogicalSide.SERVER) {
            return;
        }
        builder.push("client");
        contributorEffectCfg = builder.define("contributorEffect", (Object)"");
        globalTooltipCfg = builder.comment("Show customized tooltips from any item. Mainly for pack devs").translation("kiwi.config.globalTooltip").define("globalTooltip", globalTooltip);
        tooltipWrapWidthCfg = builder.comment("Max line width shown in description of tooltips").translation("kiwi.config.tooltipWrapWidth").defineInRange("tooltipWrapWidth", tooltipWrapWidth, 50, Integer.MAX_VALUE);
        debugTooltipCfg = builder.comment("Show item tags and nbt in advanced tooltips").translation("kiwi.config.debugTooltip").define("debugTooltip", debugTooltip);
        debugTooltipNBTFormatterCfg = builder.comment("Allowed values: vanilla, kiwi").translation("kiwi.config.tooltipNBTFormatter").define("debugTooltipNBTFormatter", (Object)debugTooltipNBTFormatter);
    }

    public static void refresh() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER || EffectiveSide.get() == LogicalSide.SERVER) {
            return;
        }
        contributorEffect = Util.RL((String)contributorEffectCfg.get());
        globalTooltip = (Boolean)globalTooltipCfg.get();
        tooltipWrapWidth = (Integer)tooltipWrapWidthCfg.get();
        debugTooltip = (Boolean)debugTooltipCfg.get();
        debugTooltipNBTFormatter = ((String)debugTooltipNBTFormatterCfg.get()).toLowerCase(Locale.ENGLISH);
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        KiwiConfig.refresh();
    }

    static {
        contributorEffect = null;
        globalTooltip = false;
        tooltipWrapWidth = 500;
        debugTooltip = true;
        debugTooltipNBTFormatter = "vanilla";
        modules = Maps.newHashMap();
        Pair specPair = new ForgeConfigSpec.Builder().configure(KiwiConfig::new);
        spec = (ForgeConfigSpec)specPair.getRight();
    }
}

