/*
 * Decompiled with CFR 0.152.
 */
package third_party.com.facebook.yoga;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import third_party.com.facebook.yoga.YogaAlign;
import third_party.com.facebook.yoga.YogaCachedMeasurement;
import third_party.com.facebook.yoga.YogaCollectFlexItemsRowValues;
import third_party.com.facebook.yoga.YogaConfig;
import third_party.com.facebook.yoga.YogaDelegates;
import third_party.com.facebook.yoga.YogaDimension;
import third_party.com.facebook.yoga.YogaDirection;
import third_party.com.facebook.yoga.YogaDisplay;
import third_party.com.facebook.yoga.YogaEdge;
import third_party.com.facebook.yoga.YogaExperimentalFeature;
import third_party.com.facebook.yoga.YogaFlexDirection;
import third_party.com.facebook.yoga.YogaJustify;
import third_party.com.facebook.yoga.YogaLayout;
import third_party.com.facebook.yoga.YogaMath;
import third_party.com.facebook.yoga.YogaMeasureMode;
import third_party.com.facebook.yoga.YogaNodeType;
import third_party.com.facebook.yoga.YogaOverflow;
import third_party.com.facebook.yoga.YogaPositionType;
import third_party.com.facebook.yoga.YogaSize;
import third_party.com.facebook.yoga.YogaStyle;
import third_party.com.facebook.yoga.YogaUnit;
import third_party.com.facebook.yoga.YogaValue;
import third_party.com.facebook.yoga.YogaWrap;

public class YogaNode
implements Iterable<YogaNode> {
    public static final float DefaultFlexGrow = 0.0f;
    public static final float DefaultFlexShrink = 0.0f;
    public static final float WebDefaultFlexShrink = 1.0f;
    private static final AtomicInteger _instanceCount = new AtomicInteger();
    public Consumer<YogaNode> _print;
    public boolean _hasNewLayout;
    public YogaNodeType _nodeType;
    private YogaDelegates.YogaMeasure _measure;
    public YogaDelegates.YogaBaseline _baseline;
    private boolean _isReferenceBaseline;
    public Consumer<YogaNode> _dirtied;
    private YogaStyle _style;
    private YogaLayout _layout;
    public int _lineIndex;
    public YogaNode _owner;
    private List<YogaNode> _children;
    public YogaNode _nextChild;
    public YogaConfig _config;
    private boolean _isDirty;
    private YogaValue[] _resolvedDimensions;
    public static final YogaConfig defaultConfig = new YogaConfig();
    private static final YogaEdge[] Leading = new YogaEdge[]{YogaEdge.Top, YogaEdge.Bottom, YogaEdge.Left, YogaEdge.Right};
    private static final YogaEdge[] Trailing = new YogaEdge[]{YogaEdge.Bottom, YogaEdge.Top, YogaEdge.Right, YogaEdge.Left};
    private static final YogaEdge[] Position = new YogaEdge[]{YogaEdge.Top, YogaEdge.Bottom, YogaEdge.Left, YogaEdge.Right};
    private static final YogaDimension[] Dimension = new YogaDimension[]{YogaDimension.Height, YogaDimension.Height, YogaDimension.Width, YogaDimension.Width};
    private static int gDepth = 0;
    private static int gCurrentGenerationCount = 0;
    public Object _data;

    public YogaNode() {
        this._print = null;
        this._hasNewLayout = true;
        this._nodeType = YogaNodeType.Default;
        this._measure = null;
        this._baseline = null;
        this._dirtied = null;
        this._style = new YogaStyle();
        this._layout = new YogaLayout();
        this._lineIndex = 0;
        this._owner = null;
        this._children = new ArrayList<YogaNode>();
        this._nextChild = null;
        this._config = defaultConfig;
        this._isDirty = false;
        this._resolvedDimensions = new YogaValue[]{YogaValue.UNDEFINED, YogaValue.UNDEFINED};
        _instanceCount.incrementAndGet();
    }

    public YogaNode(YogaNode node) {
        this._print = node._print;
        this._hasNewLayout = node._hasNewLayout;
        this._nodeType = node._nodeType;
        this._measure = node._measure;
        this._baseline = node._baseline;
        this._dirtied = node._dirtied;
        this._style = node._style;
        this._layout = node._layout;
        this._lineIndex = node._lineIndex;
        this._owner = node._owner;
        this._children = new ArrayList<YogaNode>(node._children);
        this._nextChild = node._nextChild;
        this._config = node._config;
        this._isDirty = node._isDirty;
        this._resolvedDimensions = Arrays.copyOf(node._resolvedDimensions, 2);
        _instanceCount.incrementAndGet();
    }

    public YogaNode(YogaNode node, YogaNode owner) {
        this(node);
        this._owner = owner;
    }

    public YogaNode(Consumer<YogaNode> print, boolean hasNewLayout, YogaNodeType nodeType, YogaDelegates.YogaMeasure measure, YogaDelegates.YogaBaseline baseline, Consumer<YogaNode> dirtied, YogaStyle style, YogaLayout layout, int lineIndex, YogaNode owner, List<YogaNode> children, YogaNode nextChild, YogaConfig config, boolean isDirty, YogaValue[] resolvedDimensions) {
        this._print = print;
        this._hasNewLayout = hasNewLayout;
        this._nodeType = nodeType;
        this._measure = measure;
        this._baseline = baseline;
        this._dirtied = dirtied;
        this._style = style;
        this._layout = layout;
        this._lineIndex = lineIndex;
        this._owner = owner;
        this._children = new ArrayList<YogaNode>(children);
        this._nextChild = nextChild;
        this._config = config;
        this._isDirty = isDirty;
        this._resolvedDimensions = Arrays.copyOf(resolvedDimensions, 2);
        _instanceCount.incrementAndGet();
    }

    public YogaNode(YogaConfig config) {
        this();
        YogaConfig yogaConfig = this._config = config != null ? config : defaultConfig;
        if (this._config.UseWebDefaults) {
            this._style.FlexDirection = YogaFlexDirection.Row;
            this._style.AlignContent = YogaAlign.Stretch;
        }
    }

    protected void finalize() throws Throwable {
        _instanceCount.decrementAndGet();
    }

    public static int GetInstanceCount() {
        return _instanceCount.get();
    }

    public YogaDelegates.YogaMeasure GetMeasure() {
        return this._measure;
    }

    public void SetMeasure(YogaDelegates.YogaMeasure value) {
        if (!this._children.isEmpty()) {
            throw new UnsupportedOperationException("Cannot set measure function: Nodes with measure functions cannot have children.");
        }
        if (value == null) {
            this._measure = null;
            this._nodeType = YogaNodeType.Default;
        } else {
            this._measure = value;
            this._nodeType = YogaNodeType.Text;
        }
        this._measure = value;
    }

    public YogaStyle GetStyle() {
        return this._style;
    }

    public void SetStyle(YogaStyle value) {
        this._style.CopyFrom(value);
    }

    public YogaLayout GetLayout() {
        return this._layout;
    }

    public void SetLayout(YogaLayout value) {
        this._layout.CopyFrom(value);
    }

    public List<YogaNode> GetChildren() {
        return this._children;
    }

    public void SetChildren(List<YogaNode> value) {
        this._children = value != null ? new ArrayList<YogaNode>() : new ArrayList<YogaNode>(value);
    }

    public YogaNode GetChild(int index) {
        return this._children.get(index);
    }

    public boolean GetIsDirty() {
        return this._isDirty;
    }

    public void SetIsDirty(boolean value) {
        if (value == this._isDirty) {
            return;
        }
        this._isDirty = value;
        if (value && this._dirtied != null) {
            this._dirtied.accept(this);
        }
    }

    public YogaValue[] GetResolvedDimensions() {
        return this._resolvedDimensions;
    }

    public YogaValue GetResolvedDimension(YogaDimension index) {
        return this._resolvedDimensions[index.ordinal()];
    }

    public float GetLeadingPosition(YogaFlexDirection axis, float axisSize) {
        YogaValue leadingPosition = YogaValue.UNDEFINED;
        if (axis.IsRow()) {
            leadingPosition = YogaNode.ComputedEdgeValue(this._style.Position, YogaEdge.Start, YogaValue.UNDEFINED);
            if (leadingPosition.Unit != YogaUnit.Undefined) {
                return leadingPosition.Resolve(axisSize);
            }
        }
        leadingPosition = YogaNode.ComputedEdgeValue(this._style.Position, Leading[axis.ordinal()], YogaValue.UNDEFINED);
        return leadingPosition.Unit == YogaUnit.Undefined ? 0.0f : leadingPosition.Resolve(axisSize);
    }

    public float GetTrailingPosition(YogaFlexDirection axis, float axisSize) {
        YogaValue trailingPosition = YogaValue.UNDEFINED;
        if (axis.IsRow()) {
            trailingPosition = YogaNode.ComputedEdgeValue(this._style.Position, YogaEdge.End, YogaValue.UNDEFINED);
            if (trailingPosition.Unit != YogaUnit.Undefined) {
                return trailingPosition.Resolve(axisSize);
            }
        }
        trailingPosition = YogaNode.ComputedEdgeValue(this._style.Position, Trailing[axis.ordinal()], YogaValue.UNDEFINED);
        return trailingPosition.Unit == YogaUnit.Undefined ? 0.0f : trailingPosition.Resolve(axisSize);
    }

    public float GetRelativePosition(YogaFlexDirection axis, float axisSize) {
        return this.IsLeadingPositionDefined(axis) ? this.GetLeadingPosition(axis, axisSize) : -this.GetTrailingPosition(axis, axisSize);
    }

    public boolean IsLeadingPositionDefined(YogaFlexDirection axis) {
        return axis.IsRow() && YogaNode.ComputedEdgeValue((YogaValue[])this._style.Position, (YogaEdge)YogaEdge.Start, (YogaValue)YogaValue.UNDEFINED).Unit != YogaUnit.Undefined || YogaNode.ComputedEdgeValue((YogaValue[])this._style.Position, (YogaEdge)YogaNode.Leading[axis.ordinal()], (YogaValue)YogaValue.UNDEFINED).Unit != YogaUnit.Undefined;
    }

    public boolean IsTrailingPositionDefined(YogaFlexDirection axis) {
        return axis.IsRow() && YogaNode.ComputedEdgeValue((YogaValue[])this._style.Position, (YogaEdge)YogaEdge.End, (YogaValue)YogaValue.UNDEFINED).Unit != YogaUnit.Undefined || YogaNode.ComputedEdgeValue((YogaValue[])this._style.Position, (YogaEdge)YogaNode.Trailing[axis.ordinal()], (YogaValue)YogaValue.UNDEFINED).Unit != YogaUnit.Undefined;
    }

    public float GetLeadingMargin(YogaFlexDirection axis, float widthSize) {
        if (axis.IsRow() && this._style.Margin[YogaEdge.Start.ordinal()].Unit != YogaUnit.Undefined) {
            return YogaNode.ResolveValueMargin(this._style.Margin[YogaEdge.Start.ordinal()], widthSize);
        }
        return YogaNode.ResolveValueMargin(YogaNode.ComputedEdgeValue(this._style.Margin, Leading[axis.ordinal()], YogaValue.ZERO), widthSize);
    }

    public float GetTrailingMargin(YogaFlexDirection axis, float widthSize) {
        if (axis.IsRow() && this._style.Margin[YogaEdge.End.ordinal()].Unit != YogaUnit.Undefined) {
            return YogaNode.ResolveValueMargin(this._style.Margin[YogaEdge.End.ordinal()], widthSize);
        }
        return YogaNode.ResolveValueMargin(YogaNode.ComputedEdgeValue(this._style.Margin, Trailing[axis.ordinal()], YogaValue.ZERO), widthSize);
    }

    public float GetMarginForAxis(YogaFlexDirection axis, float widthSize) {
        return this.GetLeadingMargin(axis, widthSize) + this.GetTrailingMargin(axis, widthSize);
    }

    public YogaValue GetMarginLeadingValue(YogaFlexDirection axis) {
        if (axis.IsRow() && this._style.Margin[YogaEdge.Start.ordinal()].Unit != YogaUnit.Undefined) {
            return this._style.Margin[YogaEdge.Start.ordinal()];
        }
        return this._style.Margin[Leading[axis.ordinal()].ordinal()];
    }

    public YogaValue GetMarginTrailingValue(YogaFlexDirection axis) {
        if (axis.IsRow() && this._style.Margin[YogaEdge.End.ordinal()].Unit != YogaUnit.Undefined) {
            return this._style.Margin[YogaEdge.End.ordinal()];
        }
        return this._style.Margin[Trailing[axis.ordinal()].ordinal()];
    }

    public float GetLeadingBorder(YogaFlexDirection axis) {
        if (axis.IsRow() && this._style.Border[YogaEdge.Start.ordinal()].Unit != YogaUnit.Undefined && !Float.isNaN(this._style.Border[YogaEdge.Start.ordinal()].Value) && this._style.Border[YogaEdge.Start.ordinal()].Value >= 0.0f) {
            return this._style.Border[YogaEdge.Start.ordinal()].Value;
        }
        float computedEdgeValue = YogaNode.ComputedEdgeValue((YogaValue[])this._style.Border, (YogaEdge)YogaNode.Leading[axis.ordinal()], (YogaValue)YogaValue.ZERO).Value;
        return YogaMath.Max(computedEdgeValue, 0.0f);
    }

    public float GetTrailingBorder(YogaFlexDirection flexDirection) {
        if (flexDirection.IsRow() && this._style.Border[YogaEdge.End.ordinal()].Unit != YogaUnit.Undefined && !Float.isNaN(this._style.Border[YogaEdge.End.ordinal()].Value) && this._style.Border[YogaEdge.End.ordinal()].Value >= 0.0f) {
            return this._style.Border[YogaEdge.End.ordinal()].Value;
        }
        float computedEdgeValue = YogaNode.ComputedEdgeValue((YogaValue[])this._style.Border, (YogaEdge)YogaNode.Trailing[flexDirection.ordinal()], (YogaValue)YogaValue.ZERO).Value;
        return YogaMath.Max(computedEdgeValue, 0.0f);
    }

    public float GetLeadingPadding(YogaFlexDirection axis, float widthSize) {
        float paddingEdgeStart = this._style.Padding[YogaEdge.Start.ordinal()].Resolve(widthSize);
        if (axis.IsRow() && this._style.Padding[YogaEdge.Start.ordinal()].Unit != YogaUnit.Undefined && !Float.isNaN(paddingEdgeStart) && paddingEdgeStart >= 0.0f) {
            return paddingEdgeStart;
        }
        float resolvedValue = YogaNode.ComputedEdgeValue(this._style.Padding, Leading[axis.ordinal()], YogaValue.ZERO).Resolve(widthSize);
        return YogaMath.Max(resolvedValue, 0.0f);
    }

    public float GetTrailingPadding(YogaFlexDirection axis, float widthSize) {
        float paddingEdgeEnd = this._style.Padding[YogaEdge.End.ordinal()].Resolve(widthSize);
        if (axis.IsRow() && this._style.Padding[YogaEdge.End.ordinal()].Unit != YogaUnit.Undefined && !Float.isNaN(paddingEdgeEnd) && paddingEdgeEnd >= 0.0f) {
            return paddingEdgeEnd;
        }
        float resolvedValue = YogaNode.ComputedEdgeValue(this._style.Padding, Trailing[axis.ordinal()], YogaValue.ZERO).Resolve(widthSize);
        return YogaMath.Max(resolvedValue, 0.0f);
    }

    public float GetLeadingPaddingAndBorder(YogaFlexDirection axis, float widthSize) {
        return this.GetLeadingPadding(axis, widthSize) + this.GetLeadingBorder(axis);
    }

    public float GetTrailingPaddingAndBorder(YogaFlexDirection axis, float widthSize) {
        return this.GetTrailingPadding(axis, widthSize) + this.GetTrailingBorder(axis);
    }

    public float ResolveFlexGrow() {
        if (this._owner == null) {
            return 0.0f;
        }
        if (!Float.isNaN(this._style.FlexGrow)) {
            return this._style.FlexGrow;
        }
        if (!Float.isNaN(this._style.Flex) && this._style.Flex > 0.0f) {
            return this._style.Flex;
        }
        return 0.0f;
    }

    public float ResolveFlexShrink() {
        if (this._owner == null) {
            return 0.0f;
        }
        if (!Float.isNaN(this._style.FlexShrink)) {
            return this._style.FlexShrink;
        }
        if (!this._config.UseWebDefaults && !Float.isNaN(this._style.Flex) && this._style.Flex < 0.0f) {
            return -this._style.Flex;
        }
        return this._config.UseWebDefaults ? 1.0f : 0.0f;
    }

    public YogaValue ResolveFlexBasis() {
        YogaValue flexBasis = this._style.FlexBasis;
        if (flexBasis.Unit != YogaUnit.Auto && flexBasis.Unit != YogaUnit.Undefined) {
            return flexBasis;
        }
        if (!Float.isNaN(this._style.Flex) && this._style.Flex > 0.0f) {
            return this._config.UseWebDefaults ? YogaValue.AUTO : YogaValue.ZERO;
        }
        return YogaValue.AUTO;
    }

    public void ResolveDimension() {
        for (int dim = YogaDimension.Width.ordinal(); dim < 2; ++dim) {
            this._resolvedDimensions[dim] = this._style.MaxDimensions[dim].Unit != YogaUnit.Undefined && this._style.MaxDimensions[dim].equals(this._style.MinDimensions[dim]) ? this._style.MaxDimensions[dim] : this._style.Dimensions[dim];
        }
    }

    public YogaDirection ResolveDirection(YogaDirection ownerDirection) {
        if (this._style.Direction == YogaDirection.Inherit) {
            return ownerDirection.ordinal() > YogaDirection.Inherit.ordinal() ? ownerDirection : YogaDirection.LeftToRight;
        }
        return this._style.Direction;
    }

    public boolean IsNodeFlexible() {
        return this._style.PositionType == YogaPositionType.Relative && (this.ResolveFlexGrow() != 0.0f || this.ResolveFlexShrink() != 0.0f);
    }

    public boolean DidUseLegacyFlag() {
        boolean didUseLegacyFlag = this._layout.DidUseLegacyFlag;
        if (didUseLegacyFlag) {
            return true;
        }
        for (YogaNode child : this._children) {
            if (!child._layout.DidUseLegacyFlag) continue;
            return true;
        }
        return false;
    }

    public void SetLayoutMargin(float margin, YogaEdge index) {
        this._layout.Margin[index.ordinal()] = margin;
    }

    public void SetLayoutBorder(float border, YogaEdge index) {
        this._layout.Border[index.ordinal()] = border;
    }

    public void SetLayoutPadding(float padding, YogaEdge index) {
        this._layout.Padding[index.ordinal()] = padding;
    }

    public void SetLayoutPosition(float position, YogaEdge index) {
        this._layout.Position[index.ordinal()] = position;
    }

    public void SetLayoutMeasuredDimension(float measuredDimension, YogaDimension index) {
        this._layout.MeasuredDimensions[index.ordinal()] = measuredDimension;
    }

    public void SetLayoutDimension(float dimension, YogaDimension index) {
        this._layout.Dimensions[index.ordinal()] = dimension;
    }

    public void SetPosition(YogaDirection direction, float mainSize, float crossSize, float ownerWidth) {
        YogaDirection directionRespectingRoot = this._owner != null ? direction : YogaDirection.LeftToRight;
        YogaFlexDirection mainAxis = this._style.FlexDirection.ResolveFlexDirection(directionRespectingRoot);
        YogaFlexDirection crossAxis = mainAxis.FlexDirectionCross(directionRespectingRoot);
        float relativePositionMain = this.GetRelativePosition(mainAxis, mainSize);
        float relativePositionCross = this.GetRelativePosition(crossAxis, crossSize);
        this.SetLayoutPosition(this.GetLeadingMargin(mainAxis, ownerWidth) + relativePositionMain, Leading[mainAxis.ordinal()]);
        this.SetLayoutPosition(this.GetTrailingMargin(mainAxis, ownerWidth) + relativePositionMain, Trailing[mainAxis.ordinal()]);
        this.SetLayoutPosition(this.GetLeadingMargin(crossAxis, ownerWidth) + relativePositionCross, Leading[crossAxis.ordinal()]);
        this.SetLayoutPosition(this.GetTrailingMargin(crossAxis, ownerWidth) + relativePositionCross, Trailing[crossAxis.ordinal()]);
    }

    public void SetAndPropogateUseLegacyFlag(boolean useLegacyFlag) {
        this._config.UseLegacyStretchBehaviour = useLegacyFlag;
        for (YogaNode item : this._children) {
            item._config.UseLegacyStretchBehaviour = useLegacyFlag;
        }
    }

    public int IndexOf(YogaNode node) {
        return this._children.indexOf(node);
    }

    public void Clear() {
        for (YogaNode item : this._children) {
            item._owner = null;
        }
        this._children.clear();
        this._isDirty = true;
    }

    public void ReplaceChild(YogaNode oldChild, YogaNode newChild) {
        int index = this._children.indexOf(oldChild);
        if (index < 0) {
            return;
        }
        newChild._owner = this;
        this._children.set(index, newChild);
        this.MarkDirty();
    }

    public void ReplaceChild(YogaNode child, int index) {
        child._owner = this;
        this._children.set(index, child);
        this.MarkDirty();
    }

    public void Insert(int index, YogaNode child) {
        if (child._owner != null) {
            throw new UnsupportedOperationException("Child already has a owner, it must be removed first.");
        }
        if (this._measure != null) {
            throw new UnsupportedOperationException("Cannot add child: Nodes with measure functions cannot have children.");
        }
        child._owner = this;
        this._children.add(index, child);
        this.MarkDirty();
    }

    public boolean Remove(YogaNode child) {
        boolean result;
        if (child._owner == this) {
            child._owner = null;
        }
        if (result = this._children.remove(child)) {
            this.MarkDirty();
        }
        return result;
    }

    public void RemoveAt(int index) {
        YogaNode child = this._children.get(index);
        child._owner = null;
        this._children.remove(index);
        this.MarkDirty();
    }

    public void MarkDirty() {
        if (!this._isDirty) {
            this._isDirty = true;
            this._layout.ComputedFlexBasis = Float.NaN;
            if (this._owner != null) {
                this._owner.MarkDirty();
            }
        }
    }

    public void MarkDirtyAndPropogateDownwards() {
        this._isDirty = true;
        for (YogaNode item : this._children) {
            item.MarkDirtyAndPropogateDownwards();
        }
    }

    public boolean IsLayoutTreeEqualToNode(YogaNode node) {
        if (this._children.size() != node._children.size()) {
            return false;
        }
        if (this._layout != node._layout) {
            return false;
        }
        if (this._children.size() == 0) {
            return true;
        }
        boolean isLayoutTreeEqual = true;
        YogaNode otherNodeChildren = null;
        for (int i = 0; i < this._children.size(); ++i) {
            otherNodeChildren = node._children.get(i);
            isLayoutTreeEqual = this._children.get(i).IsLayoutTreeEqualToNode(otherNodeChildren);
            if (isLayoutTreeEqual) continue;
            return false;
        }
        return isLayoutTreeEqual;
    }

    private void SetChildTrailingPosition(YogaNode child, YogaFlexDirection axis) {
        float size = child._layout.MeasuredDimensions[Dimension[axis.ordinal()].ordinal()];
        child.SetLayoutPosition(this._layout.MeasuredDimensions[Dimension[axis.ordinal()].ordinal()] - size - child._layout.Position[Position[axis.ordinal()].ordinal()], Trailing[axis.ordinal()]);
    }

    private void CloneChildrenIfNeeded() {
        int childCount = this._children.size();
        if (childCount == 0) {
            return;
        }
        YogaNode firstChild = this._children.get(0);
        if (firstChild._owner == this) {
            return;
        }
        YogaDelegates.YogaNodeCloned cloneNodeCallback = this._config.OnNodeCloned;
        for (int i = 0; i < childCount; ++i) {
            YogaNode oldChild = this._children.get(i);
            YogaNode newChild = new YogaNode(oldChild);
            newChild._owner = null;
            this.ReplaceChild(newChild, i);
            newChild._owner = this;
            if (cloneNodeCallback == null) continue;
            cloneNodeCallback.apply(oldChild, newChild, this, i);
        }
    }

    private static float ResolveValueMargin(YogaValue value, float ownerSize) {
        return value.Unit == YogaUnit.Auto ? 0.0f : value.Resolve(ownerSize);
    }

    private static YogaValue ComputedEdgeValue(YogaValue[] edges, YogaEdge edge, YogaValue defaultValue) {
        if (edges[edge.ordinal()].Unit != YogaUnit.Undefined) {
            return edges[edge.ordinal()];
        }
        if ((edge == YogaEdge.Top || edge == YogaEdge.Bottom) && edges[YogaEdge.Vertical.ordinal()].Unit != YogaUnit.Undefined) {
            return edges[YogaEdge.Vertical.ordinal()];
        }
        if ((edge == YogaEdge.Left || edge == YogaEdge.Right || edge == YogaEdge.Start || edge == YogaEdge.End) && edges[YogaEdge.Horizontal.ordinal()].Unit != YogaUnit.Undefined) {
            return edges[YogaEdge.Horizontal.ordinal()];
        }
        if (edges[YogaEdge.All.ordinal()].Unit != YogaUnit.Undefined) {
            return edges[YogaEdge.All.ordinal()];
        }
        if (edge == YogaEdge.Start || edge == YogaEdge.End) {
            return YogaValue.UNDEFINED;
        }
        return defaultValue;
    }

    public void CalculateLayout() {
        this.CalculateLayout(Float.NaN, Float.NaN, this.GetStyleDirection());
    }

    public void CalculateLayout(float ownerWidth, float ownerHeight, YogaDirection ownerDirection) {
        ++gCurrentGenerationCount;
        this.ResolveDimension();
        float width = Float.NaN;
        YogaMeasureMode widthMeasureMode = YogaMeasureMode.Undefined;
        if (this.IsStyleDimensionDefined(YogaFlexDirection.Row, ownerWidth)) {
            width = this.GetResolvedDimension(Dimension[YogaFlexDirection.Row.ordinal()]).Resolve(ownerWidth) + this.GetMarginForAxis(YogaFlexDirection.Row, ownerWidth);
            widthMeasureMode = YogaMeasureMode.Exactly;
        } else if (!Float.isNaN(this._style.MaxDimensions[YogaDimension.Width.ordinal()].Resolve(ownerWidth))) {
            width = this._style.MaxDimensions[YogaDimension.Width.ordinal()].Resolve(ownerWidth);
            widthMeasureMode = YogaMeasureMode.AtMost;
        } else {
            width = ownerWidth;
            widthMeasureMode = Float.isNaN(width) ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
        }
        float height = Float.NaN;
        YogaMeasureMode heightMeasureMode = YogaMeasureMode.Undefined;
        if (this.IsStyleDimensionDefined(YogaFlexDirection.Column, ownerHeight)) {
            height = this.GetResolvedDimension(Dimension[YogaFlexDirection.Column.ordinal()]).Resolve(ownerHeight) + this.GetMarginForAxis(YogaFlexDirection.Column, ownerWidth);
            heightMeasureMode = YogaMeasureMode.Exactly;
        } else if (!Float.isNaN(this._style.MaxDimensions[YogaDimension.Height.ordinal()].Resolve(ownerHeight))) {
            height = this._style.MaxDimensions[YogaDimension.Height.ordinal()].Resolve(ownerHeight);
            heightMeasureMode = YogaMeasureMode.AtMost;
        } else {
            height = ownerHeight;
            YogaMeasureMode yogaMeasureMode = heightMeasureMode = Float.isNaN(height) ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
        }
        if (this.LayoutNode(width, height, ownerDirection, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, true, "initial", this._config)) {
            this.SetPosition(this._layout.Direction, ownerWidth, ownerHeight, ownerWidth);
            this.RoundToPixelGrid(this._config.PointScaleFactor, 0.0f, 0.0f);
        }
        if (this._config.ShouldDiffLayoutWithoutLegacyStretchBehaviour && this.DidUseLegacyFlag()) {
            YogaNode originalNode = this.DeepClone();
            originalNode.ResolveDimension();
            originalNode.MarkDirtyAndPropogateDownwards();
            ++gCurrentGenerationCount;
            originalNode.SetAndPropogateUseLegacyFlag(false);
            if (originalNode.LayoutNode(width, height, ownerDirection, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, true, "initial", originalNode._config)) {
                originalNode.SetPosition(originalNode._layout.Direction, ownerWidth, ownerHeight, ownerWidth);
                originalNode.RoundToPixelGrid(originalNode._config.PointScaleFactor, 0.0f, 0.0f);
                this._layout.DoesLegacyStretchFlagAffectsLayout = !originalNode.IsLayoutTreeEqualToNode(this);
            }
        }
    }

    private boolean LayoutNode(float availableWidth, float availableHeight, YogaDirection ownerDirection, YogaMeasureMode widthMeasureMode, YogaMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight, boolean performLayout, String reason, YogaConfig config) {
        boolean needToVisitNode;
        YogaLayout layout = this._layout;
        ++gDepth;
        boolean bl = needToVisitNode = this._isDirty && layout.GenerationCount != gCurrentGenerationCount || layout.LastOwnerDirection != ownerDirection;
        if (needToVisitNode) {
            layout.NextCachedMeasurementsIndex = 0;
            layout.CachedLayout.WidthMeasureMode = null;
            layout.CachedLayout.HeightMeasureMode = null;
            layout.CachedLayout.ComputedWidth = -1.0f;
            layout.CachedLayout.ComputedHeight = -1.0f;
        }
        YogaCachedMeasurement cachedResults = null;
        if (this._measure != null) {
            float marginAxisColumn;
            float marginAxisRow = this.GetMarginForAxis(YogaFlexDirection.Row, ownerWidth);
            if (YogaNode.CanUseCachedMeasurement(widthMeasureMode, availableWidth, heightMeasureMode, availableHeight, layout.CachedLayout.WidthMeasureMode, layout.CachedLayout.AvailableWidth, layout.CachedLayout.HeightMeasureMode, layout.CachedLayout.AvailableHeight, layout.CachedLayout.ComputedWidth, layout.CachedLayout.ComputedHeight, marginAxisRow, marginAxisColumn = this.GetMarginForAxis(YogaFlexDirection.Column, ownerWidth), config)) {
                cachedResults = layout.CachedLayout;
            } else {
                for (int i = 0; i < layout.NextCachedMeasurementsIndex; ++i) {
                    if (!YogaNode.CanUseCachedMeasurement(widthMeasureMode, availableWidth, heightMeasureMode, availableHeight, layout.CachedMeasurements[i].WidthMeasureMode, layout.CachedMeasurements[i].AvailableWidth, layout.CachedMeasurements[i].HeightMeasureMode, layout.CachedMeasurements[i].AvailableHeight, layout.CachedMeasurements[i].ComputedWidth, layout.CachedMeasurements[i].ComputedHeight, marginAxisRow, marginAxisColumn, config)) continue;
                    cachedResults = layout.CachedMeasurements[i];
                    break;
                }
            }
        } else if (performLayout) {
            if (YogaMath.FloatsEqual(layout.CachedLayout.AvailableWidth, availableWidth) && YogaMath.FloatsEqual(layout.CachedLayout.AvailableHeight, availableHeight) && layout.CachedLayout.WidthMeasureMode == widthMeasureMode && layout.CachedLayout.HeightMeasureMode == heightMeasureMode) {
                cachedResults = layout.CachedLayout;
            }
        } else {
            for (int i = 0; i < layout.NextCachedMeasurementsIndex; ++i) {
                if (!YogaMath.FloatsEqual(layout.CachedMeasurements[i].AvailableWidth, availableWidth) || !YogaMath.FloatsEqual(layout.CachedMeasurements[i].AvailableHeight, availableHeight) || layout.CachedMeasurements[i].WidthMeasureMode != widthMeasureMode || layout.CachedMeasurements[i].HeightMeasureMode != heightMeasureMode) continue;
                cachedResults = layout.CachedMeasurements[i];
                break;
            }
        }
        if (!needToVisitNode && cachedResults != null) {
            layout.MeasuredDimensions[YogaDimension.Width.ordinal()] = cachedResults.ComputedWidth;
            layout.MeasuredDimensions[YogaDimension.Height.ordinal()] = cachedResults.ComputedHeight;
        } else {
            this.LayoutNode(availableWidth, availableHeight, ownerDirection, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, performLayout, config);
            layout.LastOwnerDirection = ownerDirection;
            if (cachedResults == null) {
                if (layout.NextCachedMeasurementsIndex == 8) {
                    layout.NextCachedMeasurementsIndex = 0;
                }
                YogaCachedMeasurement newCacheEntry = new YogaCachedMeasurement();
                if (performLayout) {
                    newCacheEntry = layout.CachedLayout;
                } else {
                    newCacheEntry = layout.CachedMeasurements[layout.NextCachedMeasurementsIndex];
                    ++layout.NextCachedMeasurementsIndex;
                }
                newCacheEntry.AvailableWidth = availableWidth;
                newCacheEntry.AvailableHeight = availableHeight;
                newCacheEntry.WidthMeasureMode = widthMeasureMode;
                newCacheEntry.HeightMeasureMode = heightMeasureMode;
                newCacheEntry.ComputedWidth = layout.MeasuredDimensions[YogaDimension.Width.ordinal()];
                newCacheEntry.ComputedHeight = layout.MeasuredDimensions[YogaDimension.Height.ordinal()];
            }
        }
        if (performLayout) {
            this.SetLayoutDimension(this._layout.MeasuredDimensions[YogaDimension.Width.ordinal()], YogaDimension.Width);
            this.SetLayoutDimension(this._layout.MeasuredDimensions[YogaDimension.Height.ordinal()], YogaDimension.Height);
            this._hasNewLayout = true;
            this._isDirty = false;
        }
        --gDepth;
        layout.GenerationCount = gCurrentGenerationCount;
        return needToVisitNode || cachedResults == null;
    }

    private void LayoutNode(float availableWidth, float availableHeight, YogaDirection ownerDirection, YogaMeasureMode widthMeasureMode, YogaMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight, boolean performLayout, YogaConfig config) {
        boolean flexBasisOverflows;
        YogaDirection direction;
        this._layout.Direction = direction = this.ResolveDirection(ownerDirection);
        YogaFlexDirection flexRowDirection = YogaFlexDirection.Row.ResolveFlexDirection(direction);
        YogaFlexDirection flexColumnDirection = YogaFlexDirection.Column.ResolveFlexDirection(direction);
        this.SetLayoutMargin(this.GetLeadingMargin(flexRowDirection, ownerWidth), YogaEdge.Start);
        this.SetLayoutMargin(this.GetTrailingMargin(flexRowDirection, ownerWidth), YogaEdge.End);
        this.SetLayoutMargin(this.GetLeadingMargin(flexColumnDirection, ownerWidth), YogaEdge.Top);
        this.SetLayoutMargin(this.GetTrailingMargin(flexColumnDirection, ownerWidth), YogaEdge.Bottom);
        this.SetLayoutBorder(this.GetLeadingBorder(flexRowDirection), YogaEdge.Start);
        this.SetLayoutBorder(this.GetTrailingBorder(flexRowDirection), YogaEdge.End);
        this.SetLayoutBorder(this.GetLeadingBorder(flexColumnDirection), YogaEdge.Top);
        this.SetLayoutBorder(this.GetTrailingBorder(flexColumnDirection), YogaEdge.Bottom);
        this.SetLayoutPadding(this.GetLeadingPadding(flexRowDirection, ownerWidth), YogaEdge.Start);
        this.SetLayoutPadding(this.GetTrailingPadding(flexRowDirection, ownerWidth), YogaEdge.End);
        this.SetLayoutPadding(this.GetLeadingPadding(flexColumnDirection, ownerWidth), YogaEdge.Top);
        this.SetLayoutPadding(this.GetTrailingPadding(flexColumnDirection, ownerWidth), YogaEdge.Bottom);
        if (this._measure != null) {
            this.WithMeasureFuncSetMeasuredDimensions(availableWidth, availableHeight, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight);
            return;
        }
        int childCount = this.GetChildCount();
        if (childCount == 0) {
            this.EmptyContainerSetMeasuredDimensions(availableWidth, availableHeight, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight);
            return;
        }
        if (!performLayout && this.FixedSizeSetMeasuredDimensions(availableWidth, availableHeight, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight)) {
            return;
        }
        this.CloneChildrenIfNeeded();
        this._layout.HadOverflow = false;
        YogaFlexDirection mainAxis = this._style.FlexDirection.ResolveFlexDirection(direction);
        YogaFlexDirection crossAxis = mainAxis.FlexDirectionCross(direction);
        boolean isMainAxisRow = mainAxis.IsRow();
        boolean isNodeFlexWrap = this._style.FlexWrap != YogaWrap.NoWrap;
        float mainAxisOwnerSize = isMainAxisRow ? ownerWidth : ownerHeight;
        float crossAxisOwnerSize = isMainAxisRow ? ownerHeight : ownerWidth;
        float leadingPaddingAndBorderCross = this.GetLeadingPaddingAndBorder(crossAxis, ownerWidth);
        float paddingAndBorderAxisMain = this.GetPaddingAndBorderForAxis(mainAxis, ownerWidth);
        float paddingAndBorderAxisCross = this.GetPaddingAndBorderForAxis(crossAxis, ownerWidth);
        YogaMeasureMode measureModeMainDim = isMainAxisRow ? widthMeasureMode : heightMeasureMode;
        YogaMeasureMode measureModeCrossDim = isMainAxisRow ? heightMeasureMode : widthMeasureMode;
        float paddingAndBorderAxisRow = isMainAxisRow ? paddingAndBorderAxisMain : paddingAndBorderAxisCross;
        float paddingAndBorderAxisColumn = isMainAxisRow ? paddingAndBorderAxisCross : paddingAndBorderAxisMain;
        float marginAxisRow = this.GetMarginForAxis(YogaFlexDirection.Row, ownerWidth);
        float marginAxisColumn = this.GetMarginForAxis(YogaFlexDirection.Column, ownerWidth);
        float minInnerWidth = this._style.MinDimensions[YogaDimension.Width.ordinal()].Resolve(ownerWidth) - paddingAndBorderAxisRow;
        float maxInnerWidth = this._style.MaxDimensions[YogaDimension.Width.ordinal()].Resolve(ownerWidth) - paddingAndBorderAxisRow;
        float minInnerHeight = this._style.MinDimensions[YogaDimension.Height.ordinal()].Resolve(ownerHeight) - paddingAndBorderAxisColumn;
        float maxInnerHeight = this._style.MaxDimensions[YogaDimension.Height.ordinal()].Resolve(ownerHeight) - paddingAndBorderAxisColumn;
        float minInnerMainDim = isMainAxisRow ? minInnerWidth : minInnerHeight;
        float maxInnerMainDim = isMainAxisRow ? maxInnerWidth : maxInnerHeight;
        float availableInnerWidth = this.CalculateAvailableInnerDim(YogaFlexDirection.Row, availableWidth, ownerWidth);
        float availableInnerHeight = this.CalculateAvailableInnerDim(YogaFlexDirection.Column, availableHeight, ownerHeight);
        float availableInnerMainDim = isMainAxisRow ? availableInnerWidth : availableInnerHeight;
        float availableInnerCrossDim = isMainAxisRow ? availableInnerHeight : availableInnerWidth;
        float totalOuterFlexBasis = 0.0f;
        totalOuterFlexBasis = this.ComputeFlexBasisForChildren(availableInnerWidth, availableInnerHeight, widthMeasureMode, heightMeasureMode, direction, mainAxis, config, performLayout, totalOuterFlexBasis);
        boolean bl = measureModeMainDim == YogaMeasureMode.Undefined ? false : (flexBasisOverflows = totalOuterFlexBasis > availableInnerMainDim);
        if (isNodeFlexWrap && flexBasisOverflows && measureModeMainDim == YogaMeasureMode.AtMost) {
            measureModeMainDim = YogaMeasureMode.Exactly;
        }
        int startOfLineIndex = 0;
        int endOfLineIndex = 0;
        int lineCount = 0;
        float totalLineCrossDim = 0.0f;
        float maxLineMainDim = 0.0f;
        YogaCollectFlexItemsRowValues collectedFlexItemsValues = new YogaCollectFlexItemsRowValues();
        while (endOfLineIndex < childCount) {
            collectedFlexItemsValues = this.CalculateCollectFlexItemsRowValues(ownerDirection, mainAxisOwnerSize, availableInnerWidth, availableInnerMainDim, startOfLineIndex, lineCount);
            endOfLineIndex = collectedFlexItemsValues.EndOfLineIndex;
            boolean canSkipFlex = !performLayout && measureModeCrossDim == YogaMeasureMode.Exactly;
            boolean sizeBasedOnContent = false;
            if (measureModeMainDim != YogaMeasureMode.Exactly) {
                if (!Float.isNaN(minInnerMainDim) && collectedFlexItemsValues.SizeConsumedOnCurrentLine < minInnerMainDim) {
                    availableInnerMainDim = minInnerMainDim;
                } else if (!Float.isNaN(maxInnerMainDim) && collectedFlexItemsValues.SizeConsumedOnCurrentLine > maxInnerMainDim) {
                    availableInnerMainDim = maxInnerMainDim;
                } else {
                    if (!this._config.UseLegacyStretchBehaviour && (!Float.isNaN(collectedFlexItemsValues.TotalFlexGrowFactors) && collectedFlexItemsValues.TotalFlexGrowFactors == 0.0f || this.ResolveFlexGrow() == 0.0f)) {
                        availableInnerMainDim = collectedFlexItemsValues.SizeConsumedOnCurrentLine;
                    }
                    if (this._config.UseLegacyStretchBehaviour) {
                        this._layout.DidUseLegacyFlag = true;
                    }
                    boolean bl2 = sizeBasedOnContent = !this._config.UseLegacyStretchBehaviour;
                }
            }
            if (!sizeBasedOnContent && !Float.isNaN(availableInnerMainDim)) {
                collectedFlexItemsValues.RemainingFreeSpace = availableInnerMainDim - collectedFlexItemsValues.SizeConsumedOnCurrentLine;
            } else if (collectedFlexItemsValues.SizeConsumedOnCurrentLine < 0.0f) {
                collectedFlexItemsValues.RemainingFreeSpace = -collectedFlexItemsValues.SizeConsumedOnCurrentLine;
            }
            if (!canSkipFlex) {
                this.ResolveFlexibleLength(collectedFlexItemsValues, mainAxis, crossAxis, mainAxisOwnerSize, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, availableInnerHeight, flexBasisOverflows, measureModeCrossDim, performLayout, config);
            }
            this._layout.HadOverflow = this._layout.HadOverflow || collectedFlexItemsValues.RemainingFreeSpace < 0.0f;
            JustifyMainAxisReturn ret = this.JustifyMainAxis(collectedFlexItemsValues, startOfLineIndex, mainAxis, crossAxis, measureModeMainDim, measureModeCrossDim, mainAxisOwnerSize, ownerWidth, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, performLayout);
            ret.collectedFlexItemsValues = collectedFlexItemsValues;
            ret.startOfLineIndex = startOfLineIndex;
            ret.mainAxis = mainAxis;
            ret.crossAxis = crossAxis;
            ret.measureModeMainDim = measureModeMainDim;
            ret.measureModeCrossDim = measureModeCrossDim;
            ret.mainAxisOwnerSize = mainAxisOwnerSize;
            ret.ownerWidth = ownerWidth;
            ret.availableInnerMainDim = availableInnerMainDim;
            ret.availableInnerCrossDim = availableInnerCrossDim;
            ret.availableInnerWidth = availableInnerWidth;
            ret.performLayout = performLayout;
            float containerCrossAxis = availableInnerCrossDim;
            if (measureModeCrossDim == YogaMeasureMode.Undefined || measureModeCrossDim == YogaMeasureMode.AtMost) {
                containerCrossAxis = this.BoundAxis(crossAxis, collectedFlexItemsValues.CrossDimension + paddingAndBorderAxisCross, crossAxisOwnerSize, ownerWidth) - paddingAndBorderAxisCross;
            }
            if (!isNodeFlexWrap && measureModeCrossDim == YogaMeasureMode.Exactly) {
                collectedFlexItemsValues.CrossDimension = availableInnerCrossDim;
            }
            collectedFlexItemsValues.CrossDimension = this.BoundAxis(crossAxis, collectedFlexItemsValues.CrossDimension + paddingAndBorderAxisCross, crossAxisOwnerSize, ownerWidth) - paddingAndBorderAxisCross;
            if (performLayout) {
                for (int i = startOfLineIndex; i < endOfLineIndex; ++i) {
                    YogaNode child = this.GetChild(i);
                    if (child._style.Display == YogaDisplay.None) continue;
                    if (child._style.PositionType == YogaPositionType.Absolute) {
                        boolean isChildLeadingPosDefined = child.IsLeadingPositionDefined(crossAxis);
                        if (isChildLeadingPosDefined) {
                            child.SetLayoutPosition(child.GetLeadingPosition(crossAxis, availableInnerCrossDim) + this.GetLeadingBorder(crossAxis) + child.GetLeadingMargin(crossAxis, availableInnerWidth), Position[crossAxis.ordinal()]);
                        }
                        if (isChildLeadingPosDefined && !Float.isNaN(child._layout.Position[Position[crossAxis.ordinal()].ordinal()])) continue;
                        child.SetLayoutPosition(this.GetLeadingBorder(crossAxis) + child.GetLeadingMargin(crossAxis, availableInnerWidth), Position[crossAxis.ordinal()]);
                        continue;
                    }
                    float leadingCrossDim = leadingPaddingAndBorderCross;
                    YogaAlign alignItem = this.GetAlign(child);
                    if (alignItem == YogaAlign.Stretch && child.GetMarginLeadingValue((YogaFlexDirection)crossAxis).Unit != YogaUnit.Auto && child.GetMarginTrailingValue((YogaFlexDirection)crossAxis).Unit != YogaUnit.Auto) {
                        if (!child.IsStyleDimensionDefined(crossAxis, availableInnerCrossDim)) {
                            float childMainSize = child._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()];
                            float childCrossSize = !Float.isNaN(child._style.AspectRatio) ? child.GetMarginForAxis(crossAxis, availableInnerWidth) + (isMainAxisRow ? childMainSize / child._style.AspectRatio : childMainSize * child._style.AspectRatio) : collectedFlexItemsValues.CrossDimension;
                            YogaMeasureMode childMainMeasureMode = YogaMeasureMode.Exactly;
                            YogaMeasureMode childCrossMeasureMode = YogaMeasureMode.Exactly;
                            AtomicReference<YogaMeasureMode> childMainMeasureModeRef = new AtomicReference<YogaMeasureMode>(childMainMeasureMode);
                            AtomicReference<YogaMeasureMode> childCrossMeasureModeRef = new AtomicReference<YogaMeasureMode>(childCrossMeasureMode);
                            AtomicReference<Float> childMainSizeRef = new AtomicReference<Float>(Float.valueOf(childMainSize += child.GetMarginForAxis(mainAxis, availableInnerWidth)));
                            AtomicReference<Float> childCrossSizeRef = new AtomicReference<Float>(Float.valueOf(childCrossSize));
                            child.ConstrainMaxSizeForMode(mainAxis, availableInnerMainDim, availableInnerWidth, childMainMeasureModeRef, childMainSizeRef);
                            child.ConstrainMaxSizeForMode(crossAxis, availableInnerCrossDim, availableInnerWidth, childCrossMeasureModeRef, childCrossSizeRef);
                            childMainSize = childMainSizeRef.get().floatValue();
                            childCrossSize = childCrossSizeRef.get().floatValue();
                            float childWidth = isMainAxisRow ? childMainSize : childCrossSize;
                            float childHeight = !isMainAxisRow ? childMainSize : childCrossSize;
                            YogaMeasureMode childWidthMeasureMode = Float.isNaN(childWidth) ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
                            YogaMeasureMode childHeightMeasureMode = Float.isNaN(childHeight) ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
                            child.LayoutNode(childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, availableInnerWidth, availableInnerHeight, true, "stretch", config);
                        }
                    } else {
                        float remainingCrossDim = containerCrossAxis - child.GetDimensionWithMargin(crossAxis, availableInnerWidth);
                        if (child.GetMarginLeadingValue((YogaFlexDirection)crossAxis).Unit == YogaUnit.Auto && child.GetMarginTrailingValue((YogaFlexDirection)crossAxis).Unit == YogaUnit.Auto) {
                            leadingCrossDim += YogaMath.Max(0.0f, remainingCrossDim / 2.0f);
                        } else if (child.GetMarginTrailingValue((YogaFlexDirection)crossAxis).Unit != YogaUnit.Auto) {
                            if (child.GetMarginLeadingValue((YogaFlexDirection)crossAxis).Unit == YogaUnit.Auto) {
                                leadingCrossDim += YogaMath.Max(0.0f, remainingCrossDim);
                            } else if (alignItem != YogaAlign.FlexStart) {
                                if (alignItem == YogaAlign.Center) {
                                    if (!Float.isNaN(remainingCrossDim)) {
                                        leadingCrossDim += remainingCrossDim / 2.0f;
                                    }
                                } else if (!Float.isNaN(remainingCrossDim)) {
                                    leadingCrossDim += remainingCrossDim;
                                }
                            }
                        }
                    }
                    child.SetLayoutPosition(child._layout.Position[Position[crossAxis.ordinal()].ordinal()] + totalLineCrossDim + leadingCrossDim, Position[crossAxis.ordinal()]);
                }
            }
            totalLineCrossDim += collectedFlexItemsValues.CrossDimension;
            maxLineMainDim = YogaMath.Max(maxLineMainDim, collectedFlexItemsValues.MainDimension);
            ++lineCount;
            startOfLineIndex = endOfLineIndex;
        }
        if (performLayout && (lineCount > 1 || this.IsBaselineLayout())) {
            float crossDimLead = 0.0f;
            float currentLead = leadingPaddingAndBorderCross;
            if (!Float.isNaN(availableInnerCrossDim)) {
                float remainingAlignContentDim = availableInnerCrossDim - totalLineCrossDim;
                switch (this._style.AlignContent) {
                    case FlexEnd: {
                        currentLead += remainingAlignContentDim;
                        break;
                    }
                    case Center: {
                        currentLead += remainingAlignContentDim / 2.0f;
                        break;
                    }
                    case Stretch: {
                        if (!(availableInnerCrossDim > totalLineCrossDim)) break;
                        crossDimLead = remainingAlignContentDim / (float)lineCount;
                        break;
                    }
                    case SpaceAround: {
                        if (availableInnerCrossDim > totalLineCrossDim) {
                            currentLead += remainingAlignContentDim / (float)(2 * lineCount);
                            if (lineCount <= 1) break;
                            crossDimLead = remainingAlignContentDim / (float)lineCount;
                            break;
                        }
                        currentLead += remainingAlignContentDim / 2.0f;
                        break;
                    }
                    case SpaceBetween: {
                        if (!(availableInnerCrossDim > totalLineCrossDim) || lineCount <= 1) break;
                        crossDimLead = remainingAlignContentDim / (float)(lineCount - 1);
                        break;
                    }
                }
            }
            int endIndex = 0;
            for (int i = 0; i < lineCount; ++i) {
                YogaNode child;
                int ii;
                int startIndex = endIndex;
                float lineHeight = 0.0f;
                float maxAscentForCurrentLine = 0.0f;
                float maxDescentForCurrentLine = 0.0f;
                for (ii = startIndex; ii < childCount; ++ii) {
                    child = this.GetChild(ii);
                    if (child._style.Display == YogaDisplay.None || child._style.PositionType != YogaPositionType.Relative) continue;
                    if (child._lineIndex != i) break;
                    if (child.IsLayoutDimensionDefined(crossAxis)) {
                        lineHeight = YogaMath.Max(lineHeight, child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()] + child.GetMarginForAxis(crossAxis, availableInnerWidth));
                    }
                    if (this.GetAlign(child) != YogaAlign.Baseline) continue;
                    float ascent = YogaNode.CalculateBaseline(child) + child.GetLeadingMargin(YogaFlexDirection.Column, availableInnerWidth);
                    float descent = child._layout.MeasuredDimensions[YogaDimension.Height.ordinal()] + child.GetMarginForAxis(YogaFlexDirection.Column, availableInnerWidth) - ascent;
                    maxAscentForCurrentLine = YogaMath.Max(maxAscentForCurrentLine, ascent);
                    maxDescentForCurrentLine = YogaMath.Max(maxDescentForCurrentLine, descent);
                    lineHeight = YogaMath.Max(lineHeight, maxAscentForCurrentLine + maxDescentForCurrentLine);
                }
                endIndex = ii;
                lineHeight += crossDimLead;
                if (performLayout) {
                    block18: for (ii = startIndex; ii < endIndex; ++ii) {
                        child = this.GetChild(ii);
                        if (child._style.Display == YogaDisplay.None || child._style.PositionType != YogaPositionType.Relative) continue;
                        switch (this.GetAlign(child)) {
                            case FlexStart: {
                                child.SetLayoutPosition(currentLead + child.GetLeadingMargin(crossAxis, availableInnerWidth), Position[crossAxis.ordinal()]);
                                continue block18;
                            }
                            case FlexEnd: {
                                child.SetLayoutPosition(currentLead + lineHeight - child.GetTrailingMargin(crossAxis, availableInnerWidth) - child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()], Position[crossAxis.ordinal()]);
                                continue block18;
                            }
                            case Center: {
                                float childHeight = child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()];
                                child.SetLayoutPosition(currentLead + (lineHeight - childHeight) / 2.0f, Position[crossAxis.ordinal()]);
                                continue block18;
                            }
                            case Stretch: {
                                float childHeight;
                                child.SetLayoutPosition(currentLead + child.GetLeadingMargin(crossAxis, availableInnerWidth), Position[crossAxis.ordinal()]);
                                if (child.IsStyleDimensionDefined(crossAxis, availableInnerCrossDim)) continue block18;
                                float childWidth = isMainAxisRow ? child._layout.MeasuredDimensions[YogaDimension.Width.ordinal()] + child.GetMarginForAxis(mainAxis, availableInnerWidth) : lineHeight;
                                float f = childHeight = !isMainAxisRow ? child._layout.MeasuredDimensions[YogaDimension.Height.ordinal()] + child.GetMarginForAxis(crossAxis, availableInnerWidth) : lineHeight;
                                if (YogaMath.FloatsEqual(childWidth, child._layout.MeasuredDimensions[YogaDimension.Width.ordinal()]) && YogaMath.FloatsEqual(childHeight, child._layout.MeasuredDimensions[YogaDimension.Height.ordinal()])) continue block18;
                                child.LayoutNode(childWidth, childHeight, direction, YogaMeasureMode.Exactly, YogaMeasureMode.Exactly, availableInnerWidth, availableInnerHeight, true, "multiline-stretch", config);
                                continue block18;
                            }
                            case Baseline: {
                                child.SetLayoutPosition(currentLead + maxAscentForCurrentLine - YogaNode.CalculateBaseline(child) + child.GetLeadingPosition(YogaFlexDirection.Column, availableInnerCrossDim), YogaEdge.Top);
                                continue block18;
                            }
                        }
                    }
                }
                currentLead += lineHeight;
            }
        }
        this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Row, availableWidth - marginAxisRow, ownerWidth, ownerWidth), YogaDimension.Width);
        this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Column, availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YogaDimension.Height);
        if (measureModeMainDim == YogaMeasureMode.Undefined || this._style.Overflow != YogaOverflow.Scroll && measureModeMainDim == YogaMeasureMode.AtMost) {
            this.SetLayoutMeasuredDimension(this.BoundAxis(mainAxis, maxLineMainDim, mainAxisOwnerSize, ownerWidth), Dimension[mainAxis.ordinal()]);
        } else if (measureModeMainDim == YogaMeasureMode.AtMost && this._style.Overflow == YogaOverflow.Scroll) {
            this.SetLayoutMeasuredDimension(YogaMath.Max(YogaMath.Min(availableInnerMainDim + paddingAndBorderAxisMain, this.BoundAxisWithinMinAndMax(mainAxis, maxLineMainDim, mainAxisOwnerSize)), paddingAndBorderAxisMain), Dimension[mainAxis.ordinal()]);
        }
        if (measureModeCrossDim == YogaMeasureMode.Undefined || this._style.Overflow != YogaOverflow.Scroll && measureModeCrossDim == YogaMeasureMode.AtMost) {
            this.SetLayoutMeasuredDimension(this.BoundAxis(crossAxis, totalLineCrossDim + paddingAndBorderAxisCross, crossAxisOwnerSize, ownerWidth), Dimension[crossAxis.ordinal()]);
        } else if (measureModeCrossDim == YogaMeasureMode.AtMost && this._style.Overflow == YogaOverflow.Scroll) {
            this.SetLayoutMeasuredDimension(YogaMath.Max(YogaMath.Min(availableInnerCrossDim + paddingAndBorderAxisCross, this.BoundAxisWithinMinAndMax(crossAxis, totalLineCrossDim + paddingAndBorderAxisCross, crossAxisOwnerSize)), paddingAndBorderAxisCross), Dimension[crossAxis.ordinal()]);
        }
        if (performLayout && this._style.FlexWrap == YogaWrap.WrapReverse) {
            for (int i = 0; i < childCount; ++i) {
                YogaNode child = this.GetChild(i);
                if (child._style.PositionType != YogaPositionType.Relative) continue;
                child.SetLayoutPosition(this._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()] - child._layout.Position[Position[crossAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()], Position[crossAxis.ordinal()]);
            }
        }
        if (performLayout) {
            boolean needsCrossTrailingPos;
            for (YogaNode child : this._children) {
                if (child._style.PositionType != YogaPositionType.Absolute) continue;
                this.AbsoluteLayoutChild(child, availableInnerWidth, isMainAxisRow ? measureModeMainDim : measureModeCrossDim, availableInnerHeight, direction, config);
            }
            boolean needsMainTrailingPos = mainAxis == YogaFlexDirection.RowReverse || mainAxis == YogaFlexDirection.ColumnReverse;
            boolean bl3 = needsCrossTrailingPos = crossAxis == YogaFlexDirection.RowReverse || crossAxis == YogaFlexDirection.ColumnReverse;
            if (needsMainTrailingPos || needsCrossTrailingPos) {
                for (int i = 0; i < childCount; ++i) {
                    YogaNode child = this.GetChild(i);
                    if (child._style.Display == YogaDisplay.None) continue;
                    if (needsMainTrailingPos) {
                        this.SetChildTrailingPosition(child, mainAxis);
                    }
                    if (!needsCrossTrailingPos) continue;
                    this.SetChildTrailingPosition(child, crossAxis);
                }
            }
        }
    }

    private void WithMeasureFuncSetMeasuredDimensions(float availableWidth, float availableHeight, YogaMeasureMode widthMeasureMode, YogaMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight) {
        float innerHeight;
        if (this._measure == null) {
            throw new UnsupportedOperationException("Measure must not be null");
        }
        float paddingAndBorderAxisRow = this.GetPaddingAndBorderForAxis(YogaFlexDirection.Row, availableWidth);
        float paddingAndBorderAxisColumn = this.GetPaddingAndBorderForAxis(YogaFlexDirection.Column, availableWidth);
        float marginAxisRow = this.GetMarginForAxis(YogaFlexDirection.Row, availableWidth);
        float marginAxisColumn = this.GetMarginForAxis(YogaFlexDirection.Column, availableWidth);
        float innerWidth = Float.isNaN(availableWidth) ? availableWidth : YogaMath.Max(0.0f, availableWidth - marginAxisRow - paddingAndBorderAxisRow);
        float f = innerHeight = Float.isNaN(availableHeight) ? availableHeight : YogaMath.Max(0.0f, availableHeight - marginAxisColumn - paddingAndBorderAxisColumn);
        if (widthMeasureMode == YogaMeasureMode.Exactly && heightMeasureMode == YogaMeasureMode.Exactly) {
            this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Row, availableWidth - marginAxisRow, ownerWidth, ownerWidth), YogaDimension.Width);
            this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Column, availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YogaDimension.Height);
        } else {
            YogaSize measuredSize = this._measure.apply(this, innerWidth, widthMeasureMode, innerHeight, heightMeasureMode);
            this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Row, widthMeasureMode == YogaMeasureMode.Undefined || widthMeasureMode == YogaMeasureMode.AtMost ? measuredSize.Width + paddingAndBorderAxisRow : availableWidth - marginAxisRow, ownerWidth, ownerWidth), YogaDimension.Width);
            this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Column, heightMeasureMode == YogaMeasureMode.Undefined || heightMeasureMode == YogaMeasureMode.AtMost ? measuredSize.Height + paddingAndBorderAxisColumn : availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YogaDimension.Height);
        }
    }

    private void EmptyContainerSetMeasuredDimensions(float availableWidth, float availableHeight, YogaMeasureMode widthMeasureMode, YogaMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight) {
        float paddingAndBorderAxisRow = this.GetPaddingAndBorderForAxis(YogaFlexDirection.Row, ownerWidth);
        float paddingAndBorderAxisColumn = this.GetPaddingAndBorderForAxis(YogaFlexDirection.Column, ownerWidth);
        float marginAxisRow = this.GetMarginForAxis(YogaFlexDirection.Row, ownerWidth);
        float marginAxisColumn = this.GetMarginForAxis(YogaFlexDirection.Column, ownerWidth);
        this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Row, widthMeasureMode == YogaMeasureMode.Undefined || widthMeasureMode == YogaMeasureMode.AtMost ? paddingAndBorderAxisRow : availableWidth - marginAxisRow, ownerWidth, ownerWidth), YogaDimension.Width);
        this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Column, heightMeasureMode == YogaMeasureMode.Undefined || heightMeasureMode == YogaMeasureMode.AtMost ? paddingAndBorderAxisColumn : availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YogaDimension.Height);
    }

    private boolean FixedSizeSetMeasuredDimensions(float availableWidth, float availableHeight, YogaMeasureMode widthMeasureMode, YogaMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight) {
        if (!Float.isNaN(availableWidth) && widthMeasureMode == YogaMeasureMode.AtMost && availableWidth <= 0.0f || !Float.isNaN(availableHeight) && heightMeasureMode == YogaMeasureMode.AtMost && availableHeight <= 0.0f || widthMeasureMode == YogaMeasureMode.Exactly && heightMeasureMode == YogaMeasureMode.Exactly) {
            float marginAxisColumn = this.GetMarginForAxis(YogaFlexDirection.Column, ownerWidth);
            float marginAxisRow = this.GetMarginForAxis(YogaFlexDirection.Row, ownerWidth);
            this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Row, Float.isNaN(availableWidth) || widthMeasureMode == YogaMeasureMode.AtMost && availableWidth < 0.0f ? 0.0f : availableWidth - marginAxisRow, ownerWidth, ownerWidth), YogaDimension.Width);
            this.SetLayoutMeasuredDimension(this.BoundAxis(YogaFlexDirection.Column, Float.isNaN(availableHeight) || heightMeasureMode == YogaMeasureMode.AtMost && availableHeight < 0.0f ? 0.0f : availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YogaDimension.Height);
            return true;
        }
        return false;
    }

    private void ZeroOutLayoutRecursively() {
        this._layout.Clear();
        this._hasNewLayout = true;
        this.CloneChildrenIfNeeded();
        int childCount = this.GetChildCount();
        for (int i = 0; i < childCount; ++i) {
            YogaNode child = this.GetChild(i);
            child.ZeroOutLayoutRecursively();
        }
    }

    private float CalculateAvailableInnerDim(YogaFlexDirection axis, float availableDim, float ownerDim) {
        float paddingAndBorder;
        YogaFlexDirection direction = axis.IsRow() ? YogaFlexDirection.Row : YogaFlexDirection.Column;
        YogaDimension dimension = axis.IsRow() ? YogaDimension.Width : YogaDimension.Height;
        float margin = this.GetMarginForAxis(direction, ownerDim);
        float availableInnerDim = availableDim - margin - (paddingAndBorder = this.GetPaddingAndBorderForAxis(direction, ownerDim));
        if (!Float.isNaN(availableInnerDim)) {
            float minInnerResolved = this._style.MinDimensions[dimension.ordinal()].Resolve(ownerDim);
            float minInnerDim = Float.isNaN(minInnerResolved) ? 0.0f : minInnerResolved - paddingAndBorder;
            float maxInnerResolved = this._style.MaxDimensions[dimension.ordinal()].Resolve(ownerDim);
            float maxInnerDim = Float.isNaN(maxInnerResolved) ? Float.MAX_VALUE : maxInnerResolved - paddingAndBorder;
            availableInnerDim = YogaMath.Max(YogaMath.Min(availableInnerDim, maxInnerDim), minInnerDim);
        }
        return availableInnerDim;
    }

    private float ComputeFlexBasisForChildren(float availableInnerWidth, float availableInnerHeight, YogaMeasureMode widthMeasureMode, YogaMeasureMode heightMeasureMode, YogaDirection direction, YogaFlexDirection mainAxis, YogaConfig config, boolean performLayout, float totalOuterFlexBasis) {
        YogaMeasureMode measureModeMainDim;
        YogaNode singleFlexChild = null;
        List<YogaNode> children = this._children;
        YogaMeasureMode yogaMeasureMode = measureModeMainDim = mainAxis.IsRow() ? widthMeasureMode : heightMeasureMode;
        if (measureModeMainDim == YogaMeasureMode.Exactly) {
            for (YogaNode child : children) {
                if (!child.IsNodeFlexible()) continue;
                if (singleFlexChild != null || YogaMath.FloatsEqual(child.ResolveFlexGrow(), 0.0f) || YogaMath.FloatsEqual(child.ResolveFlexShrink(), 0.0f)) {
                    singleFlexChild = null;
                    break;
                }
                singleFlexChild = child;
            }
        }
        for (YogaNode child : children) {
            child.ResolveDimension();
            if (child._style.Display == YogaDisplay.None) {
                child.ZeroOutLayoutRecursively();
                child._hasNewLayout = true;
                child._isDirty = false;
                continue;
            }
            if (performLayout) {
                YogaDirection childDirection = child.ResolveDirection(direction);
                float mainDim = mainAxis.IsRow() ? availableInnerWidth : availableInnerHeight;
                float crossDim = mainAxis.IsRow() ? availableInnerHeight : availableInnerWidth;
                child.SetPosition(childDirection, mainDim, crossDim, availableInnerWidth);
            }
            if (child._style.PositionType == YogaPositionType.Absolute) continue;
            if (child == singleFlexChild) {
                child._layout.ComputedFlexBasisGeneration = gCurrentGenerationCount;
                child._layout.ComputedFlexBasis = 0.0f;
            } else {
                this.ComputeFlexBasisForChild(child, availableInnerWidth, widthMeasureMode, availableInnerHeight, availableInnerWidth, availableInnerHeight, heightMeasureMode, direction, config);
            }
            totalOuterFlexBasis += child._layout.ComputedFlexBasis + child.GetMarginForAxis(mainAxis, availableInnerWidth);
        }
        return totalOuterFlexBasis;
    }

    private float BoundAxisWithinMinAndMax(YogaFlexDirection axis, float value, float axisSize) {
        float min = Float.NaN;
        float max = Float.NaN;
        if (axis.IsColumn()) {
            min = this._style.MinDimensions[YogaDimension.Height.ordinal()].Resolve(axisSize);
            max = this._style.MaxDimensions[YogaDimension.Height.ordinal()].Resolve(axisSize);
        } else if (axis.IsRow()) {
            min = this._style.MinDimensions[YogaDimension.Width.ordinal()].Resolve(axisSize);
            max = this._style.MaxDimensions[YogaDimension.Width.ordinal()].Resolve(axisSize);
        }
        float boundValue = value;
        if (!Float.isNaN(max) && max >= 0.0f && boundValue > max) {
            boundValue = max;
        }
        if (!Float.isNaN(min) && min >= 0.0f && boundValue < min) {
            boundValue = min;
        }
        return boundValue;
    }

    private float BoundAxis(YogaFlexDirection axis, float value, float axisSize, float widthSize) {
        return YogaMath.Max(this.BoundAxisWithinMinAndMax(axis, value, axisSize), this.GetPaddingAndBorderForAxis(axis, widthSize));
    }

    private void ConstrainMaxSizeForMode(YogaFlexDirection axis, float ownerAxisSize, float ownerWidth, AtomicReference<YogaMeasureMode> mode, AtomicReference<Float> size) {
        float maxSize = this._style.MaxDimensions[Dimension[axis.ordinal()].ordinal()].Resolve(ownerAxisSize) + this.GetMarginForAxis(axis, ownerWidth);
        switch (mode.get()) {
            case Exactly: 
            case AtMost: {
                float sizeIn = size.get().floatValue();
                size.set(Float.valueOf(Float.isNaN(maxSize) || sizeIn < maxSize ? sizeIn : maxSize));
                break;
            }
            case Undefined: {
                if (Float.isNaN(maxSize)) break;
                mode.set(YogaMeasureMode.AtMost);
                size.set(Float.valueOf(maxSize));
            }
        }
    }

    private void ComputeFlexBasisForChild(YogaNode child, float width, YogaMeasureMode widthMode, float height, float ownerWidth, float ownerHeight, YogaMeasureMode heightMode, YogaDirection direction, YogaConfig config) {
        YogaFlexDirection mainAxis = this._style.FlexDirection.ResolveFlexDirection(direction);
        boolean isMainAxisRow = mainAxis.IsRow();
        float mainAxisSize = isMainAxisRow ? width : height;
        float mainAxisOwnerSize = isMainAxisRow ? ownerWidth : ownerHeight;
        float childWidth = Float.NaN;
        float childHeight = Float.NaN;
        float resolvedFlexBasis = child.ResolveFlexBasis().Resolve(mainAxisOwnerSize);
        boolean isRowStyleDimDefined = child.IsStyleDimensionDefined(YogaFlexDirection.Row, ownerWidth);
        boolean isColumnStyleDimDefined = child.IsStyleDimensionDefined(YogaFlexDirection.Column, ownerHeight);
        if (!Float.isNaN(resolvedFlexBasis) && !Float.isNaN(mainAxisSize)) {
            if (Float.isNaN(child._layout.ComputedFlexBasis) || child._config.IsExperimentalFeatureEnabled(YogaExperimentalFeature.WebFlexBasis) && child._layout.ComputedFlexBasisGeneration != gCurrentGenerationCount) {
                float paddingAndBorder = child.GetPaddingAndBorderForAxis(mainAxis, ownerWidth);
                child._layout.ComputedFlexBasis = YogaMath.Max(resolvedFlexBasis, paddingAndBorder);
            }
        } else if (isMainAxisRow && isRowStyleDimDefined) {
            child._layout.ComputedFlexBasis = YogaMath.Max(child.GetResolvedDimension(YogaDimension.Width).Resolve(ownerWidth), child.GetPaddingAndBorderForAxis(YogaFlexDirection.Row, ownerWidth));
        } else if (!isMainAxisRow && isColumnStyleDimDefined) {
            child._layout.ComputedFlexBasis = YogaMath.Max(child.GetResolvedDimension(YogaDimension.Height).Resolve(ownerHeight), child.GetPaddingAndBorderForAxis(YogaFlexDirection.Column, ownerWidth));
        } else {
            boolean childHeightStretch;
            boolean childWidthStretch;
            childWidth = Float.NaN;
            childHeight = Float.NaN;
            YogaMeasureMode childWidthMeasureMode = YogaMeasureMode.Undefined;
            YogaMeasureMode childHeightMeasureMode = YogaMeasureMode.Undefined;
            float marginRow = child.GetMarginForAxis(YogaFlexDirection.Row, ownerWidth);
            float marginColumn = child.GetMarginForAxis(YogaFlexDirection.Column, ownerWidth);
            if (isRowStyleDimDefined) {
                childWidth = child.GetResolvedDimension(YogaDimension.Width).Resolve(ownerWidth) + marginRow;
                childWidthMeasureMode = YogaMeasureMode.Exactly;
            }
            if (isColumnStyleDimDefined) {
                childHeight = child.GetResolvedDimension(YogaDimension.Height).Resolve(ownerHeight) + marginColumn;
                childHeightMeasureMode = YogaMeasureMode.Exactly;
            }
            if ((!isMainAxisRow && this._style.Overflow == YogaOverflow.Scroll || this._style.Overflow != YogaOverflow.Scroll) && Float.isNaN(childWidth) && !Float.isNaN(width)) {
                childWidth = width;
                childWidthMeasureMode = YogaMeasureMode.AtMost;
            }
            if ((isMainAxisRow && this._style.Overflow == YogaOverflow.Scroll || this._style.Overflow != YogaOverflow.Scroll) && Float.isNaN(childHeight) && !Float.isNaN(height)) {
                childHeight = height;
                childHeightMeasureMode = YogaMeasureMode.AtMost;
            }
            if (!Float.isNaN(child._style.AspectRatio)) {
                if (!isMainAxisRow && childWidthMeasureMode == YogaMeasureMode.Exactly) {
                    childHeight = marginColumn + (childWidth - marginRow) / child._style.AspectRatio;
                    childHeightMeasureMode = YogaMeasureMode.Exactly;
                } else if (isMainAxisRow && childHeightMeasureMode == YogaMeasureMode.Exactly) {
                    childWidth = marginRow + (childHeight - marginColumn) * child._style.AspectRatio;
                    childWidthMeasureMode = YogaMeasureMode.Exactly;
                }
            }
            boolean hasExactWidth = !Float.isNaN(width) && widthMode == YogaMeasureMode.Exactly;
            boolean bl = childWidthStretch = this.GetAlign(child) == YogaAlign.Stretch && childWidthMeasureMode != YogaMeasureMode.Exactly;
            if (!isMainAxisRow && !isRowStyleDimDefined && hasExactWidth && childWidthStretch) {
                childWidth = width;
                childWidthMeasureMode = YogaMeasureMode.Exactly;
                if (!Float.isNaN(child._style.AspectRatio)) {
                    childHeight = (childWidth - marginRow) / child._style.AspectRatio;
                    childHeightMeasureMode = YogaMeasureMode.Exactly;
                }
            }
            boolean hasExactHeight = !Float.isNaN(height) && heightMode == YogaMeasureMode.Exactly;
            boolean bl2 = childHeightStretch = this.GetAlign(child) == YogaAlign.Stretch && childHeightMeasureMode != YogaMeasureMode.Exactly;
            if (isMainAxisRow && !isColumnStyleDimDefined && hasExactHeight && childHeightStretch) {
                childHeight = height;
                childHeightMeasureMode = YogaMeasureMode.Exactly;
                if (!Float.isNaN(child._style.AspectRatio)) {
                    childWidth = (childHeight - marginColumn) * child._style.AspectRatio;
                    childWidthMeasureMode = YogaMeasureMode.Exactly;
                }
            }
            AtomicReference<YogaMeasureMode> childWidthMeasureModeRef = new AtomicReference<YogaMeasureMode>(childWidthMeasureMode);
            AtomicReference<YogaMeasureMode> childHeightMeasureModeRef = new AtomicReference<YogaMeasureMode>(childHeightMeasureMode);
            AtomicReference<Float> childWidthRef = new AtomicReference<Float>(Float.valueOf(childWidth));
            AtomicReference<Float> childHeightRef = new AtomicReference<Float>(Float.valueOf(childHeight));
            child.ConstrainMaxSizeForMode(YogaFlexDirection.Row, ownerWidth, ownerWidth, childWidthMeasureModeRef, childWidthRef);
            child.ConstrainMaxSizeForMode(YogaFlexDirection.Column, ownerHeight, ownerWidth, childHeightMeasureModeRef, childHeightRef);
            childWidthMeasureMode = childWidthMeasureModeRef.get();
            childHeightMeasureMode = childHeightMeasureModeRef.get();
            childWidth = childWidthRef.get().floatValue();
            childHeight = childHeightRef.get().floatValue();
            child.LayoutNode(childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, ownerWidth, ownerHeight, false, "measure", config);
            child._layout.ComputedFlexBasis = YogaMath.Max(child._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()], child.GetPaddingAndBorderForAxis(mainAxis, ownerWidth));
        }
        child._layout.ComputedFlexBasisGeneration = gCurrentGenerationCount;
    }

    private static float CalculateBaseline(YogaNode node) {
        float baseline = Float.NaN;
        if (node._baseline != null) {
            baseline = node._baseline.apply(node, node._layout.MeasuredDimensions[YogaDimension.Width.ordinal()], node._layout.MeasuredDimensions[YogaDimension.Height.ordinal()]);
            return baseline;
        }
        YogaNode baselineChild = null;
        int childCount = node.GetChildCount();
        for (int i = 0; i < childCount; ++i) {
            YogaNode child = node.GetChild(i);
            if (child._lineIndex > 0) break;
            if (child._style.PositionType == YogaPositionType.Absolute) continue;
            if (node.GetAlign(child) == YogaAlign.Baseline || child.GetIsReferenceBaseline()) {
                baselineChild = child;
                break;
            }
            if (baselineChild != null) continue;
            baselineChild = child;
        }
        if (baselineChild == null) {
            return node._layout.MeasuredDimensions[YogaDimension.Height.ordinal()];
        }
        baseline = YogaNode.CalculateBaseline(baselineChild);
        return baseline + baselineChild._layout.Position[YogaEdge.Top.ordinal()];
    }

    private YogaCollectFlexItemsRowValues CalculateCollectFlexItemsRowValues(YogaDirection ownerDirection, float mainAxisOwnerSize, float availableInnerWidth, float availableInnerMainDim, int startOfLineIndex, int lineCount) {
        int endOfLineIndex;
        YogaCollectFlexItemsRowValues flexAlgoRowMeasurement = new YogaCollectFlexItemsRowValues();
        float sizeConsumedOnCurrentLineIncludingMinConstraint = 0.0f;
        YogaFlexDirection mainAxis = this._style.FlexDirection.ResolveFlexDirection(this.ResolveDirection(ownerDirection));
        boolean isNodeFlexWrap = this._style.FlexWrap != YogaWrap.NoWrap;
        for (endOfLineIndex = startOfLineIndex; endOfLineIndex < this.GetChildCount(); ++endOfLineIndex) {
            YogaNode child = this.GetChild(endOfLineIndex);
            if (child._style.Display == YogaDisplay.None || child._style.PositionType == YogaPositionType.Absolute) continue;
            child._lineIndex = lineCount;
            float childMarginMainAxis = child.GetMarginForAxis(mainAxis, availableInnerWidth);
            float flexBasisWithMinAndMaxConstraints = child.BoundAxisWithinMinAndMax(mainAxis, child._layout.ComputedFlexBasis, mainAxisOwnerSize);
            if (sizeConsumedOnCurrentLineIncludingMinConstraint + flexBasisWithMinAndMaxConstraints + childMarginMainAxis > availableInnerMainDim && isNodeFlexWrap && flexAlgoRowMeasurement.ItemsOnLine > 0) break;
            sizeConsumedOnCurrentLineIncludingMinConstraint += flexBasisWithMinAndMaxConstraints + childMarginMainAxis;
            flexAlgoRowMeasurement.SizeConsumedOnCurrentLine += flexBasisWithMinAndMaxConstraints + childMarginMainAxis;
            ++flexAlgoRowMeasurement.ItemsOnLine;
            if (child.IsNodeFlexible()) {
                flexAlgoRowMeasurement.TotalFlexGrowFactors += child.ResolveFlexGrow();
                flexAlgoRowMeasurement.TotalFlexShrinkScaledFactors += -child.ResolveFlexShrink() * child._layout.ComputedFlexBasis;
            }
            flexAlgoRowMeasurement.RelativeChildren.add(child);
        }
        if (flexAlgoRowMeasurement.TotalFlexGrowFactors > 0.0f && flexAlgoRowMeasurement.TotalFlexGrowFactors < 1.0f) {
            flexAlgoRowMeasurement.TotalFlexGrowFactors = 1.0f;
        }
        if (flexAlgoRowMeasurement.TotalFlexShrinkScaledFactors > 0.0f && flexAlgoRowMeasurement.TotalFlexShrinkScaledFactors < 1.0f) {
            flexAlgoRowMeasurement.TotalFlexShrinkScaledFactors = 1.0f;
        }
        flexAlgoRowMeasurement.EndOfLineIndex = endOfLineIndex;
        return flexAlgoRowMeasurement;
    }

    private YogaCollectFlexItemsRowValues ResolveFlexibleLength(YogaCollectFlexItemsRowValues collectedFlexItemsValues, YogaFlexDirection mainAxis, YogaFlexDirection crossAxis, float mainAxisOwnerSize, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, float availableInnerHeight, boolean flexBasisOverflows, YogaMeasureMode measureModeCrossDim, boolean performLayout, YogaConfig config) {
        float originalFreeSpace = collectedFlexItemsValues.RemainingFreeSpace;
        collectedFlexItemsValues = YogaNode.DistributeFreeSpaceFirstPass(collectedFlexItemsValues, mainAxis, mainAxisOwnerSize, availableInnerMainDim, availableInnerWidth);
        float distributedFreeSpace = this.DistributeFreeSpaceSecondPass(collectedFlexItemsValues, mainAxis, crossAxis, mainAxisOwnerSize, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, availableInnerHeight, flexBasisOverflows, measureModeCrossDim, performLayout, config);
        collectedFlexItemsValues.RemainingFreeSpace = originalFreeSpace - distributedFreeSpace;
        return collectedFlexItemsValues;
    }

    private static YogaCollectFlexItemsRowValues DistributeFreeSpaceFirstPass(YogaCollectFlexItemsRowValues collectedFlexItemsValues, YogaFlexDirection mainAxis, float mainAxisOwnerSize, float availableInnerMainDim, float availableInnerWidth) {
        float flexShrinkScaledFactor = 0.0f;
        float flexGrowFactor = 0.0f;
        float baseMainSize = 0.0f;
        float boundMainSize = 0.0f;
        float deltaFreeSpace = 0.0f;
        for (YogaNode currentRelativeChild : collectedFlexItemsValues.RelativeChildren) {
            float childFlexBasis = currentRelativeChild.BoundAxisWithinMinAndMax(mainAxis, currentRelativeChild._layout.ComputedFlexBasis, mainAxisOwnerSize);
            if (collectedFlexItemsValues.RemainingFreeSpace < 0.0f) {
                flexShrinkScaledFactor = -currentRelativeChild.ResolveFlexShrink() * childFlexBasis;
                if (Float.isNaN(flexShrinkScaledFactor) || flexShrinkScaledFactor == 0.0f) continue;
                baseMainSize = childFlexBasis + collectedFlexItemsValues.RemainingFreeSpace / collectedFlexItemsValues.TotalFlexShrinkScaledFactors * flexShrinkScaledFactor;
                boundMainSize = currentRelativeChild.BoundAxis(mainAxis, baseMainSize, availableInnerMainDim, availableInnerWidth);
                if (Float.isNaN(baseMainSize) || Float.isNaN(boundMainSize) || baseMainSize == boundMainSize) continue;
                deltaFreeSpace += boundMainSize - childFlexBasis;
                collectedFlexItemsValues.TotalFlexShrinkScaledFactors -= flexShrinkScaledFactor;
                continue;
            }
            if (Float.isNaN(collectedFlexItemsValues.RemainingFreeSpace) || !(collectedFlexItemsValues.RemainingFreeSpace > 0.0f) || (flexGrowFactor = currentRelativeChild.ResolveFlexGrow()) == 0.0f) continue;
            baseMainSize = childFlexBasis + collectedFlexItemsValues.RemainingFreeSpace / collectedFlexItemsValues.TotalFlexGrowFactors * flexGrowFactor;
            boundMainSize = currentRelativeChild.BoundAxis(mainAxis, baseMainSize, availableInnerMainDim, availableInnerWidth);
            if (Float.isNaN(baseMainSize) || Float.isNaN(boundMainSize) || baseMainSize == boundMainSize) continue;
            deltaFreeSpace += boundMainSize - childFlexBasis;
            collectedFlexItemsValues.TotalFlexGrowFactors -= flexGrowFactor;
        }
        collectedFlexItemsValues.RemainingFreeSpace -= deltaFreeSpace;
        return collectedFlexItemsValues;
    }

    private float DistributeFreeSpaceSecondPass(YogaCollectFlexItemsRowValues collectedFlexItemsValues, YogaFlexDirection mainAxis, YogaFlexDirection crossAxis, float mainAxisOwnerSize, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, float availableInnerHeight, boolean flexBasisOverflows, YogaMeasureMode measureModeCrossDim, boolean performLayout, YogaConfig config) {
        float childFlexBasis = 0.0f;
        float flexShrinkScaledFactor = 0.0f;
        float flexGrowFactor = 0.0f;
        float deltaFreeSpace = 0.0f;
        boolean isMainAxisRow = mainAxis.IsRow();
        boolean isNodeFlexWrap = this._style.FlexWrap != YogaWrap.NoWrap;
        for (YogaNode currentRelativeChild : collectedFlexItemsValues.RelativeChildren) {
            YogaMeasureMode childCrossMeasureMode;
            float updatedMainSize = childFlexBasis = currentRelativeChild.BoundAxisWithinMinAndMax(mainAxis, currentRelativeChild._layout.ComputedFlexBasis, mainAxisOwnerSize);
            if (!Float.isNaN(collectedFlexItemsValues.RemainingFreeSpace) && collectedFlexItemsValues.RemainingFreeSpace < 0.0f) {
                flexShrinkScaledFactor = -currentRelativeChild.ResolveFlexShrink() * childFlexBasis;
                if (flexShrinkScaledFactor != 0.0f) {
                    float childSize = 0.0f;
                    childSize = !Float.isNaN(collectedFlexItemsValues.TotalFlexShrinkScaledFactors) && collectedFlexItemsValues.TotalFlexShrinkScaledFactors == 0.0f ? childFlexBasis + flexShrinkScaledFactor : childFlexBasis + collectedFlexItemsValues.RemainingFreeSpace / collectedFlexItemsValues.TotalFlexShrinkScaledFactors * flexShrinkScaledFactor;
                    updatedMainSize = currentRelativeChild.BoundAxis(mainAxis, childSize, availableInnerMainDim, availableInnerWidth);
                }
            } else if (!Float.isNaN(collectedFlexItemsValues.RemainingFreeSpace) && collectedFlexItemsValues.RemainingFreeSpace > 0.0f && (flexGrowFactor = currentRelativeChild.ResolveFlexGrow()) != 0.0f) {
                updatedMainSize = currentRelativeChild.BoundAxis(mainAxis, childFlexBasis + collectedFlexItemsValues.RemainingFreeSpace / collectedFlexItemsValues.TotalFlexGrowFactors * flexGrowFactor, availableInnerMainDim, availableInnerWidth);
            }
            deltaFreeSpace += updatedMainSize - childFlexBasis;
            float marginMain = currentRelativeChild.GetMarginForAxis(mainAxis, availableInnerWidth);
            float marginCross = currentRelativeChild.GetMarginForAxis(crossAxis, availableInnerWidth);
            float childCrossSize = Float.NaN;
            float childMainSize = updatedMainSize + marginMain;
            YogaMeasureMode childMainMeasureMode = YogaMeasureMode.Exactly;
            if (!Float.isNaN(currentRelativeChild._style.AspectRatio)) {
                childCrossSize = isMainAxisRow ? (childMainSize - marginMain) / currentRelativeChild._style.AspectRatio : (childMainSize - marginMain) * currentRelativeChild._style.AspectRatio;
                childCrossMeasureMode = YogaMeasureMode.Exactly;
                childCrossSize += marginCross;
            } else if (!(Float.isNaN(availableInnerCrossDim) || currentRelativeChild.IsStyleDimensionDefined(crossAxis, availableInnerCrossDim) || measureModeCrossDim != YogaMeasureMode.Exactly || isNodeFlexWrap && flexBasisOverflows || this.GetAlign(currentRelativeChild) != YogaAlign.Stretch || currentRelativeChild.GetMarginLeadingValue((YogaFlexDirection)crossAxis).Unit == YogaUnit.Auto || currentRelativeChild.GetMarginTrailingValue((YogaFlexDirection)crossAxis).Unit == YogaUnit.Auto)) {
                childCrossSize = availableInnerCrossDim;
                childCrossMeasureMode = YogaMeasureMode.Exactly;
            } else if (!currentRelativeChild.IsStyleDimensionDefined(crossAxis, availableInnerCrossDim)) {
                childCrossSize = availableInnerCrossDim;
                childCrossMeasureMode = Float.isNaN(childCrossSize) ? YogaMeasureMode.Undefined : YogaMeasureMode.AtMost;
            } else {
                childCrossSize = currentRelativeChild.GetResolvedDimension(Dimension[crossAxis.ordinal()]).Resolve(availableInnerCrossDim) + marginCross;
                boolean isLoosePercentageMeasurement = currentRelativeChild.GetResolvedDimension((YogaDimension)YogaNode.Dimension[crossAxis.ordinal()]).Unit == YogaUnit.Percent && measureModeCrossDim != YogaMeasureMode.Exactly;
                childCrossMeasureMode = Float.isNaN(childCrossSize) || isLoosePercentageMeasurement ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
            }
            AtomicReference<YogaMeasureMode> childMainMeasureModeRef = new AtomicReference<YogaMeasureMode>(childMainMeasureMode);
            AtomicReference<YogaMeasureMode> childCrossMeasureModeRef = new AtomicReference<YogaMeasureMode>(childCrossMeasureMode);
            AtomicReference<Float> childMainSizeRef = new AtomicReference<Float>(Float.valueOf(childMainSize));
            AtomicReference<Float> childCrossSizeRef = new AtomicReference<Float>(Float.valueOf(childCrossSize));
            currentRelativeChild.ConstrainMaxSizeForMode(mainAxis, availableInnerMainDim, availableInnerWidth, childMainMeasureModeRef, childMainSizeRef);
            currentRelativeChild.ConstrainMaxSizeForMode(crossAxis, availableInnerCrossDim, availableInnerWidth, childCrossMeasureModeRef, childCrossSizeRef);
            childMainMeasureMode = childMainMeasureModeRef.get();
            childCrossMeasureMode = childCrossMeasureModeRef.get();
            childMainSize = childMainSizeRef.get().floatValue();
            childCrossSize = childCrossSizeRef.get().floatValue();
            boolean requiresStretchLayout = !currentRelativeChild.IsStyleDimensionDefined(crossAxis, availableInnerCrossDim) && this.GetAlign(currentRelativeChild) == YogaAlign.Stretch && currentRelativeChild.GetMarginLeadingValue((YogaFlexDirection)crossAxis).Unit != YogaUnit.Auto && currentRelativeChild.GetMarginTrailingValue((YogaFlexDirection)crossAxis).Unit != YogaUnit.Auto;
            float childWidth = isMainAxisRow ? childMainSize : childCrossSize;
            float childHeight = !isMainAxisRow ? childMainSize : childCrossSize;
            YogaMeasureMode childWidthMeasureMode = isMainAxisRow ? childMainMeasureMode : childCrossMeasureMode;
            YogaMeasureMode childHeightMeasureMode = !isMainAxisRow ? childMainMeasureMode : childCrossMeasureMode;
            currentRelativeChild.LayoutNode(childWidth, childHeight, this._layout.Direction, childWidthMeasureMode, childHeightMeasureMode, availableInnerWidth, availableInnerHeight, performLayout && !requiresStretchLayout, "flex", config);
            this._layout.HadOverflow = this._layout.HadOverflow || currentRelativeChild._layout.HadOverflow;
        }
        return deltaFreeSpace;
    }

    private JustifyMainAxisReturn JustifyMainAxis(YogaCollectFlexItemsRowValues collectedFlexItemsValues, int startOfLineIndex, YogaFlexDirection mainAxis, YogaFlexDirection crossAxis, YogaMeasureMode measureModeMainDim, YogaMeasureMode measureModeCrossDim, float mainAxisOwnerSize, float ownerWidth, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, boolean performLayout) {
        YogaStyle style = this._style;
        float leadingPaddingAndBorderMain = this.GetLeadingPaddingAndBorder(mainAxis, ownerWidth);
        float trailingPaddingAndBorderMain = this.GetTrailingPaddingAndBorder(mainAxis, ownerWidth);
        if (measureModeMainDim == YogaMeasureMode.AtMost && collectedFlexItemsValues.RemainingFreeSpace > 0.0f) {
            if (style.MinDimensions[YogaNode.Dimension[mainAxis.ordinal()].ordinal()].Unit != YogaUnit.Undefined && !Float.isNaN(style.MinDimensions[Dimension[mainAxis.ordinal()].ordinal()].Resolve(mainAxisOwnerSize))) {
                float minAvailableMainDim = style.MinDimensions[Dimension[mainAxis.ordinal()].ordinal()].Resolve(mainAxisOwnerSize) - leadingPaddingAndBorderMain - trailingPaddingAndBorderMain;
                float occupiedSpaceByChildNodes = availableInnerMainDim - collectedFlexItemsValues.RemainingFreeSpace;
                collectedFlexItemsValues.RemainingFreeSpace = YogaMath.Max(0.0f, minAvailableMainDim - occupiedSpaceByChildNodes);
            } else {
                collectedFlexItemsValues.RemainingFreeSpace = 0.0f;
            }
        }
        int numberOfAutoMarginsOnCurrentLine = 0;
        for (int i = startOfLineIndex; i < collectedFlexItemsValues.EndOfLineIndex; ++i) {
            YogaNode child = this.GetChild(i);
            if (child._style.PositionType != YogaPositionType.Relative) continue;
            if (child.GetMarginLeadingValue((YogaFlexDirection)mainAxis).Unit == YogaUnit.Auto) {
                ++numberOfAutoMarginsOnCurrentLine;
            }
            if (child.GetMarginTrailingValue((YogaFlexDirection)mainAxis).Unit != YogaUnit.Auto) continue;
            ++numberOfAutoMarginsOnCurrentLine;
        }
        float leadingMainDim = 0.0f;
        float betweenMainDim = 0.0f;
        YogaJustify justifyContent = this._style.JustifyContent;
        if (numberOfAutoMarginsOnCurrentLine == 0) {
            switch (justifyContent) {
                case Center: {
                    leadingMainDim = collectedFlexItemsValues.RemainingFreeSpace / 2.0f;
                    break;
                }
                case FlexEnd: {
                    leadingMainDim = collectedFlexItemsValues.RemainingFreeSpace;
                    break;
                }
                case SpaceBetween: {
                    if (collectedFlexItemsValues.ItemsOnLine > 1) {
                        betweenMainDim = YogaMath.Max(collectedFlexItemsValues.RemainingFreeSpace, 0.0f) / (float)(collectedFlexItemsValues.ItemsOnLine - 1);
                        break;
                    }
                    betweenMainDim = 0.0f;
                    break;
                }
                case SpaceEvenly: {
                    leadingMainDim = betweenMainDim = collectedFlexItemsValues.RemainingFreeSpace / (float)(collectedFlexItemsValues.ItemsOnLine + 1);
                    break;
                }
                case SpaceAround: {
                    betweenMainDim = collectedFlexItemsValues.RemainingFreeSpace / (float)collectedFlexItemsValues.ItemsOnLine;
                    leadingMainDim = betweenMainDim / 2.0f;
                    break;
                }
            }
        }
        collectedFlexItemsValues.MainDimension = leadingPaddingAndBorderMain + leadingMainDim;
        collectedFlexItemsValues.CrossDimension = 0.0f;
        float maxAscentForCurrentLine = 0.0f;
        float maxDescentForCurrentLine = 0.0f;
        boolean isNodeBaselineLayout = this.IsBaselineLayout();
        for (int i = startOfLineIndex; i < collectedFlexItemsValues.EndOfLineIndex; ++i) {
            YogaNode child = this.GetChild(i);
            YogaStyle childStyle = child._style;
            YogaLayout childLayout = child._layout;
            if (childStyle.Display == YogaDisplay.None) continue;
            if (childStyle.PositionType == YogaPositionType.Absolute && child.IsLeadingPositionDefined(mainAxis)) {
                if (!performLayout) continue;
                child.SetLayoutPosition(child.GetLeadingPosition(mainAxis, availableInnerMainDim) + this.GetLeadingBorder(mainAxis) + child.GetLeadingMargin(mainAxis, availableInnerWidth), Position[mainAxis.ordinal()]);
                continue;
            }
            if (childStyle.PositionType == YogaPositionType.Relative) {
                boolean canSkipFlex;
                if (child.GetMarginLeadingValue((YogaFlexDirection)mainAxis).Unit == YogaUnit.Auto) {
                    collectedFlexItemsValues.MainDimension += collectedFlexItemsValues.RemainingFreeSpace / (float)numberOfAutoMarginsOnCurrentLine;
                }
                if (performLayout) {
                    child.SetLayoutPosition(childLayout.Position[Position[mainAxis.ordinal()].ordinal()] + collectedFlexItemsValues.MainDimension, Position[mainAxis.ordinal()]);
                }
                if (child.GetMarginTrailingValue((YogaFlexDirection)mainAxis).Unit == YogaUnit.Auto) {
                    collectedFlexItemsValues.MainDimension += collectedFlexItemsValues.RemainingFreeSpace / (float)numberOfAutoMarginsOnCurrentLine;
                }
                boolean bl = canSkipFlex = !performLayout && measureModeCrossDim == YogaMeasureMode.Exactly;
                if (canSkipFlex) {
                    collectedFlexItemsValues.MainDimension += betweenMainDim + child.GetMarginForAxis(mainAxis, availableInnerWidth) + childLayout.ComputedFlexBasis;
                    collectedFlexItemsValues.CrossDimension = availableInnerCrossDim;
                    continue;
                }
                collectedFlexItemsValues.MainDimension += betweenMainDim + child.GetDimensionWithMargin(mainAxis, availableInnerWidth);
                if (isNodeBaselineLayout) {
                    float ascent = YogaNode.CalculateBaseline(child) + child.GetLeadingMargin(YogaFlexDirection.Column, availableInnerWidth);
                    float descent = child._layout.MeasuredDimensions[YogaDimension.Height.ordinal()] + child.GetMarginForAxis(YogaFlexDirection.Column, availableInnerWidth) - ascent;
                    maxAscentForCurrentLine = YogaMath.Max(maxAscentForCurrentLine, ascent);
                    maxDescentForCurrentLine = YogaMath.Max(maxDescentForCurrentLine, descent);
                    continue;
                }
                collectedFlexItemsValues.CrossDimension = YogaMath.Max(collectedFlexItemsValues.CrossDimension, child.GetDimensionWithMargin(crossAxis, availableInnerWidth));
                continue;
            }
            if (!performLayout) continue;
            child.SetLayoutPosition(childLayout.Position[Position[mainAxis.ordinal()].ordinal()] + this.GetLeadingBorder(mainAxis) + leadingMainDim, Position[mainAxis.ordinal()]);
        }
        collectedFlexItemsValues.MainDimension += trailingPaddingAndBorderMain;
        if (isNodeBaselineLayout) {
            collectedFlexItemsValues.CrossDimension = maxAscentForCurrentLine + maxDescentForCurrentLine;
        }
        JustifyMainAxisReturn ret = new JustifyMainAxisReturn();
        ret.collectedFlexItemsValues = collectedFlexItemsValues;
        ret.startOfLineIndex = startOfLineIndex;
        ret.mainAxis = mainAxis;
        ret.crossAxis = crossAxis;
        ret.measureModeMainDim = measureModeMainDim;
        ret.measureModeCrossDim = measureModeCrossDim;
        ret.mainAxisOwnerSize = mainAxisOwnerSize;
        ret.ownerWidth = ownerWidth;
        ret.availableInnerMainDim = availableInnerMainDim;
        ret.availableInnerCrossDim = availableInnerCrossDim;
        ret.availableInnerWidth = availableInnerWidth;
        ret.performLayout = performLayout;
        return ret;
    }

    private void AbsoluteLayoutChild(YogaNode child, float width, YogaMeasureMode widthMode, float height, YogaDirection direction, YogaConfig config) {
        YogaFlexDirection mainAxis = this._style.FlexDirection.ResolveFlexDirection(direction);
        YogaFlexDirection crossAxis = mainAxis.FlexDirectionCross(direction);
        boolean isMainAxisRow = mainAxis.IsRow();
        float childWidth = Float.NaN;
        float childHeight = Float.NaN;
        YogaMeasureMode childWidthMeasureMode = YogaMeasureMode.Undefined;
        YogaMeasureMode childHeightMeasureMode = YogaMeasureMode.Undefined;
        float marginRow = child.GetMarginForAxis(YogaFlexDirection.Row, width);
        float marginColumn = child.GetMarginForAxis(YogaFlexDirection.Column, width);
        if (child.IsStyleDimensionDefined(YogaFlexDirection.Row, width)) {
            childWidth = child.GetResolvedDimension(YogaDimension.Width).Resolve(width) + marginRow;
        } else if (child.IsLeadingPositionDefined(YogaFlexDirection.Row) && child.IsTrailingPositionDefined(YogaFlexDirection.Row)) {
            childWidth = this._layout.MeasuredDimensions[YogaDimension.Width.ordinal()] - (this.GetLeadingBorder(YogaFlexDirection.Row) + this.GetTrailingBorder(YogaFlexDirection.Row)) - (child.GetLeadingPosition(YogaFlexDirection.Row, width) + child.GetTrailingPosition(YogaFlexDirection.Row, width));
            childWidth = child.BoundAxis(YogaFlexDirection.Row, childWidth, width, width);
        }
        if (child.IsStyleDimensionDefined(YogaFlexDirection.Column, height)) {
            childHeight = child.GetResolvedDimension(YogaDimension.Height).Resolve(height) + marginColumn;
        } else if (child.IsLeadingPositionDefined(YogaFlexDirection.Column) && child.IsTrailingPositionDefined(YogaFlexDirection.Column)) {
            childHeight = this._layout.MeasuredDimensions[YogaDimension.Height.ordinal()] - (this.GetLeadingBorder(YogaFlexDirection.Column) + this.GetTrailingBorder(YogaFlexDirection.Column)) - (child.GetLeadingPosition(YogaFlexDirection.Column, height) + child.GetTrailingPosition(YogaFlexDirection.Column, height));
            childHeight = child.BoundAxis(YogaFlexDirection.Column, childHeight, height, width);
        }
        if (Float.isNaN(childWidth) ^ Float.isNaN(childHeight) && !Float.isNaN(child._style.AspectRatio)) {
            if (Float.isNaN(childWidth)) {
                childWidth = marginRow + (childHeight - marginColumn) * child._style.AspectRatio;
            } else if (Float.isNaN(childHeight)) {
                childHeight = marginColumn + (childWidth - marginRow) / child._style.AspectRatio;
            }
        }
        if (Float.isNaN(childWidth) || Float.isNaN(childHeight)) {
            childWidthMeasureMode = Float.isNaN(childWidth) ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
            YogaMeasureMode yogaMeasureMode = childHeightMeasureMode = Float.isNaN(childHeight) ? YogaMeasureMode.Undefined : YogaMeasureMode.Exactly;
            if (!isMainAxisRow && Float.isNaN(childWidth) && widthMode != YogaMeasureMode.Undefined && !Float.isNaN(width) && width > 0.0f) {
                childWidth = width;
                childWidthMeasureMode = YogaMeasureMode.AtMost;
            }
            child.LayoutNode(childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, childWidth, childHeight, false, "abs-measure", config);
            childWidth = child._layout.MeasuredDimensions[YogaDimension.Width.ordinal()] + child.GetMarginForAxis(YogaFlexDirection.Row, width);
            childHeight = child._layout.MeasuredDimensions[YogaDimension.Height.ordinal()] + child.GetMarginForAxis(YogaFlexDirection.Column, width);
        }
        child.LayoutNode(childWidth, childHeight, direction, YogaMeasureMode.Exactly, YogaMeasureMode.Exactly, childWidth, childHeight, true, "abs-layout", config);
        if (child.IsTrailingPositionDefined(mainAxis) && !child.IsLeadingPositionDefined(mainAxis)) {
            child.SetLayoutPosition(this._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()] - this.GetTrailingBorder(mainAxis) - child.GetTrailingMargin(mainAxis, width) - child.GetTrailingPosition(mainAxis, isMainAxisRow ? width : height), Leading[mainAxis.ordinal()]);
        } else if (!child.IsLeadingPositionDefined(mainAxis) && this._style.JustifyContent == YogaJustify.Center) {
            child.SetLayoutPosition((this._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()]) / 2.0f, Leading[mainAxis.ordinal()]);
        } else if (!child.IsLeadingPositionDefined(mainAxis) && this._style.JustifyContent == YogaJustify.FlexEnd) {
            child.SetLayoutPosition(this._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[mainAxis.ordinal()].ordinal()], Leading[mainAxis.ordinal()]);
        }
        if (child.IsTrailingPositionDefined(crossAxis) && !child.IsLeadingPositionDefined(crossAxis)) {
            child.SetLayoutPosition(this._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()] - this.GetTrailingBorder(crossAxis) - child.GetTrailingMargin(crossAxis, width) - child.GetTrailingPosition(crossAxis, isMainAxisRow ? height : width), Leading[crossAxis.ordinal()]);
        } else if (!child.IsLeadingPositionDefined(crossAxis) && this.GetAlign(child) == YogaAlign.Center) {
            child.SetLayoutPosition((this._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()]) / 2.0f, Leading[crossAxis.ordinal()]);
        } else if (!child.IsLeadingPositionDefined(crossAxis) && this.GetAlign(child) == YogaAlign.FlexEnd ^ this._style.FlexWrap == YogaWrap.WrapReverse) {
            child.SetLayoutPosition(this._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()] - child._layout.MeasuredDimensions[Dimension[crossAxis.ordinal()].ordinal()], Leading[crossAxis.ordinal()]);
        }
    }

    private float GetDimensionWithMargin(YogaFlexDirection axis, float widthSize) {
        return this._layout.MeasuredDimensions[Dimension[axis.ordinal()].ordinal()] + this.GetLeadingMargin(axis, widthSize) + this.GetTrailingMargin(axis, widthSize);
    }

    private boolean IsStyleDimensionDefined(YogaFlexDirection axis, float ownerSize) {
        boolean isUndefined = Float.isNaN(this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Value);
        return !(this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Unit == YogaUnit.Auto || this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Unit == YogaUnit.Undefined || this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Unit == YogaUnit.Point && !isUndefined && this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Value < 0.0f || this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Unit == YogaUnit.Percent && !isUndefined && (this.GetResolvedDimension((YogaDimension)YogaNode.Dimension[axis.ordinal()]).Value < 0.0f || Float.isNaN(ownerSize)));
    }

    private boolean IsLayoutDimensionDefined(YogaFlexDirection axis) {
        float value = this._layout.MeasuredDimensions[Dimension[axis.ordinal()].ordinal()];
        return !Float.isNaN(value) && value >= 0.0f;
    }

    private boolean IsBaselineLayout() {
        if (this._style.FlexDirection.IsColumn()) {
            return false;
        }
        if (this._style.AlignItems == YogaAlign.Baseline) {
            return true;
        }
        int childCount = this.GetChildCount();
        for (int i = 0; i < childCount; ++i) {
            YogaNode child = this.GetChild(i);
            if (child._style.PositionType != YogaPositionType.Relative || child._style.AlignSelf != YogaAlign.Baseline) continue;
            return true;
        }
        return false;
    }

    private float GetPaddingAndBorderForAxis(YogaFlexDirection axis, float widthSize) {
        return this.GetLeadingPaddingAndBorder(axis, widthSize) + this.GetTrailingPaddingAndBorder(axis, widthSize);
    }

    private YogaAlign GetAlign(YogaNode child) {
        YogaAlign align;
        YogaAlign yogaAlign = align = child._style.AlignSelf == YogaAlign.Auto ? this._style.AlignItems : child._style.AlignSelf;
        if (align == YogaAlign.Baseline && this._style.FlexDirection.IsColumn()) {
            return YogaAlign.FlexStart;
        }
        return align;
    }

    private void RoundToPixelGrid(float pointScaleFactor, float absoluteLeft, float absoluteTop) {
        if (pointScaleFactor == 0.0f) {
            return;
        }
        float nodeLeft = this._layout.Position[YogaEdge.Left.ordinal()];
        float nodeTop = this._layout.Position[YogaEdge.Top.ordinal()];
        float nodeWidth = this._layout.Dimensions[YogaDimension.Width.ordinal()];
        float nodeHeight = this._layout.Dimensions[YogaDimension.Height.ordinal()];
        float absoluteNodeLeft = absoluteLeft + nodeLeft;
        float absoluteNodeTop = absoluteTop + nodeTop;
        float absoluteNodeRight = absoluteNodeLeft + nodeWidth;
        float absoluteNodeBottom = absoluteNodeTop + nodeHeight;
        boolean textRounding = this._nodeType == YogaNodeType.Text;
        this.SetLayoutPosition(YogaMath.RoundValueToPixelGrid(nodeLeft, pointScaleFactor, false, textRounding), YogaEdge.Left);
        this.SetLayoutPosition(YogaMath.RoundValueToPixelGrid(nodeTop, pointScaleFactor, false, textRounding), YogaEdge.Top);
        boolean hasFractionalWidth = !YogaMath.FloatsEqual(nodeWidth * pointScaleFactor % 1.0f, 0.0f) && !YogaMath.FloatsEqual(nodeWidth * pointScaleFactor % 1.0f, 1.0f);
        boolean hasFractionalHeight = !YogaMath.FloatsEqual(nodeHeight * pointScaleFactor % 1.0f, 0.0f) && !YogaMath.FloatsEqual(nodeHeight * pointScaleFactor % 1.0f, 1.0f);
        this.SetLayoutDimension(YogaMath.RoundValueToPixelGrid(absoluteNodeRight, pointScaleFactor, textRounding && hasFractionalWidth, textRounding && !hasFractionalWidth) - YogaMath.RoundValueToPixelGrid(absoluteNodeLeft, pointScaleFactor, false, textRounding), YogaDimension.Width);
        this.SetLayoutDimension(YogaMath.RoundValueToPixelGrid(absoluteNodeBottom, pointScaleFactor, textRounding && hasFractionalHeight, textRounding && !hasFractionalHeight) - YogaMath.RoundValueToPixelGrid(absoluteNodeTop, pointScaleFactor, false, textRounding), YogaDimension.Height);
        int childCount = this.GetChildCount();
        for (int i = 0; i < childCount; ++i) {
            YogaNode child = this.GetChild(i);
            child.RoundToPixelGrid(pointScaleFactor, absoluteNodeLeft, absoluteNodeTop);
        }
    }

    private YogaNode DeepClone() {
        YogaNode node = new YogaNode(this, null);
        ArrayList<YogaNode> vec = new ArrayList<YogaNode>(this.GetChildCount());
        for (YogaNode item : this._children) {
            YogaNode childNode = item.DeepClone();
            childNode._owner = node;
            vec.add(childNode);
        }
        node.SetChildren(vec);
        if (this._config != null) {
            node._config = this._config.DeepClone();
        }
        if (this._nextChild != null) {
            node._nextChild = this._nextChild.DeepClone();
        }
        return node;
    }

    private static boolean MeasureModeSizeIsExactAndMatchesOldMeasuredSize(YogaMeasureMode sizeMode, float size, float lastComputedSize) {
        return sizeMode == YogaMeasureMode.Exactly && YogaMath.FloatsEqual(size, lastComputedSize);
    }

    private static boolean MeasureModeOldSizeIsUnspecifiedAndStillFits(YogaMeasureMode sizeMode, float size, YogaMeasureMode lastSizeMode, float lastComputedSize) {
        return sizeMode == YogaMeasureMode.AtMost && lastSizeMode == YogaMeasureMode.Undefined && (size > lastComputedSize || size == lastComputedSize || YogaMath.FloatsEqual(size, lastComputedSize));
    }

    private static boolean MeasureModeNewMeasureSizeIsStricterAndStillValid(YogaMeasureMode sizeMode, float size, YogaMeasureMode lastSizeMode, float lastSize, float lastComputedSize) {
        return lastSizeMode == YogaMeasureMode.AtMost && sizeMode == YogaMeasureMode.AtMost && !Float.isNaN(size) && !Float.isNaN(lastSize) && !Float.isNaN(lastComputedSize) && lastSize > size && (lastComputedSize < size || lastComputedSize == size || YogaMath.FloatsEqual(size, lastComputedSize));
    }

    private static boolean CanUseCachedMeasurement(YogaMeasureMode widthMode, float width, YogaMeasureMode heightMode, float height, YogaMeasureMode lastWidthMode, float lastWidth, YogaMeasureMode lastHeightMode, float lastHeight, float lastComputedWidth, float lastComputedHeight, float marginRow, float marginColumn, YogaConfig config) {
        if (!Float.isNaN(lastComputedHeight) && lastComputedHeight < 0.0f || !Float.isNaN(lastComputedWidth) && lastComputedWidth < 0.0f) {
            return false;
        }
        boolean useRoundedComparison = config != null && config.PointScaleFactor != 0.0f;
        float effectiveWidth = useRoundedComparison ? YogaMath.RoundValueToPixelGrid(width, config.PointScaleFactor, false, false) : width;
        float effectiveHeight = useRoundedComparison ? YogaMath.RoundValueToPixelGrid(height, config.PointScaleFactor, false, false) : height;
        float effectiveLastWidth = useRoundedComparison ? YogaMath.RoundValueToPixelGrid(lastWidth, config.PointScaleFactor, false, false) : lastWidth;
        float effectiveLastHeight = useRoundedComparison ? YogaMath.RoundValueToPixelGrid(lastHeight, config.PointScaleFactor, false, false) : lastHeight;
        boolean hasSameWidthSpec = lastWidthMode == widthMode && YogaMath.FloatsEqual(effectiveLastWidth, effectiveWidth);
        boolean hasSameHeightSpec = lastHeightMode == heightMode && YogaMath.FloatsEqual(effectiveLastHeight, effectiveHeight);
        boolean widthIsCompatible = hasSameWidthSpec || YogaNode.MeasureModeSizeIsExactAndMatchesOldMeasuredSize(widthMode, width - marginRow, lastComputedWidth) || YogaNode.MeasureModeOldSizeIsUnspecifiedAndStillFits(widthMode, width - marginRow, lastWidthMode, lastComputedWidth) || YogaNode.MeasureModeNewMeasureSizeIsStricterAndStillValid(widthMode, width - marginRow, lastWidthMode, lastWidth, lastComputedWidth);
        boolean heightIsCompatible = hasSameHeightSpec || YogaNode.MeasureModeSizeIsExactAndMatchesOldMeasuredSize(heightMode, height - marginColumn, lastComputedHeight) || YogaNode.MeasureModeOldSizeIsUnspecifiedAndStillFits(heightMode, height - marginColumn, lastHeightMode, lastComputedHeight) || YogaNode.MeasureModeNewMeasureSizeIsStricterAndStillValid(heightMode, height - marginColumn, lastHeightMode, lastHeight, lastComputedHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    public boolean IsMeasureDefined() {
        return this._measure != null;
    }

    public boolean IsBaselineDefined() {
        return this._baseline != null;
    }

    public boolean GetIsReferenceBaseline() {
        return this._isReferenceBaseline;
    }

    public void SetIsReferenceBaseline(boolean value) {
        if (this._isReferenceBaseline != value) {
            this._isReferenceBaseline = value;
            this.MarkDirty();
        }
    }

    public void CopyStyle(YogaNode srcNode) {
        this._style.CopyFrom(srcNode._style);
    }

    public YogaDirection GetStyleDirection() {
        return this._style.Direction;
    }

    public void SetStyleDirection(YogaDirection value) {
        if (this._style.Direction != value) {
            this._style.Direction = value;
            this.MarkDirty();
        }
    }

    public YogaFlexDirection GetFlexDirection() {
        return this._style.FlexDirection;
    }

    public void SetFlexDirection(YogaFlexDirection value) {
        if (this._style.FlexDirection != value) {
            this._style.FlexDirection = value;
            this.MarkDirty();
        }
    }

    public YogaJustify GetJustifyContent() {
        return this._style.JustifyContent;
    }

    public void SetJustifyContent(YogaJustify value) {
        if (this._style.JustifyContent != value) {
            this._style.JustifyContent = value;
            this.MarkDirty();
        }
    }

    public YogaDisplay GetDisplay() {
        return this._style.Display;
    }

    public void SetDisplay(YogaDisplay value) {
        if (this._style.Display != value) {
            this._style.Display = value;
            this.MarkDirty();
        }
    }

    public YogaAlign GetAlignItems() {
        return this._style.AlignItems;
    }

    public void SetAlignItems(YogaAlign value) {
        if (this._style.AlignItems != value) {
            this._style.AlignItems = value;
            this.MarkDirty();
        }
    }

    public YogaAlign GetAlignSelf() {
        return this._style.AlignSelf;
    }

    public void SetAlignSelf(YogaAlign value) {
        if (this._style.AlignSelf != value) {
            this._style.AlignSelf = value;
            this.MarkDirty();
        }
    }

    public YogaAlign GetAlignContent() {
        return this._style.AlignContent;
    }

    public void SetAlignContent(YogaAlign value) {
        if (this._style.AlignContent != value) {
            this._style.AlignContent = value;
            this.MarkDirty();
        }
    }

    public YogaPositionType GetPositionType() {
        return this._style.PositionType;
    }

    public void SetPositionType(YogaPositionType value) {
        if (this._style.PositionType != value) {
            this._style.PositionType = value;
            this.MarkDirty();
        }
    }

    public YogaWrap GetWrap() {
        return this._style.FlexWrap;
    }

    public void SetWrap(YogaWrap value) {
        if (this._style.FlexWrap != value) {
            this._style.FlexWrap = value;
            this.MarkDirty();
        }
    }

    public void SetFlex(float value) {
        if (this._style.Flex != value) {
            this._style.Flex = value;
            this.MarkDirty();
        }
    }

    public float GetFlexGrow() {
        return this._style.FlexGrow;
    }

    public void SetFlexGrow(float value) {
        if (this._style.FlexGrow != value) {
            this._style.FlexGrow = value;
            this.MarkDirty();
        }
    }

    public float GetFlexShrink() {
        return this._style.FlexShrink;
    }

    public void SetFlexShrink(float value) {
        if (this._style.FlexShrink != value) {
            this._style.FlexShrink = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetFlexBasis() {
        return this._style.FlexBasis;
    }

    public void SetFlexBasis(YogaValue value) {
        YogaValue current = this._style.FlexBasis;
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.FlexBasis = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetWidth() {
        return this._style.Dimensions[YogaDimension.Width.ordinal()];
    }

    public void SetWidth(YogaValue value) {
        YogaValue current = this._style.Dimensions[YogaDimension.Width.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.Dimensions[YogaDimension.Width.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetHeight() {
        return this._style.Dimensions[YogaDimension.Height.ordinal()];
    }

    public void SetHeight(YogaValue value) {
        YogaValue current = this._style.Dimensions[YogaDimension.Height.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.Dimensions[YogaDimension.Height.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetMaxWidth() {
        return this._style.MaxDimensions[YogaDimension.Width.ordinal()];
    }

    public void SetMaxWidth(YogaValue value) {
        YogaValue current = this._style.MaxDimensions[YogaDimension.Width.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.MaxDimensions[YogaDimension.Width.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetMaxHeight() {
        return this._style.MaxDimensions[YogaDimension.Height.ordinal()];
    }

    public void SetMaxHeight(YogaValue value) {
        YogaValue current = this._style.MaxDimensions[YogaDimension.Height.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.MaxDimensions[YogaDimension.Height.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetMinWidth() {
        return this._style.MinDimensions[YogaDimension.Width.ordinal()];
    }

    public void SetMinWidth(YogaValue value) {
        YogaValue current = this._style.MinDimensions[YogaDimension.Width.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.MinDimensions[YogaDimension.Width.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public YogaValue GetMinHeight() {
        return this._style.MinDimensions[YogaDimension.Height.ordinal()];
    }

    public void SetMinHeight(YogaValue value) {
        YogaValue current = this._style.MinDimensions[YogaDimension.Height.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.MinDimensions[YogaDimension.Height.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public float GetAspectRatio() {
        return this._style.AspectRatio;
    }

    public void SetAspectRatio(float value) {
        if (this._style.AspectRatio != value) {
            this._style.AspectRatio = value;
            this.MarkDirty();
        }
    }

    public float GetLayoutX() {
        float value = this._layout.Position[YogaEdge.Left.ordinal()];
        return Float.isNaN(value) ? 0.0f : value;
    }

    public float GetLayoutY() {
        float value = this._layout.Position[YogaEdge.Top.ordinal()];
        return Float.isNaN(value) ? 0.0f : value;
    }

    public float GetLayoutWidth() {
        float value = this._layout.Dimensions[YogaDimension.Width.ordinal()];
        return Float.isNaN(value) ? 0.0f : value;
    }

    public float GetLayoutHeight() {
        float value = this._layout.Dimensions[YogaDimension.Height.ordinal()];
        return Float.isNaN(value) ? 0.0f : value;
    }

    public YogaDirection GetLayoutDirection() {
        return this._layout.Direction;
    }

    public YogaOverflow GetOverflow() {
        return this._style.Overflow;
    }

    public void SetOverflow(YogaOverflow value) {
        if (this._style.Overflow != value) {
            this._style.Overflow = value;
            this.MarkDirty();
        }
    }

    public int GetChildCount() {
        return this._children.size();
    }

    public void MarkLayoutSeen() {
        this._hasNewLayout = false;
    }

    public void Reset() {
        if (this._children.size() > 0) {
            throw new UnsupportedOperationException("Cannot reset a node which still has children attached");
        }
        if (this._owner != null) {
            throw new UnsupportedOperationException("Cannot reset a node still attached to a owner");
        }
        this.Clear();
        this._print = null;
        this._hasNewLayout = true;
        this._nodeType = YogaNodeType.Default;
        this._measure = null;
        this._baseline = null;
        this._dirtied = null;
        this._style = new YogaStyle();
        this._layout = new YogaLayout();
        this._lineIndex = 0;
        this._owner = null;
        this._children = new ArrayList<YogaNode>();
        this._nextChild = null;
        this._isDirty = false;
        this._resolvedDimensions = new YogaValue[]{YogaValue.UNDEFINED, YogaValue.UNDEFINED};
        if (this._config.UseWebDefaults) {
            this._style.FlexDirection = YogaFlexDirection.Row;
            this._style.AlignContent = YogaAlign.Stretch;
        }
    }

    @Override
    public Iterator<YogaNode> iterator() {
        return this._children.iterator();
    }

    public YogaValue GetLeft() {
        return this._style.Position[YogaEdge.Left.ordinal()];
    }

    public void SetLeft(YogaValue value) {
        this.SetStylePosition(YogaEdge.Left, value);
    }

    public YogaValue GetTop() {
        return this._style.Position[YogaEdge.Top.ordinal()];
    }

    public void SetTop(YogaValue value) {
        this.SetStylePosition(YogaEdge.Top, value);
    }

    public YogaValue GetRight() {
        return this._style.Position[YogaEdge.Right.ordinal()];
    }

    public void SetRight(YogaValue value) {
        this.SetStylePosition(YogaEdge.Right, value);
    }

    public YogaValue GetBottom() {
        return this._style.Position[YogaEdge.Bottom.ordinal()];
    }

    public void SetBottom(YogaValue value) {
        this.SetStylePosition(YogaEdge.Bottom, value);
    }

    public YogaValue GetStart() {
        return this._style.Position[YogaEdge.Start.ordinal()];
    }

    public void SetStart(YogaValue value) {
        this.SetStylePosition(YogaEdge.Start, value);
    }

    public YogaValue GetEnd() {
        return this._style.Position[YogaEdge.End.ordinal()];
    }

    public void SetEnd(YogaValue value) {
        this.SetStylePosition(YogaEdge.End, value);
    }

    public YogaValue GetMarginLeft() {
        return this._style.Margin[YogaEdge.Left.ordinal()];
    }

    public void SetMarginLeft(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Left, value);
    }

    public YogaValue GetMarginTop() {
        return this._style.Margin[YogaEdge.Top.ordinal()];
    }

    public void SetMarginTop(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Top, value);
    }

    public YogaValue GetMarginRight() {
        return this._style.Margin[YogaEdge.Right.ordinal()];
    }

    public void SetMarginRight(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Right, value);
    }

    public YogaValue GetMarginBottom() {
        return this._style.Margin[YogaEdge.Bottom.ordinal()];
    }

    public void SetMarginBottom(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Bottom, value);
    }

    public YogaValue GetMarginStart() {
        return this._style.Margin[YogaEdge.Start.ordinal()];
    }

    public void SetMarginStart(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Start, value);
    }

    public YogaValue GetMarginEnd() {
        return this._style.Margin[YogaEdge.End.ordinal()];
    }

    public void SetMarginEnd(YogaValue value) {
        this.SetStyleMargin(YogaEdge.End, value);
    }

    public YogaValue GetMarginHorizontal() {
        return this._style.Margin[YogaEdge.Horizontal.ordinal()];
    }

    public void SetMarginHorizontal(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Horizontal, value);
    }

    public YogaValue GetMarginVertical() {
        return this._style.Margin[YogaEdge.Vertical.ordinal()];
    }

    public void SetMarginVertical(YogaValue value) {
        this.SetStyleMargin(YogaEdge.Vertical, value);
    }

    public YogaValue GetMargin() {
        return this._style.Margin[YogaEdge.All.ordinal()];
    }

    public void SetMargin(YogaValue value) {
        this.SetStyleMargin(YogaEdge.All, value);
    }

    public YogaValue GetPaddingLeft() {
        return this._style.Padding[YogaEdge.Left.ordinal()];
    }

    public void SetPaddingLeft(YogaValue value) {
        this.SetStylePadding(YogaEdge.Left, value);
    }

    public YogaValue GetPaddingTop() {
        return this._style.Padding[YogaEdge.Top.ordinal()];
    }

    public void SetPaddingTop(YogaValue value) {
        this.SetStylePadding(YogaEdge.Top, value);
    }

    public YogaValue GetPaddingRight() {
        return this._style.Padding[YogaEdge.Right.ordinal()];
    }

    public void SetPaddingRight(YogaValue value) {
        this.SetStylePadding(YogaEdge.Right, value);
    }

    public YogaValue GetPaddingBottom() {
        return this._style.Padding[YogaEdge.Bottom.ordinal()];
    }

    public void SetPaddingBottom(YogaValue value) {
        this.SetStylePadding(YogaEdge.Bottom, value);
    }

    public YogaValue GetPaddingStart() {
        return this._style.Padding[YogaEdge.Start.ordinal()];
    }

    public void SetPaddingStart(YogaValue value) {
        this.SetStylePadding(YogaEdge.Start, value);
    }

    public YogaValue GetPaddingEnd() {
        return this._style.Padding[YogaEdge.End.ordinal()];
    }

    public void SetPaddingEnd(YogaValue value) {
        this.SetStylePadding(YogaEdge.End, value);
    }

    public YogaValue GetPaddingHorizontal() {
        return this._style.Padding[YogaEdge.Horizontal.ordinal()];
    }

    public void SetPaddingHorizontal(YogaValue value) {
        this.SetStylePadding(YogaEdge.Horizontal, value);
    }

    public YogaValue GetPaddingVertical() {
        return this._style.Padding[YogaEdge.Vertical.ordinal()];
    }

    public void SetPaddingVertical(YogaValue value) {
        this.SetStylePadding(YogaEdge.Vertical, value);
    }

    public YogaValue GetPadding() {
        return this._style.Padding[YogaEdge.All.ordinal()];
    }

    public void SetPadding(YogaValue value) {
        this.SetStylePadding(YogaEdge.All, value);
    }

    public float GetBorderLeftWidth() {
        YogaValue value = this._style.Border[YogaEdge.Left.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderLeftWidth(float value) {
        YogaEdge edge = YogaEdge.Left;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetBorderTopWidth() {
        YogaValue value = this._style.Border[YogaEdge.Top.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderTopWidth(float value) {
        YogaEdge edge = YogaEdge.Top;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetBorderRightWidth() {
        YogaValue value = this._style.Border[YogaEdge.Right.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderRightWidth(float value) {
        YogaEdge edge = YogaEdge.Right;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetBorderBottomWidth() {
        YogaValue value = this._style.Border[YogaEdge.Bottom.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderBottomWidth(float value) {
        YogaEdge edge = YogaEdge.Bottom;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetBorderStartWidth() {
        YogaValue value = this._style.Border[YogaEdge.Start.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderStartWidth(float value) {
        YogaEdge edge = YogaEdge.Start;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetBorderEndWidth() {
        YogaValue value = this._style.Border[YogaEdge.End.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderEndWidth(float value) {
        YogaEdge edge = YogaEdge.End;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetBorderWidth() {
        YogaValue value = this._style.Border[YogaEdge.All.ordinal()];
        if (value.Unit == YogaUnit.Auto || value.Unit == YogaUnit.Undefined) {
            return Float.NaN;
        }
        return value.Value;
    }

    public void SetBorderWidth(float value) {
        YogaEdge edge = YogaEdge.All;
        YogaValue current = this._style.Border[edge.ordinal()];
        YogaValue next = new YogaValue(value, Float.isNaN(value) ? YogaUnit.Undefined : YogaUnit.Point);
        if (current.Unit != next.Unit || next.Unit != YogaUnit.Undefined && current.Value != next.Value) {
            this._style.Border[edge.ordinal()] = next;
            this.MarkDirty();
        }
    }

    public float GetLayoutMarginLeft() {
        return this.GetLayoutMargin(YogaEdge.Left);
    }

    public float GetLayoutMarginTop() {
        return this.GetLayoutMargin(YogaEdge.Top);
    }

    public float GetLayoutMarginRight() {
        return this.GetLayoutMargin(YogaEdge.Right);
    }

    public float GetLayoutMarginBottom() {
        return this.GetLayoutMargin(YogaEdge.Bottom);
    }

    public float GetLayoutMarginStart() {
        return this.GetLayoutMargin(YogaEdge.Start);
    }

    public float GetLayoutMarginEnd() {
        return this.GetLayoutMargin(YogaEdge.End);
    }

    public float GetLayoutPaddingLeft() {
        return this.GetLayoutPadding(YogaEdge.Left);
    }

    public float GetLayoutPaddingTop() {
        return this.GetLayoutPadding(YogaEdge.Top);
    }

    public float GetLayoutPaddingRight() {
        return this.GetLayoutPadding(YogaEdge.Right);
    }

    public float GetLayoutPaddingBottom() {
        return this.GetLayoutPadding(YogaEdge.Bottom);
    }

    public float GetLayoutPaddingStart() {
        return this.GetLayoutPadding(YogaEdge.Start);
    }

    public float GetLayoutPaddingEnd() {
        return this.GetLayoutPadding(YogaEdge.End);
    }

    private void SetStylePosition(YogaEdge edge, YogaValue value) {
        YogaValue current = this._style.Position[edge.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.Position[edge.ordinal()] = value;
            this.MarkDirty();
        }
    }

    private void SetStyleMargin(YogaEdge edge, YogaValue value) {
        YogaValue current = this._style.Margin[edge.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.Margin[edge.ordinal()] = value;
            this.MarkDirty();
        }
    }

    private void SetStylePadding(YogaEdge edge, YogaValue value) {
        YogaValue current = this._style.Padding[edge.ordinal()];
        if (current.Unit != value.Unit || value.Unit != YogaUnit.Undefined && current.Value != value.Value) {
            this._style.Padding[edge.ordinal()] = value;
            this.MarkDirty();
        }
    }

    public float GetLayoutMargin(YogaEdge edge) {
        if (edge == YogaEdge.Left) {
            if (this._layout.Direction == YogaDirection.RightToLeft) {
                return this._layout.Margin[YogaEdge.End.ordinal()];
            }
            return this._layout.Margin[YogaEdge.Start.ordinal()];
        }
        if (edge == YogaEdge.Right) {
            if (this._layout.Direction == YogaDirection.RightToLeft) {
                return this._layout.Margin[YogaEdge.Start.ordinal()];
            }
            return this._layout.Margin[YogaEdge.End.ordinal()];
        }
        return this._layout.Margin[edge.ordinal()];
    }

    public float GetLayoutPadding(YogaEdge edge) {
        if (edge == YogaEdge.Left) {
            if (this._layout.Direction == YogaDirection.RightToLeft) {
                return this._layout.Padding[YogaEdge.End.ordinal()];
            }
            return this._layout.Padding[YogaEdge.Start.ordinal()];
        }
        if (edge == YogaEdge.Right) {
            if (this._layout.Direction == YogaDirection.RightToLeft) {
                return this._layout.Padding[YogaEdge.Start.ordinal()];
            }
            return this._layout.Padding[YogaEdge.End.ordinal()];
        }
        return this._layout.Padding[edge.ordinal()];
    }

    private static final class JustifyMainAxisReturn {
        YogaCollectFlexItemsRowValues collectedFlexItemsValues;
        int startOfLineIndex;
        YogaFlexDirection mainAxis;
        YogaFlexDirection crossAxis;
        YogaMeasureMode measureModeMainDim;
        YogaMeasureMode measureModeCrossDim;
        float mainAxisOwnerSize;
        float ownerWidth;
        float availableInnerMainDim;
        float availableInnerCrossDim;
        float availableInnerWidth;
        boolean performLayout;

        private JustifyMainAxisReturn() {
        }
    }
}

