/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.util.CastOptional;

public class BlockForgedCrate
extends FallingBlock
implements ITetraBlock,
IBlockCapabilityInteractive,
IWaterLoggable {
    static final String unlocalizedName = "forged_crate";
    @ObjectHolder(value="tetra:forged_crate")
    public static BlockForgedCrate instance;
    public static final DirectionProperty propFacing;
    public static final BooleanProperty propStacked;
    public static final IntegerProperty propIntegrity;
    static final BlockInteraction[] interactions;
    public static final ResourceLocation pryBonusLootTable;
    public static final ResourceLocation hammerbonusLootTable;
    private static final VoxelShape shape;
    private static final VoxelShape[] shapesNormal;
    private static final VoxelShape[] shapesOffset;

    public BlockForgedCrate() {
        super(Block.Properties.func_200945_a((Material)ForgedBlockCommon.forgedMaterial).func_200947_a(SoundType.field_185852_e).func_200943_b(7.0f));
        this.setRegistryName(unlocalizedName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)propFacing, (Comparable)Direction.EAST)).func_206870_a((IProperty)propStacked, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)propIntegrity, (Comparable)Integer.valueOf(3))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    private static boolean attemptBreakHammer(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction facing) {
        return BlockForgedCrate.attemptBreak(world, pos, blockState, player, hand, player.func_184586_b(hand), Capability.hammer, 2, 1);
    }

    private static boolean attemptBreakPry(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, Direction facing) {
        return BlockForgedCrate.attemptBreak(world, pos, blockState, player, hand, player.func_184586_b(hand), Capability.pry, 0, 2);
    }

    private static boolean attemptBreak(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand, ItemStack itemStack, Capability capability, int min, int multiplier) {
        int progress;
        int integrity = (Integer)blockState.func_177229_b((IProperty)propIntegrity);
        if (integrity - (progress = CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> item.getCapabilityLevel(itemStack, capability)).map(level -> (level - min) * multiplier).orElse(1).intValue()) >= 0) {
            if (Capability.hammer.equals((Object)capability)) {
                world.func_184133_a(player, pos, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 1.0f, 0.5f);
            } else {
                world.func_184133_a(player, pos, SoundEvents.field_187653_cW, SoundCategory.PLAYERS, 0.7f, 2.0f);
            }
            world.func_175656_a(pos, (BlockState)blockState.func_206870_a((IProperty)propIntegrity, (Comparable)Integer.valueOf(integrity - progress)));
        } else {
            boolean didBreak = ItemEffectHandler.breakBlock(world, player, itemStack, pos, blockState, false);
            if (didBreak && world instanceof ServerWorld) {
                ResourceLocation lootTable = Capability.hammer.equals((Object)capability) ? hammerbonusLootTable : pryBonusLootTable;
                BlockInteraction.getLoot(lootTable, player, hand, (ServerWorld)world, blockState).forEach(lootStack -> BlockForgedCrate.func_180635_a((World)world, (BlockPos)pos, (ItemStack)lootStack));
            }
        }
        return true;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(BlockState state, Direction face, Collection<Capability> capabilities) {
        return interactions;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{propFacing, propStacked, propIntegrity, BlockStateProperties.field_208198_y});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)propFacing, (Comparable)context.func_195992_f())).func_206870_a((IProperty)propStacked, (Comparable)Boolean.valueOf(this.equals(context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_177230_c())))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (Direction.DOWN.equals((Object)facing)) {
            return (BlockState)super.func_196271_a(state, facing, facingState, world, currentPos, facingPos).func_206870_a((IProperty)propStacked, (Comparable)Boolean.valueOf(this.equals(facingState.func_177230_c())));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((IProperty)propStacked)).booleanValue()) {
            return shapesNormal[((Direction)state.func_177229_b((IProperty)propFacing)).func_176736_b()];
        }
        return shapesOffset[((Direction)state.func_177229_b((IProperty)propFacing)).func_176736_b()];
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)propFacing, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)propFacing)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)propFacing)));
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        this.registerItem(registry, (Block)this);
    }

    static {
        propFacing = HorizontalBlock.field_185512_D;
        propStacked = BooleanProperty.func_177716_a((String)"stacked");
        propIntegrity = IntegerProperty.func_177719_a((String)"integrity", (int)0, (int)3);
        interactions = new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, Direction.EAST, 6.0f, 8.0f, 6.0f, 8.0f, BlockStateMatcher.field_185928_a, BlockForgedCrate::attemptBreakPry), new BlockInteraction(Capability.hammer, 3, Direction.EAST, 1.0f, 4.0f, 1.0f, 4.0f, BlockStateMatcher.field_185928_a, BlockForgedCrate::attemptBreakHammer), new BlockInteraction(Capability.hammer, 3, Direction.EAST, 10.0f, 13.0f, 10.0f, 13.0f, BlockStateMatcher.field_185928_a, BlockForgedCrate::attemptBreakHammer)};
        pryBonusLootTable = new ResourceLocation("tetra", "forged/forged_crate_pry_bonus");
        hammerbonusLootTable = new ResourceLocation("tetra", "forged/forged_crate_hammer_bonus");
        shape = BlockForgedCrate.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        shapesNormal = new VoxelShape[4];
        shapesOffset = new VoxelShape[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockForgedCrate.shapesNormal[dir.func_176736_b()] = shape.func_197751_a((double)((float)dir.func_82601_c() / 16.0f), (double)((float)dir.func_96559_d() / 16.0f), (double)((float)dir.func_82599_e() / 16.0f));
            BlockForgedCrate.shapesOffset[dir.func_176736_b()] = shapesNormal[dir.func_176736_b()].func_197751_a(0.0, -0.125, 0.0);
        }
    }
}

