/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.network.BlockPosPacket;
import se.mickelus.tetra.util.CastOptional;

public class WorkbenchPacketTweak
extends BlockPosPacket {
    String slot;
    Map<String, Integer> tweaks;

    public WorkbenchPacketTweak() {
        this.tweaks = new HashMap<String, Integer>();
    }

    public WorkbenchPacketTweak(BlockPos pos, String slot, Map<String, Integer> tweaks) {
        super(pos);
        this.slot = slot;
        this.tweaks = tweaks;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        try {
            WorkbenchPacketTweak.writeString(this.slot, buffer);
        }
        catch (IOException e) {
            System.err.println("An error occurred when writing tweak packet to buffer");
        }
        buffer.writeInt(this.tweaks.size());
        this.tweaks.forEach((tweakKey, step) -> {
            try {
                WorkbenchPacketTweak.writeString(tweakKey, buffer);
                buffer.writeInt(step.intValue());
            }
            catch (IOException e) {
                System.err.println("An error occurred when writing tweak packet to buffer");
            }
        });
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        super.fromBytes(buffer);
        try {
            this.slot = WorkbenchPacketTweak.readString(buffer);
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                this.tweaks.put(WorkbenchPacketTweak.readString(buffer), buffer.readInt());
            }
        }
        catch (IOException e) {
            System.err.println("An error occurred when reading tweak packet from buffer");
        }
    }

    @Override
    public void handle(PlayerEntity player) {
        CastOptional.cast(player.field_70170_p.func_175625_s(this.pos), WorkbenchTile.class).ifPresent(workbench -> workbench.tweak(player, this.slot, this.tweaks));
    }
}

