/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureChild;
import se.mickelus.tetra.generation.FeatureLoot;
import se.mickelus.tetra.generation.FeatureParameters;

@OnlyIn(value=Dist.CLIENT)
public class ExtendedStructureTESR
extends StructureTileEntityRenderer {
    public ExtendedStructureTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void func_225616_a_(StructureBlockTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        super.func_225616_a_(te, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        BlockPos rel = te.func_189711_e();
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228659_m_());
        Optional.ofNullable(DataManager.featureData.getData(new ResourceLocation(te.func_189715_d()))).ifPresent(feature -> this.renderFeatureInfo((FeatureParameters)feature, matrixStack, vertexBuilder, rel.func_177958_n(), rel.func_177956_o(), rel.func_177952_p()));
    }

    private void renderFeatureInfo(FeatureParameters feature, MatrixStack matrixStack, IVertexBuilder vertexBuilder, double x, double y, double z) {
        GlStateManager.func_227701_d_((float)3.0f);
        BlockPos origin = feature.origin;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)origin.func_177958_n() + 0.5, y + (double)origin.func_177956_o() + 0.5, z + (double)origin.func_177952_p() + 0.5, x + (double)origin.func_177958_n() + 0.5, y + (double)origin.func_177956_o() + 0.5, z + (double)origin.func_177952_p() + 0.5);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_186662_g(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        Arrays.stream(feature.children).forEach(featureChild -> this.renderChild((FeatureChild)featureChild, matrixStack, vertexBuilder, x, y, z));
        Arrays.stream(feature.loot).forEach(featureLoot -> this.renderLoot((FeatureLoot)featureLoot, matrixStack, vertexBuilder, x, y, z));
        GlStateManager.func_227701_d_((float)1.0f);
    }

    private void renderChild(FeatureChild featureChild, MatrixStack matrixStack, IVertexBuilder vertexBuilder, double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        BlockPos offset = featureChild.offset;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)offset.func_177958_n() + 0.5, y + (double)offset.func_177956_o() + 0.5, z + (double)offset.func_177952_p() + 0.5, x + (double)offset.func_177958_n() + 0.5, y + (double)offset.func_177956_o() + 0.5, z + (double)offset.func_177952_p() + 0.5);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_186662_g(0.5020000000949949), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vec3i facing = featureChild.facing.func_176730_m();
        bufferBuilder.func_225582_a_(x + (double)offset.func_177958_n() + 0.5, y + (double)offset.func_177956_o() + 0.5, z + (double)offset.func_177952_p() + 0.5).func_227885_a_(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        bufferBuilder.func_225582_a_(x + (double)offset.func_177958_n() + 0.5 + 0.3 * (double)facing.func_177958_n(), y + (double)offset.func_177956_o() + 0.5 + 0.3 * (double)facing.func_177956_o(), z + (double)offset.func_177952_p() + 0.5 + 0.3 * (double)facing.func_177952_p()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_186662_g(0.1), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.8f);
    }

    private void renderLoot(FeatureLoot featureLoot, MatrixStack matrixStack, IVertexBuilder vertexBuilder, double x, double y, double z) {
        BlockPos offset = featureLoot.position;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)offset.func_177958_n(), y + (double)offset.func_177956_o(), z + (double)offset.func_177952_p(), x + (double)offset.func_177958_n() + 0.2, y + (double)offset.func_177956_o() + 0.2, z + (double)offset.func_177952_p() + 0.2).func_72317_d(-0.1, -0.1, -0.1);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.func_217730_a((AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)aabb.func_72317_d(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
    }
}

