/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation.processing;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerConfig;
import se.mickelus.tetra.blocks.forged.hammer.EnumHammerPlate;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.generation.processing.ProcessorTypes;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;

public class ForgedHammerProcessor
extends StructureProcessor {
    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, Template.BlockInfo $, Template.BlockInfo blockInfo, PlacementSettings placementSettings, @Nullable Template template) {
        if (blockInfo.field_186243_b.func_177230_c() instanceof HammerBaseBlock) {
            Random random = placementSettings.func_189947_a(blockInfo.field_186242_a);
            CompoundNBT newCompound = blockInfo.field_186244_c.func_74737_b();
            ItemStack cell1 = random.nextBoolean() ? new ItemStack((IItemProvider)ItemCellMagmatic.instance) : null;
            ItemStack cell2 = random.nextBoolean() ? new ItemStack((IItemProvider)ItemCellMagmatic.instance) : null;
            int charge1 = random.nextInt(128);
            if (cell1 != null) {
                ItemCellMagmatic.instance.recharge(cell1, charge1);
            }
            int charge2 = 128 - random.nextInt(Math.max(charge1, 1));
            if (cell2 != null) {
                ItemCellMagmatic.instance.recharge(cell2, charge2);
            }
            HammerBaseTile.writeCells(newCompound, cell1, cell2);
            EnumHammerConfig[] configs = EnumHammerConfig.values();
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockInfo.field_186243_b.func_206870_a((IProperty)HammerBaseBlock.propCell1, (Comparable)Boolean.valueOf(cell1 != null))).func_206870_a((IProperty)HammerBaseBlock.propCell1Charged, (Comparable)Boolean.valueOf(cell1 != null && charge1 > 0))).func_206870_a((IProperty)HammerBaseBlock.propCell2, (Comparable)Boolean.valueOf(cell2 != null))).func_206870_a((IProperty)HammerBaseBlock.propCell2Charged, (Comparable)Boolean.valueOf(cell2 != null && charge2 > 0))).func_206870_a(EnumHammerConfig.eastProp, (Comparable)((Object)configs[random.nextInt(configs.length)]))).func_206870_a(EnumHammerConfig.eastProp, (Comparable)((Object)configs[random.nextInt(configs.length)]))).func_206870_a(EnumHammerConfig.eastProp, (Comparable)((Object)configs[random.nextInt(configs.length)]))).func_206870_a(EnumHammerConfig.eastProp, (Comparable)((Object)configs[random.nextInt(configs.length)]))).func_206870_a(EnumHammerConfig.westProp, (Comparable)((Object)configs[random.nextInt(configs.length)]))).func_206870_a((IProperty)EnumHammerPlate.east.prop, (Comparable)Boolean.valueOf(random.nextBoolean()))).func_206870_a((IProperty)EnumHammerPlate.west.prop, (Comparable)Boolean.valueOf(random.nextBoolean()));
            return new Template.BlockInfo(blockInfo.field_186242_a, newState, newCompound);
        }
        return blockInfo;
    }

    protected IStructureProcessorType func_215192_a() {
        return ProcessorTypes.forgedHammer;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops);
    }
}

