/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.statbar;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.tetra.gui.statbar.GuiBar;
import se.mickelus.tetra.gui.statbar.GuiBarSegmented;
import se.mickelus.tetra.gui.statbar.GuiBarSplit;
import se.mickelus.tetra.gui.statbar.GuiStatBase;
import se.mickelus.tetra.gui.statbar.getter.ILabelGetter;
import se.mickelus.tetra.gui.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBar
extends GuiStatBase {
    protected double min;
    protected double max;
    protected GuiString labelString;
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<String> tooltip;
    protected List<String> extendedTooltip;
    protected GuiAlignment alignment = GuiAlignment.left;
    protected boolean inverted = false;
    protected IStatGetter statGetter;
    protected ILabelGetter labelGetter;
    protected ITooltipGetter tooltipGetter;

    public GuiStatBar(int x, int y, int barLength, String label, double min, double max, boolean segmented, IStatGetter statGetter, ILabelGetter labelGetter, ITooltipGetter tooltipGetter) {
        this(x, y, barLength, label, min, max, segmented, false, false, statGetter, labelGetter, tooltipGetter);
    }

    public GuiStatBar(int x, int y, int barLength, String label, double min, double max, boolean segmented, boolean split, boolean inverted, IStatGetter statGetter, ILabelGetter labelGetter, ITooltipGetter tooltipGetter) {
        super(x, y, barLength, 12);
        this.min = min;
        this.max = max;
        this.labelString = new GuiStringSmall(0, 0, label);
        this.valueString = new GuiStringSmall(0, 0, label);
        this.bar = segmented ? new GuiBarSegmented(0, 0, barLength + 1, min, max, inverted) : (split ? new GuiBarSplit(0, 0, barLength, max, inverted) : new GuiBar(0, 0, barLength, min, max, inverted));
        this.addChild((GuiElement)this.labelString);
        this.addChild((GuiElement)this.valueString);
        this.addChild(this.bar);
        this.statGetter = statGetter;
        this.labelGetter = labelGetter;
        this.tooltipGetter = tooltipGetter;
        inverted = true;
    }

    @Override
    public void setAlignment(GuiAlignment alignment) {
        this.alignment = alignment;
        this.realign();
    }

    protected void realign() {
        this.bar.setAlignment(this.alignment);
        this.labelString.setAttachment(this.alignment.toAttachment());
        this.valueString.setAttachment(this.alignment.toAttachment().flipHorizontal());
    }

    @Override
    public void update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        double diffValue;
        double value;
        if (!previewStack.func_190926_b()) {
            value = this.statGetter.getValue(player, currentStack);
            diffValue = this.statGetter.getValue(player, previewStack);
            this.tooltip = Collections.singletonList(this.tooltipGetter.getTooltip(player, previewStack));
            this.extendedTooltip = Collections.singletonList(this.tooltipGetter.getTooltipExtended(player, previewStack));
        } else {
            value = this.statGetter.getValue(player, currentStack);
            if (slot != null) {
                diffValue = value;
                value -= this.getSlotValue(player, currentStack, slot, improvement);
            } else {
                diffValue = value;
            }
            this.tooltip = Collections.singletonList(this.tooltipGetter.getTooltip(player, currentStack));
            this.extendedTooltip = Collections.singletonList(this.tooltipGetter.getTooltipExtended(player, currentStack));
        }
        this.updateValue(value, diffValue);
    }

    @Override
    public boolean shouldShow(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.statGetter.shouldShow(player, currentStack, previewStack);
    }

    protected double getSlotValue(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), ModularItem.class).map(item -> {
            if (improvement != null) {
                return this.statGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.statGetter.getValue(player, itemStack, slot);
        }).orElse(0.0);
    }

    public void updateValue(double value, double diffValue) {
        this.bar.setValue(value, diffValue);
        this.updateValueLabel(value, diffValue);
    }

    private void updateValueLabel(double value, double diffValue) {
        this.valueString.setString(this.labelGetter.getLabel(value, diffValue, this.alignment == GuiAlignment.right));
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.hasShiftDown()) {
                return this.extendedTooltip;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

