/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.LinkedList;
import net.minecraft.client.resources.I18n;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloRootBaseGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloBreadcrumbsGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloItemsGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSchemaGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSchemasGui;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class HoloCraftRootGuiGui
extends HoloRootBaseGui {
    public static final char backBinding = 'q';
    private HoloBreadcrumbsGui breadcrumbs = new HoloBreadcrumbsGui(0, 0, this.width, this::onBreadcrumbClick);
    private int depth = 0;
    private HoloItemsGui itemsView;
    private ModularItem item;
    private HoloSchemasGui schemasView;
    private String slot;
    private HoloSchemaGui schemaView;
    private UpgradeSchema schema;

    public HoloCraftRootGuiGui(int x, int y) {
        super(x, y);
        this.breadcrumbs.setVisible(false);
        this.addChild(this.breadcrumbs);
        this.itemsView = new HoloItemsGui(0, 70, this.width, this.height, this::onItemSelect, this::onSlotSelect);
        this.addChild(this.itemsView);
        this.schemasView = new HoloSchemasGui(0, 20, this.width, this.height, this::onSchemaSelect);
        this.schemasView.setVisible(false);
        this.addChild(this.schemasView);
        this.schemaView = new HoloSchemaGui(0, 20, this.width, this.height);
        this.schemaView.setVisible(false);
        this.addChild(this.schemaView);
    }

    @Override
    public void charTyped(char typedChar) {
        switch (typedChar) {
            case 'q': {
                if (this.depth <= 0) break;
                this.onBreadcrumbClick(this.depth - 1);
            }
        }
    }

    private void onBreadcrumbClick(int depth) {
        switch (depth) {
            case 0: {
                this.onItemSelect(null);
                break;
            }
            case 1: {
                this.onItemSelect(this.item);
                break;
            }
            case 2: {
                this.onSlotSelect(this.slot);
            }
        }
        this.depth = depth;
    }

    private void onItemSelect(ModularItem item) {
        this.item = item;
        this.itemsView.changeItem(item);
        this.itemsView.setVisible(true);
        this.slot = null;
        this.schemasView.setVisible(false);
        this.schema = null;
        this.schemaView.setVisible(false);
        if (this.depth > 1) {
            this.itemsView.animateBack();
        }
        this.updateBreadcrumb();
    }

    private void onSlotSelect(String slot) {
        this.slot = slot;
        this.schemasView.update(this.item, slot);
        this.schemasView.setVisible(true);
        this.itemsView.setVisible(false);
        this.schema = null;
        this.schemaView.setVisible(false);
        this.updateBreadcrumb();
    }

    private void onSchemaSelect(UpgradeSchema schema) {
        this.schema = schema;
        this.schemaView.update(this.item, this.slot, schema);
        this.schemaView.setVisible(true);
        this.schemasView.setVisible(false);
        this.itemsView.setVisible(false);
        this.updateBreadcrumb();
    }

    private void updateBreadcrumb() {
        this.breadcrumbs.setVisible(this.item != null);
        if (this.item != null) {
            LinkedList<String> result = new LinkedList<String>();
            result.add(I18n.func_135052_a((String)"tetra.holo.craft.breadcrumb.root", (Object[])new Object[0]));
            result.add(I18n.func_135052_a((String)("tetra.holo.craft." + this.item.getRegistryName().func_110623_a()), (Object[])new Object[0]));
            if (this.slot != null) {
                result.add(this.getSlotName());
            }
            if (this.schema != null) {
                result.add(this.schema.getName());
            }
            this.depth = result.size() - 1;
            this.breadcrumbs.setItems(result.toArray(new String[0]));
        }
    }

    private String getSlotName() {
        if (this.item != null) {
            String[] majorKeys = this.item.getMajorModuleKeys();
            for (int i = 0; i < majorKeys.length; ++i) {
                if (!majorKeys[i].equals(this.slot)) continue;
                return this.item.getMajorModuleNames()[i];
            }
            String[] minorKeys = this.item.getMinorModuleKeys();
            for (int i = 0; i < minorKeys.length; ++i) {
                if (!minorKeys[i].equals(this.slot)) continue;
                return this.item.getMinorModuleNames()[i];
            }
        }
        return this.slot;
    }

    @Override
    public void animateOpen() {
        switch (this.depth) {
            case 0: 
            case 1: {
                this.itemsView.animateOpen();
                break;
            }
            case 2: {
                this.schemasView.animateOpen();
                break;
            }
            case 3: {
                this.schemaView.animateOpen();
            }
        }
        this.breadcrumbs.animateOpen(this.depth > 1);
    }
}

