/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import com.google.common.collect.Multimap;
import java.util.Optional;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.BlockProgressOverlay;
import se.mickelus.tetra.items.modular.impl.shield.ApplyBannerSchema;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldISTER;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.SchemaRegistry;
import se.mickelus.tetra.module.schema.RemoveSchema;
import se.mickelus.tetra.module.schema.RepairSchema;
import se.mickelus.tetra.util.CastOptional;

public class ModularShieldItem
extends ItemModularHandheld {
    public static final String plateKey = "shield/plate";
    public static final String gripKey = "shield/grip";
    public static final String bossKey = "shield/boss";
    public static final String unlocalizedName = "modular_shield";
    public static final String bannerImprovementKey = "shield/banner";
    @ObjectHolder(value="tetra:modular_shield")
    public static ModularShieldItem instance;

    public ModularShieldItem() {
        super(new Item.Properties().func_200917_a(1).setISTER(() -> ModularShieldISTER::new));
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{plateKey, gripKey};
        this.minorModuleKeys = new String[]{bossKey};
        this.requiredModules = new String[]{plateKey, gripKey};
        this.speedBase = 0.0;
        this.updateConfig((Integer)ConfigHandler.honeShieldBase.get(), (Integer)ConfigHandler.honeShieldIntegrityMultiplier.get());
        SchemaRegistry.instance.registerSchema(new RepairSchema(this));
        SchemaRegistry.instance.registerSchema(new ApplyBannerSchema());
        RemoveSchema.registerRemoveSchemas(this);
        ItemUpgradeRegistry.instance.registerReplacementHook(this::copyBanner);
        this.func_185043_a(new ResourceLocation("blocking"), (itemStack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    private ItemStack copyBanner(ItemStack original, ItemStack replacement) {
        if (this.equals(replacement.func_77973_b())) {
            Optional.ofNullable(original.func_179543_a("BlockEntityTag")).ifPresent(tag -> {
                NBTHelper.getTag(replacement).func_218657_a("BlockEntityTag", (INBT)tag);
                CastOptional.cast(this.getModuleFromSlot(replacement, plateKey), ItemModuleMajor.class).filter(module -> module.acceptsImprovement(bannerImprovementKey)).ifPresent(module -> module.addImprovement(replacement, bannerImprovementKey, 0));
            });
        }
        return replacement;
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        Multimap<String, AttributeModifier> modifiers = super.getAttributeModifiers(slot, itemStack);
        modifiers.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
        modifiers.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        return modifiers;
    }

    @Override
    public double getCooldownBase(ItemStack itemStack) {
        return this.getSpeedModifier(itemStack);
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new BlockProgressOverlay(Minecraft.func_71410_x()));
    }
}

