/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.network.AbstractPacket;

public class EquipToolbeltItemPacket
extends AbstractPacket {
    private ToolbeltSlotType slotType;
    private int toolbeltItemIndex;
    private Hand hand;

    public EquipToolbeltItemPacket() {
    }

    public EquipToolbeltItemPacket(ToolbeltSlotType inventoryType, int toolbeltSlot, Hand hand) {
        this.slotType = inventoryType;
        this.toolbeltItemIndex = toolbeltSlot;
        this.hand = hand;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.slotType.ordinal());
        buffer.writeInt(this.hand.ordinal());
        buffer.writeInt(this.toolbeltItemIndex);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        int handOrdinal;
        int typeOrdinal = buffer.readInt();
        if (typeOrdinal < ToolbeltSlotType.values().length) {
            this.slotType = ToolbeltSlotType.values()[typeOrdinal];
        }
        if ((handOrdinal = buffer.readInt()) < Hand.values().length) {
            this.hand = Hand.values()[handOrdinal];
        }
        this.toolbeltItemIndex = buffer.readInt();
    }

    @Override
    public void handle(PlayerEntity player) {
        if (this.toolbeltItemIndex > -1) {
            ToolbeltHelper.equipItemFromToolbelt(player, this.slotType, this.toolbeltItemIndex, this.hand);
        } else {
            ToolbeltHelper.storeItemInToolbelt(player);
        }
    }
}

