/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.booster;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.booster.UtilBooster;

public class TickHandlerBooster {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack itemStack = ToolbeltHelper.findToolbelt(event.player);
        int level = UtilBooster.getBoosterLevel(itemStack);
        if (level > 0) {
            this.tickItem(event.player, itemStack, level);
        }
    }

    public void tickItem(PlayerEntity player, ItemStack stack, int level) {
        CompoundNBT tag = NBTHelper.getTag(stack);
        boolean charged = tag.func_74767_n("booster.charged");
        if (!player.func_70090_H() && UtilBooster.isActive(tag) && UtilBooster.hasFuel(tag, charged)) {
            if (charged) {
                UtilBooster.boostPlayerCharged(player, tag, level);
            } else {
                UtilBooster.boostPlayer(player, tag, level);
            }
            UtilBooster.consumeFuel(tag, charged);
        } else {
            UtilBooster.rechargeFuel(tag, stack);
        }
        if (charged) {
            tag.func_74757_a("booster.charged", false);
        }
    }
}

