/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ModularItem;

public class FortuneBonusCondition
implements ILootCondition {
    private float chance;
    private float fortuneMultiplier;
    private Capability requiredCapability;
    private int capabilityLevel = -1;

    public boolean test(LootContext context) {
        int fortuneLevel = 0;
        if (this.requiredCapability != null) {
            ItemStack toolStack = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (toolStack != null && toolStack.func_77973_b() instanceof ModularItem && ((ModularItem)toolStack.func_77973_b()).getCapabilityLevel(toolStack, this.requiredCapability) > this.capabilityLevel) {
                fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)toolStack);
            }
        } else {
            fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((ItemStack)context.func_216031_c(LootParameters.field_216289_i)));
        }
        return context.func_216032_b().nextFloat() < this.chance + (float)fortuneLevel * this.fortuneMultiplier;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<FortuneBonusCondition> {
        public Serializer() {
            super(new ResourceLocation("tetra:random_chance_with_fortune"), FortuneBonusCondition.class);
        }

        public void serialize(JsonObject json, FortuneBonusCondition value, JsonSerializationContext context) {
            DataManager.gson.toJsonTree((Object)value).getAsJsonObject().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }

        public FortuneBonusCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return (FortuneBonusCondition)DataManager.gson.fromJson((JsonElement)json, FortuneBonusCondition.class);
        }
    }
}

