/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchemaRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.BaseSchema;
import se.mickelus.tetra.module.schema.SchemaType;

public class RemoveSchema
extends BaseSchema {
    private static final String localizationPrefix = "tetra/schema/";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private String key = "remove";
    private ModularItem item;
    private String slot;
    private GlyphData glyph = new GlyphData(GuiTextures.workbench, 52, 32);

    public RemoveSchema(ModularItem item, String slot) {
        this.item = item;
        this.slot = slot;
    }

    public static void registerRemoveSchemas(ModularItem item) {
        Stream.concat(Arrays.stream(item.getMajorModuleKeys()), Arrays.stream(item.getMinorModuleKeys())).filter(slot -> !item.isModuleRequired((String)slot)).forEach(slot -> {
            RemoveSchema schema = new RemoveSchema(item, (String)slot);
            SchemaRegistry.instance.registerSchema(schema);
        });
    }

    @Override
    public String getKey() {
        return this.key + "/" + this.item.getRegistryName().func_110623_a() + "/" + this.slot;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)(localizationPrefix + this.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)(localizationPrefix + this.key + descriptionSuffix), (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 0;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return "";
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 0;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        return false;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return this.item.getClass().isInstance(itemStack.func_77973_b());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return this.slot.equals(slot) && this.item.getModuleFromSlot(targetStack, this.slot) != null;
    }

    @Override
    public boolean canApplyUpgrade(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot, int[] availableCapabilities) {
        return !this.isIntegrityViolation(player, itemStack, materials, slot) && this.checkCapabilities(itemStack, materials, availableCapabilities);
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return true;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        ModularItem item = (ModularItem)itemStack.func_77973_b();
        float durabilityFactor = 0.0f;
        if (consumeMaterials && upgradedStack.func_77984_f()) {
            durabilityFactor = (float)upgradedStack.func_77952_i() * 1.0f / (float)upgradedStack.func_77958_k();
        }
        float honingFactor = Math.min(Math.max(1.0f * (float)item.getHoningProgress(upgradedStack) / (float)item.getHoningBase(upgradedStack), 0.0f), 1.0f);
        ItemModule previousModule = item.getModuleFromSlot(upgradedStack, slot);
        if (previousModule != null) {
            previousModule.removeModule(upgradedStack);
            if (consumeMaterials) {
                previousModule.postRemove(upgradedStack, player);
            }
        }
        if (consumeMaterials) {
            if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && ModularItem.isHoneable(upgradedStack)) {
                item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (float)item.getHoningBase(upgradedStack)));
            }
            if (upgradedStack.func_77984_f()) {
                upgradedStack.func_196085_b((int)(durabilityFactor * (float)upgradedStack.func_77958_k()));
            }
        }
        return upgradedStack;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        return Collections.singletonList(Capability.hammer);
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        if (capability == Capability.hammer) {
            return 1;
        }
        return 0;
    }

    @Override
    public SchemaType getType() {
        return SchemaType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }
}

