/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.ItemPredicate;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.OutcomeDefinition;
import se.mickelus.tetra.module.schema.SchemaRarity;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.util.Filter;

public class SchemaDefinition {
    public boolean replace = false;
    public String localizationKey;
    public String[] slots = new String[0];
    public String[] keySuffixes = new String[0];
    public int materialSlotCount = 0;
    public boolean repair = true;
    public boolean hone = false;
    public ItemPredicate requirement = ItemPredicate.field_192495_a;
    public int materialRevealSlot = -1;
    public SchemaType displayType = SchemaType.other;
    public SchemaRarity rarity = SchemaRarity.basic;
    public GlyphData glyph = new GlyphData();
    public OutcomeDefinition[] outcomes = new OutcomeDefinition[0];
    public String key;
    private static final SchemaDefinition defaultValues = new SchemaDefinition();

    public static void copyFields(SchemaDefinition from, SchemaDefinition to) {
        to.slots = (String[])Stream.concat(Arrays.stream(to.slots), Arrays.stream(from.slots)).distinct().toArray(String[]::new);
        to.keySuffixes = (String[])Stream.concat(Arrays.stream(to.keySuffixes), Arrays.stream(from.keySuffixes)).distinct().toArray(String[]::new);
        if (!Objects.equals(from.localizationKey, SchemaDefinition.defaultValues.localizationKey)) {
            to.localizationKey = from.localizationKey;
        }
        if (from.materialSlotCount != SchemaDefinition.defaultValues.materialSlotCount) {
            to.materialSlotCount = from.materialSlotCount;
        }
        if (from.repair != SchemaDefinition.defaultValues.repair) {
            to.repair = from.repair;
        }
        if (from.hone != SchemaDefinition.defaultValues.hone) {
            to.hone = from.hone;
        }
        if (!from.requirement.equals(SchemaDefinition.defaultValues.requirement)) {
            to.requirement = from.requirement;
        }
        if (from.materialRevealSlot != SchemaDefinition.defaultValues.materialRevealSlot) {
            to.materialRevealSlot = from.materialRevealSlot;
        }
        if (from.displayType != SchemaDefinition.defaultValues.displayType) {
            to.displayType = from.displayType;
        }
        if (from.rarity != SchemaDefinition.defaultValues.rarity) {
            to.rarity = from.rarity;
        }
        if (!from.glyph.equals(SchemaDefinition.defaultValues.glyph)) {
            to.glyph = from.glyph;
        }
        to.outcomes = (OutcomeDefinition[])Stream.concat(Arrays.stream(to.outcomes), Arrays.stream(from.outcomes)).filter(Filter.distinct(outcome -> outcome.material)).toArray(OutcomeDefinition[]::new);
    }
}

