/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight;

import com.google.common.reflect.Reflection;
import com.mushroom.midnight.client.ClientProxy;
import com.mushroom.midnight.client.model.MidnightModelRegistry;
import com.mushroom.midnight.common.ServerProxy;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.capability.NullStorage;
import com.mushroom.midnight.common.capability.RiftTraveller;
import com.mushroom.midnight.common.capability.RiftTravellerStorage;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.compatibility.MidnightTerraforgedCompat;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.data.loot.MidnightBlockLootProvider;
import com.mushroom.midnight.common.data.recipe.MidnightDecorativeRecipes;
import com.mushroom.midnight.common.data.recipe.MidnightFabricatedRecipes;
import com.mushroom.midnight.common.data.recipe.MidnightFoodRecipes;
import com.mushroom.midnight.common.data.recipe.MidnightMaterialRecipes;
import com.mushroom.midnight.common.data.recipe.MidnightPlantRecipes;
import com.mushroom.midnight.common.data.recipe.MidnightStoneRecipes;
import com.mushroom.midnight.common.data.recipe.MidnightWoodenRecipes;
import com.mushroom.midnight.common.data.tag.MidnightBlockTagsProvider;
import com.mushroom.midnight.common.data.tag.MidnightFluidTagsProvider;
import com.mushroom.midnight.common.data.tag.MidnightItemTagsProvider;
import com.mushroom.midnight.common.loot.InBiomeLootCondition;
import com.mushroom.midnight.common.loot.InBlockLootCondition;
import com.mushroom.midnight.common.loot.IsChildLootCondition;
import com.mushroom.midnight.common.network.AnimationMessage;
import com.mushroom.midnight.common.network.CaptureEntityMessage;
import com.mushroom.midnight.common.network.ItemActivationMessage;
import com.mushroom.midnight.common.network.RockshroomBrokenMessage;
import com.mushroom.midnight.common.registry.MidnightCavernousBiomes;
import com.mushroom.midnight.common.registry.MidnightCriterion;
import com.mushroom.midnight.common.registry.MidnightGameRules;
import com.mushroom.midnight.common.registry.MidnightItemGroups;
import com.mushroom.midnight.common.registry.MidnightRecipeTypes;
import com.mushroom.midnight.common.registry.MidnightStructures;
import com.mushroom.midnight.common.registry.MidnightSurfaceBiomes;
import com.mushroom.midnight.common.registry.RegUtil;
import com.mushroom.midnight.common.util.EntityUtil;
import com.mushroom.midnight.common.util.IProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="midnight")
@Mod.EventBusSubscriber(modid="midnight")
public class Midnight {
    public static final String MODID = "midnight";
    public static final String VERSION = "0.5.11";
    public static final String NETWORK_PROTOCOL = "2";
    public static final Logger LOGGER = LogManager.getLogger(Midnight.class);
    public static final IProxy PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final String REWRITE_NOTIFICATION = "The Midnight: Rewritten is now available for download! Visit The Midnight's CurseForge page for more information. You can disable this notification in the configuration settings.";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("midnight", "net")).networkProtocolVersion(() -> "2").clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).simpleChannel();
    public static final EntityClassification MIDNIGHT_MOB = EntityClassification.create((String)"midnight_mob", (String)"midnight_mob", (int)10, (boolean)false, (boolean)false);
    public static final EntityClassification MIDNIGHT_AMBIENT = EntityClassification.create((String)"midnight_ambient", (String)"midnight_ambient", (int)30, (boolean)true, (boolean)false);
    @CapabilityInject(value=RiftTraveller.class)
    public static final Capability<RiftTraveller> RIFT_TRAVELLER_CAP = (Capability)RegUtil.injected();
    @CapabilityInject(value=RifterCapturable.class)
    public static final Capability<RifterCapturable> RIFTER_CAPTURABLE_CAP = (Capability)RegUtil.injected();
    @CapabilityInject(value=AnimationCapability.class)
    public static final Capability<AnimationCapability> ANIMATION_CAP = (Capability)RegUtil.injected();

    public Midnight() {
        this.printVersion();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MidnightConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MidnightConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, MidnightConfig.SERVER_SPEC);
        this.setupMessages();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::setup));
        bus.addListener(this::setup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::registerModels);
        bus.addListener(this::gatherData);
        PROXY.onConstruct();
    }

    private void printVersion() {
        LOGGER.info("Initializing The Midnight");
        LOGGER.info(" - Version: 0.5.11");
        LOGGER.info(" - Dist: " + FMLEnvironment.dist);
    }

    public static boolean isRewriteAvailable() {
        try {
            URL rewriteUrl = new URL("https://beta.crypticmushroom.com/rewrite.txt");
            HttpURLConnection connection = (HttpURLConnection)rewriteUrl.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader rewriteCheckDocument = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            return Boolean.parseBoolean(rewriteCheckDocument.readLine());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Unable to check if The Midnight: Rewritten is available for download! Please report this to The Midnight's issue tracker.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Unable to check if The Midnight: Rewritten is available for download! You are probably offline.", (Throwable)e);
        }
        return false;
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(RiftTraveller.class, new RiftTravellerStorage(), RiftTraveller::new);
        CapabilityManager.INSTANCE.register(RifterCapturable.class, new NullStorage(), RifterCapturable::new);
        CapabilityManager.INSTANCE.register(AnimationCapability.class, new NullStorage(), AnimationCapability::new);
        Reflection.initialize((Class[])new Class[]{MidnightCriterion.class, MidnightItemGroups.class, MidnightGameRules.class});
        EntityUtil.register();
        MidnightRecipeTypes.init();
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new InBiomeLootCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new InBlockLootCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new IsChildLootCondition.Serializer());
        Midnight.setupWorldGen();
        if (ModList.get().isLoaded("terraforged")) {
            MinecraftForge.EVENT_BUS.register((Object)new MidnightTerraforgedCompat());
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        Midnight.setupEntranceRift();
    }

    private void setupMessages() {
        CHANNEL.messageBuilder(CaptureEntityMessage.class, 0).encoder(CaptureEntityMessage::serialize).decoder(CaptureEntityMessage::deserialize).consumer(CaptureEntityMessage::handle).add();
        CHANNEL.messageBuilder(AnimationMessage.class, 1).encoder(AnimationMessage::serialize).decoder(AnimationMessage::deserialize).consumer(AnimationMessage::handle).add();
        CHANNEL.messageBuilder(RockshroomBrokenMessage.class, 2).encoder(RockshroomBrokenMessage::serialize).decoder(RockshroomBrokenMessage::deserialize).consumer(RockshroomBrokenMessage::handle).add();
        CHANNEL.messageBuilder(ItemActivationMessage.class, 3).encoder(ItemActivationMessage::serialize).decoder(ItemActivationMessage::deserialize).consumer(ItemActivationMessage::handle).add();
    }

    private static void setupWorldGen() {
        MidnightSurfaceBiomes.onInit();
        MidnightCavernousBiomes.onInit();
    }

    public static void setupEntranceRift() {
        DeferredWorkQueue.runLater(() -> {
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                biome.func_226711_a_(MidnightStructures.ENTRANCE_RIFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightStructures.ENTRANCE_RIFT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                LOGGER.debug("Adding rifts to biome: " + biome.getRegistryName());
            }
        });
    }

    private void registerModels(ModelRegistryEvent event) {
        MidnightModelRegistry.registerModels(event);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new MidnightBlockTagsProvider(generator));
            generator.func_200390_a((IDataProvider)new MidnightFluidTagsProvider(generator));
            generator.func_200390_a((IDataProvider)new MidnightItemTagsProvider(generator));
            generator.func_200390_a((IDataProvider)new MidnightDecorativeRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightFabricatedRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightFoodRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightMaterialRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightPlantRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightStoneRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightWoodenRecipes(generator));
            generator.func_200390_a((IDataProvider)new MidnightBlockLootProvider(generator));
        }
    }
}

