/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.ClientProxy;
import com.mushroom.midnight.client.FluidImmersionRenderer;
import com.mushroom.midnight.client.MidnightKeybinds;
import com.mushroom.midnight.client.gui.config.ConfigInterfaceScreen;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.registry.MidnightEffects;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.registry.MidnightSurfaceBiomes;
import com.mushroom.midnight.common.util.EntityUtil;
import com.mushroom.midnight.common.util.MidnightUtil;
import com.mushroom.midnight.common.util.ResetHookHandler;
import com.mushroom.midnight.common.world.MidnightAtmosphereController;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="midnight", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final double HOOK_SENSITIVITY = 0.2;
    private static final ResetHookHandler<Double> SENSITIVITY_HOOK = new ResetHookHandler<Double>(0.2).getValue(() -> ClientEventHandler.CLIENT.field_71474_y.field_74341_c).setValue(sensitivity -> {
        ClientEventHandler.CLIENT.field_71474_y.field_74341_c = sensitivity;
    });
    private static final long AMBIENT_SOUND_INTERVAL = 140L;
    private static final int AMBIENT_SOUND_CHANCE = 120;
    private static boolean hasGivenRewriteNotification = false;
    private static long lastAmbientSoundTime;
    private static ISound playingMusic;
    public static float flicker;
    public static float prevFlicker;
    private static CreateWorldScreen currentCreateWorldScreen;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            prevFlicker = flicker;
            double targetFlicker = Math.random();
            targetFlicker *= targetFlicker;
            flicker = (float)((double)flicker + (targetFlicker - (double)flicker) * 0.5);
        }
        if (MidnightKeybinds.MIDNIGHT_CONFIG.getKey().func_197937_c() > -1 && InputMappings.func_216506_a((long)CLIENT.func_228018_at_().func_198092_i(), (int)MidnightKeybinds.MIDNIGHT_CONFIG.getKey().func_197937_c()) && MidnightKeybinds.MIDNIGHT_CONFIG.getKeyModifier().isActive(MidnightKeybinds.MIDNIGHT_CONFIG.getKeyConflictContext())) {
            if (ClientEventHandler.CLIENT.field_71462_r instanceof IngameMenuScreen) {
                CLIENT.func_147108_a((Screen)new ConfigInterfaceScreen(ClientEventHandler.CLIENT.field_71462_r, MidnightConfig.MAIN_IFC.makeInterface(MidnightConfig.PROFILE)));
            } else if (ClientEventHandler.CLIENT.field_71462_r != null && ClientEventHandler.CLIENT.field_71462_r == currentCreateWorldScreen) {
                CLIENT.func_147108_a((Screen)new ConfigInterfaceScreen(ClientEventHandler.CLIENT.field_71462_r, MidnightConfig.SERVER_IFC.makeInterface(ClientProxy.worldSetupConfig)));
            }
        }
        if (!CLIENT.func_147113_T()) {
            ClientPlayerEntity player = ClientEventHandler.CLIENT.field_71439_g;
            if (player == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                if (playingMusic != null && !CLIENT.func_147118_V().func_215294_c(playingMusic)) {
                    playingMusic = null;
                }
                if (MidnightUtil.isMidnightDimension(player.field_70170_p)) {
                    ClientEventHandler.spawnAmbientParticles((PlayerEntity)player);
                    ClientEventHandler.playAmbientSounds((PlayerEntity)player);
                }
                SENSITIVITY_HOOK.apply(player.func_70644_a(MidnightEffects.STUNNED));
            }
        }
    }

    @SubscribeEvent
    public static void loggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
        ClientPlayerEntity player = event.getPlayer();
        if (Midnight.isRewriteAvailable() && player != null && !hasGivenRewriteNotification && ((Boolean)MidnightConfig.client.checkForRewrite.get()).booleanValue()) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(new TranslationTextComponent("The Midnight: Rewritten is now available for download! Visit The Midnight's CurseForge page for more information. You can disable this notification in the configuration settings.", new Object[0]).func_211708_a(TextFormatting.GREEN));
            hasGivenRewriteNotification = true;
        }
    }

    private static void cancelSleep(ClientPlayerEntity player) {
        ClientPlayNetHandler handler = player.field_71174_a;
        handler.func_147297_a((IPacket)new CEntityActionPacket((Entity)player, CEntityActionPacket.Action.STOP_SLEEPING));
    }

    private static void playAmbientSounds(PlayerEntity player) {
        Random rand = player.field_70170_p.field_73012_v;
        long worldTime = player.field_70170_p.func_82737_E();
        if (worldTime - lastAmbientSoundTime > 140L && rand.nextInt(120) == 0) {
            ResourceLocation ambientSound = MidnightSounds.AMBIENT.func_187503_a();
            float volume = (rand.nextFloat() * 0.4f + 0.8f) * ((Double)MidnightConfig.client.ambientVolume.get()).floatValue();
            float pitch = rand.nextFloat() * 0.6f + 0.7f;
            float x = (float)(player.func_226277_ct_() + (double)rand.nextFloat() - 0.5);
            float y = (float)(player.func_226278_cu_() + (double)rand.nextFloat() - 0.5);
            float z = (float)(player.func_226281_cx_() + (double)rand.nextFloat() - 0.5);
            SimpleSound sound = new SimpleSound(ambientSound, SoundCategory.AMBIENT, volume, pitch, false, 0, ISound.AttenuationType.NONE, x, y, z, false);
            CLIENT.func_147118_V().func_147682_a((ISound)sound);
            lastAmbientSoundTime = worldTime;
        }
    }

    @SubscribeEvent
    public static void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Entity entity = event.getInfo().func_216773_g();
        if (MidnightUtil.isMidnightDimension(entity.field_70170_p)) {
            float farDistance = event.getFarPlaneDistance();
            float fogStart = (float)MidnightAtmosphereController.INSTANCE.getFogStart();
            float fogEnd = (float)MidnightAtmosphereController.INSTANCE.getFogEnd();
            GlStateManager.func_227671_b_((float)Math.min(fogStart, farDistance));
            GlStateManager.func_227687_c_((float)Math.min(fogEnd, farDistance));
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        LivingEntity entity;
        if (!FluidImmersionRenderer.immersedFluid.func_206888_e()) {
            return;
        }
        LivingEntity livingEntity = entity = event.getInfo().func_216773_g() instanceof LivingEntity ? (LivingEntity)event.getInfo().func_216773_g() : null;
        if (entity != null && !entity.func_70644_a(Effects.field_76440_q)) {
            if (entity.func_70644_a(MidnightEffects.DARKNESS)) {
                RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setCanceled(true);
                event.setDensity(0.15f);
            } else if (entity.func_70644_a(MidnightEffects.STUNNED)) {
                RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setCanceled(true);
                event.setDensity(0.15f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSetupFogColor(EntityViewRenderEvent.FogColors event) {
        if (event.getInfo().func_216773_g() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)event.getInfo().func_216773_g();
            if (entity.func_70644_a(MidnightEffects.STUNNED)) {
                event.setRed(0.1f);
                event.setGreen(0.1f);
                event.setBlue(0.1f);
            } else if (entity.func_70644_a(MidnightEffects.DARKNESS)) {
                event.setRed(0.0f);
                event.setGreen(0.0f);
                event.setBlue(0.0f);
            }
        }
    }

    private static void spawnAmbientParticles(PlayerEntity player) {
        if (!((Boolean)MidnightConfig.client.ambientSporeParticles.get()).booleanValue()) {
            return;
        }
        Random random = player.field_70170_p.field_73012_v;
        double originX = player.func_226277_ct_();
        double originY = player.func_226278_cu_();
        double originZ = player.func_226281_cx_();
        for (int i = 0; i < 6; ++i) {
            double particleX = originX + (double)(random.nextInt(24) - random.nextInt(24));
            double particleY = originY + (double)(random.nextInt(24) - random.nextInt(24));
            double particleZ = originZ + (double)(random.nextInt(24) - random.nextInt(24));
            double velocityX = (random.nextDouble() - 0.5) * 0.04;
            double velocityY = (random.nextDouble() - 0.5) * 0.04;
            double velocityZ = (random.nextDouble() - 0.5) * 0.04;
            player.field_70170_p.func_195594_a((IParticleData)MidnightParticleTypes.AMBIENT_SPORE, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
        }
    }

    public static void onApplyRotations(LivingEntity entity, MatrixStack matrixStack) {
        boolean captured = RifterCapturable.isCaptured((Entity)entity);
        if (captured) {
            entity.field_184619_aG = 0.0f;
            entity.field_184618_aE = 0.0f;
            entity.field_70721_aZ = 0.0f;
            EntityUtil.Stance stance = EntityUtil.getStance(entity);
            if (stance == EntityUtil.Stance.QUADRUPEDAL) {
                matrixStack.func_227861_a_(0.0, (double)entity.func_213302_cg(), 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            } else {
                matrixStack.func_227861_a_(0.0, (double)(entity.func_213311_cf() / 2.0f), 0.0);
                matrixStack.func_227861_a_(0.0, 0.0, (double)(entity.func_213302_cg() / 2.0f));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        if (!ClientEventHandler.isMusicSound()) {
            return;
        }
        if (ClientEventHandler.CLIENT.field_71439_g != null && MidnightUtil.isMidnightDimension(ClientEventHandler.CLIENT.field_71439_g.field_70170_p)) {
            SoundEvent sound = ClientEventHandler.getMusicSound((PlayerEntity)ClientEventHandler.CLIENT.field_71439_g);
            if (sound == null || playingMusic != null) {
                event.setResultSound(null);
                return;
            }
            playingMusic = SimpleSound.func_184370_a((SoundEvent)sound);
            event.setResultSound(playingMusic);
        }
    }

    @Nullable
    private static SoundEvent getMusicSound(PlayerEntity player) {
        Biome biome = player.field_70170_p.func_226691_t_(player.func_180425_c());
        if (biome == MidnightSurfaceBiomes.CRYSTAL_SPIRES) {
            return MidnightSounds.MUSIC_CRYSTAL;
        }
        if (biome == MidnightSurfaceBiomes.DECEITFUL_BOG) {
            return MidnightSounds.MUSIC_DARK_WILLOW;
        }
        return MidnightSounds.MUSIC_GENERIC;
    }

    private static boolean isMusicSound() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTrace).anyMatch(e -> e.getClassName().equals(MusicTicker.class.getName()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderVignetteOverLay(RenderGameOverlayEvent.Pre event) {
        if (((Boolean)MidnightConfig.client.hideVignetteEffect.get()).booleanValue() && event.getType() == RenderGameOverlayEvent.ElementType.VIGNETTE && MidnightUtil.isMidnightDimension((World)ClientEventHandler.CLIENT.field_71441_e)) {
            WorldBorder worldborder = ClientEventHandler.CLIENT.field_71441_e.func_175723_af();
            float distWarn = Math.max((float)worldborder.func_177748_q(), (float)Math.min(worldborder.func_177749_o() * (double)worldborder.func_177740_p() * 1000.0, Math.abs(worldborder.func_177751_j() - worldborder.func_177741_h())));
            if (worldborder.func_177745_a((Entity)ClientEventHandler.CLIENT.field_71439_g) >= (double)distWarn) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onOpenGUIScreen(GuiOpenEvent event) {
        if (event.getGui() instanceof CreateWorldScreen && event.getGui() != currentCreateWorldScreen) {
            currentCreateWorldScreen = (CreateWorldScreen)event.getGui();
            ClientProxy.worldSetupConfig = MidnightConfig.SERVER_PROFILE.makeTempProvider();
        }
    }

    @SubscribeEvent
    public static void serverStartingEvent(FMLServerStartingEvent event) {
        MidnightConfig.update();
    }
}

