/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.util.MidnightUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.world.World;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

public final class SoundReverbHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static boolean available;
    private static boolean setup;
    private static int auxEffectSlot;

    public static void onPlaySound(int soundId) {
        if (!setup) {
            SoundReverbHandler.setupEffects();
            setup = true;
        }
        if ((Double)MidnightConfig.client.echoVolume.get() > 0.0 && available && SoundReverbHandler.shouldEcho((World)SoundReverbHandler.MC.field_71441_e)) {
            AL11.alSource3i((int)soundId, (int)131078, (int)auxEffectSlot, (int)0, (int)0);
        }
    }

    private static void setupEffects() {
        available = AL.getCapabilities().ALC_EXT_EFX;
        if (!available) {
            Midnight.LOGGER.warn("Unable to setup reverb effects, AL EFX not supported!");
            return;
        }
        auxEffectSlot = EXTEfx.alGenAuxiliaryEffectSlots();
        EXTEfx.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)3, (int)1);
        EXTEfx.alAuxiliaryEffectSlotf((int)auxEffectSlot, (int)2, (float)((Double)MidnightConfig.client.echoVolume.get()).floatValue());
        int reverbEffectSlot = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverbEffectSlot, (int)32769, (int)32768);
        EXTEfx.alEffectf((int)reverbEffectSlot, (int)6, (float)6.0f);
        EXTEfx.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)1, (int)reverbEffectSlot);
    }

    private static boolean shouldEcho(World world) {
        return MidnightUtil.isMidnightDimension(world);
    }

    static {
        ((IReloadableResourceManager)MC.func_195551_G()).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
            setup = false;
        }));
    }
}

