/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.gui.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mushroom.midnight.client.gui.config.ListConfigOptionList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ConfigListScreen<T>
extends Screen {
    public static final ResourceLocation MN_BACKGROUND_LOCATION = new ResourceLocation("midnight:textures/gui/config_background.png");
    private final Screen previousScreen;
    protected final ListConfigOptionList<T> list;
    private final Button doneButton;
    private final Button cancelButton;

    public ConfigListScreen(Screen previousScreen, ITextComponent title, List<T> entries, Function<ListConfigOptionList.Value<T>, Widget> widgetFactory, Supplier<T> defaultValue, Consumer<List<T>> handler) {
        super(title);
        this.previousScreen = previousScreen;
        this.list = new ListConfigOptionList<T>(Minecraft.func_71410_x(), this.width, this.height, 32, this.height - 32, 24, entries, widgetFactory, defaultValue);
        this.doneButton = new Button(0, 0, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            handler.accept(this.list.collect());
            this.onClose();
        });
        this.cancelButton = new Button(0, 0, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.onClose());
    }

    protected void init() {
        this.children.add(this.list);
        this.list.updateSize(this.width, this.height, 32, this.height - 32);
        this.cancelButton.x = this.width / 2 - 155;
        this.cancelButton.x = this.width / 2 - 155;
        this.cancelButton.y = this.height - 26;
        this.addButton((Widget)this.cancelButton);
        this.doneButton.x = this.width / 2 + 5;
        this.doneButton.y = this.height - 26;
        this.addButton((Widget)this.doneButton);
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.previousScreen);
    }

    public void render(int mx, int my, float partialTicks) {
        this.renderDirtBackground(0);
        this.list.render(mx, my, partialTicks);
        super.render(mx, my, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 16, -1);
    }

    public void renderDirtBackground(int yOffset) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(MN_BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_(0.0, (double)this.height, 0.0).func_225583_a_(0.0f, (float)this.height / 32.0f + (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        buff.func_225582_a_((double)this.width, (double)this.height, 0.0).func_225583_a_((float)this.width / 32.0f, (float)this.height / 32.0f + (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        buff.func_225582_a_((double)this.width, 0.0, 0.0).func_225583_a_((float)this.width / 32.0f, (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        buff.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tess.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
    }
}

