/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.SkyRenderHandler;

public final class MidnightSkyRenderer
implements SkyRenderHandler {
    public static final MidnightSkyRenderer INSTANCE = new MidnightSkyRenderer();
    private static final float DARKNESS_RED = 0.056862745f;
    private static final float DARKNESS_GREEN = 0.03137255f;
    private static final float DARKNESS_BLUE = 0.078431375f;
    private static final VertexFormat FORMAT = DefaultVertexFormats.field_181706_f;
    private static final int RESOLUTION = 8;
    private static final int HALF_RESOLUTION = 4;
    private static final double RADIUS = 100.0;
    private static final double UNIT = 25.0;
    private VertexBuffer gradientVbo;

    private MidnightSkyRenderer() {
    }

    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft client) {
        this.generateVbos();
        GlStateManager.func_227667_a_((boolean)false);
        GlStateManager.func_227621_I_();
        RenderHelper.func_74518_a();
        GlStateManager.func_227740_m_();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableFog();
        RenderSystem.shadeModel((int)7425);
        this.gradientVbo.func_177359_a();
        int stride = FORMAT.func_177338_f();
        GlStateManager.func_227770_y_((int)32884);
        GlStateManager.func_227679_b_((int)3, (int)5126, (int)stride, (long)0L);
        GlStateManager.func_227770_y_((int)32886);
        GlStateManager.func_227694_c_((int)4, (int)5121, (int)stride, (long)12L);
        this.gradientVbo.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        GlStateManager.func_227772_z_((int)32884);
        GlStateManager.func_227772_z_((int)32886);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227667_a_((boolean)true);
    }

    private void generateVbos() {
        if (this.gradientVbo == null) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            this.gradientVbo = new VertexBuffer(FORMAT);
            this.buildGradientVbo(builder);
            builder.func_178977_d();
            this.gradientVbo.func_227875_a_(builder);
            builder.func_178965_a();
        }
    }

    private void buildGradientVbo(BufferBuilder builder) {
        builder.func_181668_a(7, FORMAT);
        MidnightSkyRenderer.buildGradientFaceX(builder, -4, false);
        MidnightSkyRenderer.buildGradientFaceX(builder, 4, true);
        MidnightSkyRenderer.buildGradientFaceY(builder, -4, true);
        MidnightSkyRenderer.buildGradientFaceY(builder, 4, false);
        MidnightSkyRenderer.buildGradientFaceZ(builder, -4, false);
        MidnightSkyRenderer.buildGradientFaceZ(builder, 4, true);
    }

    private static void buildGradientFaceX(BufferBuilder builder, int ux, boolean reverse) {
        for (int uy = -4; uy < 4; ++uy) {
            for (int uz = -4; uz < 4; ++uz) {
                MidnightSkyRenderer.addGradientVertices(builder, reverse, new int[]{ux, uy, uz, ux, uy + 1, uz, ux, uy + 1, uz + 1, ux, uy, uz + 1});
            }
        }
    }

    private static void buildGradientFaceY(BufferBuilder builder, int uy, boolean reverse) {
        for (int ux = -4; ux < 4; ++ux) {
            for (int uz = -4; uz < 4; ++uz) {
                MidnightSkyRenderer.addGradientVertices(builder, reverse, new int[]{ux, uy, uz, ux + 1, uy, uz, ux + 1, uy, uz + 1, ux, uy, uz + 1});
            }
        }
    }

    private static void buildGradientFaceZ(BufferBuilder builder, int uz, boolean reverse) {
        for (int ux = -4; ux < 4; ++ux) {
            for (int uy = -4; uy < 4; ++uy) {
                MidnightSkyRenderer.addGradientVertices(builder, reverse, new int[]{ux, uy, uz, ux + 1, uy, uz, ux + 1, uy + 1, uz, ux, uy + 1, uz});
            }
        }
    }

    private static void addGradientVertices(BufferBuilder builder, boolean reverse, int[] vertices) {
        if (reverse) {
            for (int i = vertices.length - 3; i >= 0; i -= 3) {
                MidnightSkyRenderer.addGradientVertex(builder, vertices[i], vertices[i + 1], vertices[i + 2]);
            }
        } else {
            for (int i = 0; i < vertices.length; i += 3) {
                MidnightSkyRenderer.addGradientVertex(builder, vertices[i], vertices[i + 1], vertices[i + 2]);
            }
        }
    }

    private static void addGradientVertex(BufferBuilder builder, int ux, int uy, int uz) {
        double x = (double)ux * 25.0;
        double y = (double)uy * 25.0;
        double z = (double)uz * 25.0;
        float alpha = MidnightSkyRenderer.sampleGradient(x, y, z);
        builder.func_225582_a_(x, y, z).func_227885_a_(0.056862745f, 0.03137255f, 0.078431375f, alpha).func_181675_d();
    }

    private static float sampleGradient(double x, double y, double z) {
        double length = Math.sqrt(x * x + y * y + z * z);
        return MathHelper.func_76131_a((float)((float)(y /= length) * 1.6f), (float)0.0f, (float)1.0f);
    }
}

