/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.google.common.collect.ImmutableMap;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.BiomeLayer;
import com.mushroom.midnight.common.biome.BiomeLayerType;
import com.mushroom.midnight.common.biome.BiomeLayers;
import com.mushroom.midnight.common.registry.MidnightSurfaceBiomes;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.world.biome.Biome;

public final class BiomeLayerRenderer {
    private static final ImmutableMap<Biome, Pattern> BIOME_PATTERNS = ImmutableMap.builder().put((Object)MidnightSurfaceBiomes.BLACK_RIDGE, (Object)Pattern.flat(new Color(0x303030))).put((Object)MidnightSurfaceBiomes.VIGILANT_FOREST, (Object)Pattern.flat(new Color(6905740))).put((Object)MidnightSurfaceBiomes.DECEITFUL_BOG, (Object)Pattern.flat(new Color(6048071))).put((Object)MidnightSurfaceBiomes.FUNGI_FOREST, (Object)Pattern.flat(new Color(4035956))).put((Object)MidnightSurfaceBiomes.OBSCURED_PEAKS, (Object)Pattern.checker(new Color(0x303030))).put((Object)MidnightSurfaceBiomes.WARPED_FIELDS, (Object)Pattern.flat(new Color(5658169))).put((Object)MidnightSurfaceBiomes.CRYSTAL_SPIRES, (Object)Pattern.flat(new Color(16751614))).put((Object)MidnightSurfaceBiomes.NIGHT_PLAINS, (Object)Pattern.flat(new Color(10469558))).put((Object)MidnightSurfaceBiomes.OBSCURED_PLATEAU, (Object)Pattern.flat(Color.BLACK)).put((Object)MidnightSurfaceBiomes.PHANTASMAL_VALLEY, (Object)Pattern.flat(new Color(5690319))).put((Object)MidnightSurfaceBiomes.RUNEBUSH_GROVE, (Object)Pattern.checker(new Color(3037294))).put((Object)MidnightSurfaceBiomes.HILLY_VIGILANT_FOREST, (Object)Pattern.checker(new Color(6905740))).put((Object)MidnightSurfaceBiomes.HILLY_FUNGI_FOREST, (Object)Pattern.checker(new Color(4035956))).build();

    public static void renderDebug() {
        try {
            Midnight.LOGGER.info("Rendering debug biome map");
            BiomeLayers<Biome> layers = BiomeLayerType.SURFACE.make(0L);
            BufferedImage image = new BufferedImage(512, 512, 1);
            BiomeLayerRenderer.renderLayer(layers.noise, image);
            ImageIO.write((RenderedImage)image, "png", new File("biome_debug.png"));
            System.exit(1);
        }
        catch (IOException e) {
            Midnight.LOGGER.error("Failed to output debug biome render", (Throwable)e);
        }
    }

    public static void renderLayer(BiomeLayer<Biome> layer, BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Biome biome = layer.sample(x, y);
                Pattern pattern = (Pattern)BIOME_PATTERNS.get((Object)biome);
                int color = pattern != null ? pattern.get(x, y) : 0xFFFFFF;
                image.setRGB(x, y, color);
            }
        }
    }

    public static interface Pattern {
        public int get(int var1, int var2);

        public static Pattern flat(Color color) {
            int rgb = color.getRGB();
            return (x, y) -> rgb;
        }

        public static Pattern checker(Color color) {
            int primary = color.getRGB();
            int secondary = color.darker().getRGB();
            return (x, y) -> (x / 2 + y / 2) % 2 == 0 ? primary : secondary;
        }
    }
}

