/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.common.biome.BiomeLayer;
import com.mushroom.midnight.common.biome.BiomeLayers;
import com.mushroom.midnight.common.biome.BiomeProcedure;
import com.mushroom.midnight.common.biome.MidnightBiomeGroup;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.registry.MidnightCavernousBiomes;
import com.mushroom.midnight.common.registry.MidnightSurfaceBiomes;
import com.mushroom.midnight.common.world.layer.AddHillsLayer;
import com.mushroom.midnight.common.world.layer.AddOutlineLayer;
import com.mushroom.midnight.common.world.layer.CavernSeedLayer;
import com.mushroom.midnight.common.world.layer.CellSeedLayer;
import com.mushroom.midnight.common.world.layer.CreateGroupPocketsLayer;
import com.mushroom.midnight.common.world.layer.EdgeMergeLayer;
import com.mushroom.midnight.common.world.layer.ProduceOutlineLayer;
import com.mushroom.midnight.common.world.layer.ReplaceRandomLayer;
import com.mushroom.midnight.common.world.layer.SeedGroupLayer;
import com.mushroom.midnight.common.world.layer.VoronoiZoomLayer;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.area.LazyArea;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public final class BiomeLayerType<T> {
    public static final BiomeLayerType<Biome> SURFACE = BiomeLayerType.create(Biome.class, BiomeLayerType::buildSurface, arg_0 -> ((Registry)Registry.field_212624_m).func_148745_a(arg_0), Biomes.field_180279_ad);
    public static final BiomeLayerType<CavernousBiome> UNDERGROUND = BiomeLayerType.create(CavernousBiome.class, BiomeLayerType::buildUnderground, MidnightCavernousBiomes::byId, MidnightCavernousBiomes.CLOSED_CAVERN);
    private static final int MAX_CACHE_SIZE = 25;
    private final Class<T> type;
    private final ProcedureFactory procedureFactory;
    private final IntFunction<T> function;
    private final T defaultValue;

    private BiomeLayerType(Class<T> type, ProcedureFactory procedureFactory, IntFunction<T> function, T defaultValue) {
        this.type = type;
        this.procedureFactory = procedureFactory;
        this.function = function;
        this.defaultValue = defaultValue;
    }

    public static <T> BiomeLayerType<T> create(Class<T> type, ProcedureFactory procedureFactory, IntFunction<T> function, T defaultValue) {
        return new BiomeLayerType<T>(type, procedureFactory, function, defaultValue);
    }

    public BiomeLayers<T> make(long worldSeed) {
        BiomeProcedure procedure = this.procedureFactory.create(value -> new LazyAreaLayerContext(25, worldSeed, value));
        return new BiomeLayers<T>(new BiomeLayer<T>(this.type, (LazyArea)procedure.noise, this.function, this.defaultValue), new BiomeLayer<T>(this.type, (LazyArea)procedure.block, this.function, this.defaultValue));
    }

    private static <A extends IArea, C extends IExtendedNoiseRandom<A>> BiomeProcedure<A> buildSurface(LongFunction<C> contextFactory) {
        int ridgeId = Registry.field_212624_m.func_148757_b((Object)MidnightSurfaceBiomes.BLACK_RIDGE);
        int plateauId = Registry.field_212624_m.func_148757_b((Object)MidnightSurfaceBiomes.OBSCURED_PLATEAU);
        int peakId = Registry.field_212624_m.func_148757_b((Object)MidnightSurfaceBiomes.OBSCURED_PEAKS);
        int valleyId = Registry.field_212624_m.func_148757_b((Object)MidnightSurfaceBiomes.PHANTASMAL_VALLEY);
        IAreaFactory ridgeLayer = BiomeLayerType.buildEdgeHighlightLayer(contextFactory, 100L);
        ridgeLayer = new ReplaceRandomLayer(0, 11).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(110L), ridgeLayer);
        IAreaFactory<A> valleyLayer = BiomeLayerType.buildEdgeHighlightLayer(contextFactory, 200L);
        IAreaFactory layer = new SeedGroupLayer(MidnightBiomeGroup.SURFACE).func_202823_a((IExtendedNoiseRandom)contextFactory.apply(0L));
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), layer);
        layer = new AddHillsLayer(MidnightBiomeGroup.SURFACE_HILLS, 5).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3000L), layer);
        layer = new CreateGroupPocketsLayer(MidnightBiomeGroup.SURFACE_POCKET).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(5000L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(6000L), layer);
        layer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(7000L), layer);
        layer = new EdgeMergeLayer(id -> id != plateauId && id != peakId, ridgeId).func_202707_a((IExtendedNoiseRandom)contextFactory.apply(8000L), layer, ridgeLayer);
        layer = LayerUtil.func_202829_a((long)9000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)layer, (int)2, contextFactory);
        layer = new EdgeMergeLayer(id -> id == plateauId, valleyId).func_202707_a((IExtendedNoiseRandom)contextFactory.apply(10000L), layer, valleyLayer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(11000L), layer);
        layer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(12000L), layer);
        return BiomeProcedure.of(layer, contextFactory);
    }

    private static <A extends IArea, C extends IExtendedNoiseRandom<A>> BiomeProcedure<A> buildUnderground(LongFunction<C> contextFactory) {
        int closedCavernId = MidnightCavernousBiomes.getId(MidnightCavernousBiomes.CLOSED_CAVERN);
        int fungalCavernId = MidnightCavernousBiomes.getId(MidnightCavernousBiomes.FUNGAL_CAVERN);
        IAreaFactory<A> passageLayer = BiomeLayerType.buildEdgeHighlightLayer(contextFactory, 300L);
        IAreaFactory layer = new CavernSeedLayer(MidnightBiomeGroup.UNDERGROUND).func_202823_a((IExtendedNoiseRandom)contextFactory.apply(0L));
        layer = VoronoiZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), layer);
        layer = new AddOutlineLayer(closedCavernId).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), layer);
        layer = new CreateGroupPocketsLayer(MidnightBiomeGroup.UNDERGROUND_POCKET).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3000L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(4000L), layer);
        layer = LayerUtil.func_202829_a((long)5000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)layer, (int)2, contextFactory);
        layer = new EdgeMergeLayer(id -> id == closedCavernId, fungalCavernId).func_202707_a((IExtendedNoiseRandom)contextFactory.apply(6000L), layer, passageLayer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(7000L), layer);
        layer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(8000L), layer);
        return BiomeProcedure.of(layer, contextFactory);
    }

    private static <A extends IArea, C extends IExtendedNoiseRandom<A>> IAreaFactory<A> buildEdgeHighlightLayer(LongFunction<C> contextFactory, long seed) {
        IAreaFactory valleyLayer = CellSeedLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(10L + seed));
        valleyLayer = VoronoiZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(20L + seed), valleyLayer);
        valleyLayer = LayerUtil.func_202829_a((long)(30L + seed), (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)valleyLayer, (int)2, contextFactory);
        valleyLayer = ProduceOutlineLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(40L + seed), valleyLayer);
        return valleyLayer;
    }

    public static interface ProcedureFactory {
        public <A extends IArea, C extends IExtendedNoiseRandom<A>> BiomeProcedure<A> create(LongFunction<C> var1);
    }
}

