/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.util.DirectionalShape;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class MidnightFungiShelfBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", f -> f != Direction.DOWN);
    private static final DirectionalShape BOUNDS = new DirectionalShape(1.0, 5.0, 15.0, 15.0, 11.0, 5.0);
    private static final VoxelShape VERTICAL_BOUNDS = MidnightFungiShelfBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);

    public MidnightFungiShelfBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos attachedPos = pos.func_177972_a(facing.func_176734_d());
        return Block.func_220056_d((BlockState)world.func_180495_p(attachedPos), (IBlockReader)world, (BlockPos)attachedPos, (Direction)facing);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_196000_l() == Direction.DOWN) {
            return null;
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d() == facing && !state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        if (facing == Direction.UP) {
            return VERTICAL_BOUNDS;
        }
        return BOUNDS.get(facing);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }
}

