/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.network.RockshroomBrokenMessage;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import com.mushroom.midnight.common.util.MidnightDamageSource;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class RockshroomBlock
extends Block {
    private static final int SPORE_COUNT = 32;
    private static final double SPORE_SPEED = 0.3;
    private static final double DAMAGE_RANGE = 4.0;
    private static final DamageSource ROCKSHROOM_SPORE = new MidnightDamageSource("rockshroom_spore");

    public RockshroomBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193567_S).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        boolean result = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        this.onBroken(world, pos, player);
        return result;
    }

    private void onBroken(World world, BlockPos pos, PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem) > 0) {
            return;
        }
        if (!world.field_72995_K) {
            RockshroomBrokenMessage message = new RockshroomBrokenMessage(pos);
            Midnight.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), (Object)message);
            this.damagePlayer(world, pos, player);
        }
    }

    private void damagePlayer(World world, BlockPos pos, PlayerEntity player) {
        Vec3d origin = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        Vec3d target = player.func_174824_e(1.0f);
        if (target.func_178788_d(origin).func_189985_c() > 16.0) {
            return;
        }
        RayTraceContext context = new RayTraceContext(origin, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
        BlockRayTraceResult rayTrace = world.func_217299_a(context);
        if (rayTrace.func_216346_c() == RayTraceResult.Type.MISS) {
            player.func_70097_a(ROCKSHROOM_SPORE, world.field_73012_v.nextFloat() * 3.5f + 0.5f);
        }
    }

    public void spawnSpores(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        for (int i = 0; i < 32; ++i) {
            Vec3d direction = new Vec3d((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f)).func_72432_b();
            double x = (double)pos.func_177958_n() + 0.5 + direction.field_72450_a * 0.4;
            double y = (double)pos.func_177956_o() + 0.5 + direction.field_72448_b * 0.4;
            double z = (double)pos.func_177952_p() + 0.5 + direction.field_72449_c * 0.4;
            Vec3d vel = direction.func_186678_a(0.3);
            world.func_195594_a((IParticleData)MidnightParticleTypes.SPORE, x, y, z, vel.field_72450_a, vel.field_72448_b + 0.05, vel.field_72449_c);
        }
    }
}

