/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.SoilBlock;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;

public class SpreadableSoilBlock
extends SoilBlock {
    private final Supplier<Block> groundSupplier;

    public SpreadableSoilBlock(Block.Properties properties, Supplier<Block> groundSupplier) {
        super(properties.func_200944_c(), true);
        this.groundSupplier = groundSupplier;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        BlockState aboveState;
        if (world.field_72995_K || !world.isAreaLoaded(pos, 3)) {
            return;
        }
        BlockPos abovePos = pos.func_177984_a();
        if (!MidnightUtil.isMidnightDimension((World)world) || LightEngine.func_215613_a((IBlockReader)world, (BlockState)state, (BlockPos)pos, (BlockState)(aboveState = world.func_180495_p(abovePos)), (BlockPos)abovePos, (Direction)Direction.UP, (int)aboveState.func_200016_a((IBlockReader)world, abovePos)) > 2) {
            world.func_175656_a(pos, this.groundSupplier.get().func_176223_P());
            return;
        }
        for (int i = 0; i < 4; ++i) {
            BlockState coverState;
            BlockPos spreadPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
            if (spreadPos.func_177956_o() >= 0 && spreadPos.func_177956_o() < 256 && !world.func_175667_e(spreadPos)) {
                return;
            }
            BlockState surfaceState = world.func_180495_p(spreadPos);
            if (surfaceState.func_177230_c() != this.groundSupplier.get() || (coverState = world.func_180495_p(spreadPos.func_177984_a())).func_200016_a((IBlockReader)world, spreadPos.func_177984_a()) > 2) continue;
            world.func_175656_a(spreadPos, this.func_176223_P());
        }
    }

    public void onPlantGrow(BlockState state, IWorld world, BlockPos pos, BlockPos source) {
        world.func_180501_a(pos, this.groundSupplier.get().func_176223_P(), 2);
    }

    @Override
    public boolean canBeReplacedByLogs(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }
}

