/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.compatibility;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.compatibility.jei.FurnaceSmeltingCategory;
import com.mushroom.midnight.common.recipe.MidnightFurnaceRecipe;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    private final ResourceLocation rl = new ResourceLocation("midnight");

    public ResourceLocation getPluginUid() {
        return this.rl;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(IntegrationJEI.getNightstoneFurnaceRecipeList(), FurnaceSmeltingCategory.ID);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnaceSmeltingCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)MidnightBlocks.NIGHTSTONE_FURNACE), new ResourceLocation[]{FurnaceSmeltingCategory.ID});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    private static List<MidnightFurnaceRecipe> getNightstoneFurnaceRecipeList() {
        ArrayList<MidnightFurnaceRecipe> recipeList = new ArrayList<MidnightFurnaceRecipe>();
        recipeList.add(new MidnightFurnaceRecipe(new ResourceLocation(MidnightItems.COOKED_HUNTER_WING.getItem().getRegistryName().func_110623_a()), "midnight:furnace", Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.HUNTER_WING}), MidnightItems.COOKED_HUNTER_WING.func_190903_i(), 0.35f, 200));
        recipeList.add(new MidnightFurnaceRecipe(new ResourceLocation(MidnightItems.COOKED_STAG_FLANK.getItem().getRegistryName().func_110623_a()), "midnight:furnace", Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.RAW_STAG_FLANK}), MidnightItems.COOKED_STAG_FLANK.func_190903_i(), 0.35f, 200));
        recipeList.add(new MidnightFurnaceRecipe(new ResourceLocation(MidnightItems.COOKED_STINGER_EGG.getItem().getRegistryName().func_110623_a()), "midnight:furnace", Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightBlocks.STINGER_EGG}), MidnightItems.COOKED_STINGER_EGG.func_190903_i(), 0.35f, 200));
        recipeList.add(new MidnightFurnaceRecipe(new ResourceLocation(MidnightItems.COOKED_SUAVIS.getItem().getRegistryName().func_110623_a()), "midnight:furnace", Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.RAW_SUAVIS}), MidnightItems.COOKED_SUAVIS.func_190903_i(), 0.35f, 200));
        return recipeList;
    }

    static {
        Midnight.LOGGER.info("Initializing The Midnight's JEI Integration.");
    }
}

