/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.ifc;

import com.mushroom.midnight.client.gui.config.ConfigListScreen;
import com.mushroom.midnight.client.gui.config.ListConfigOptionList;
import com.mushroom.midnight.client.gui.config.widget.IConfigWidget;
import com.mushroom.midnight.common.config.ifc.IConfigControlType;
import com.mushroom.midnight.common.config.provider.IConfigValue;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StringListControl
implements IConfigControlType<List<String>> {
    private final String header;

    public StringListControl(String header) {
        this.header = header;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IConfigWidget<List<String>> createConfigWidget(IConfigValue<List<String>> configValue) {
        return new CfgWidget(configValue, this.header);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class CfgWidget
    implements IConfigWidget<List<String>> {
        private final IConfigValue<List<String>> configValue;
        private final Button button;
        private final String header;

        private CfgWidget(IConfigValue<List<String>> configValue, String header) {
            this.configValue = configValue;
            this.button = new Button(0, 0, 150, 20, I18n.func_135052_a((String)"config.midnight.format.entries", (Object[])new Object[]{configValue.get().size()}), this::click);
            this.header = header;
        }

        private void click(Button btn) {
            List<String> strings = this.configValue.get();
            ConfigListScreen<String> listScreen = new ConfigListScreen<String>(Minecraft.func_71410_x().field_71462_r, (ITextComponent)new TranslationTextComponent(this.header, new Object[0]), strings, this::createTextBox, () -> "", list -> {
                this.configValue.set((List<String>)list);
                btn.setMessage(I18n.func_135052_a((String)"config.midnight.format.entries", (Object[])new Object[]{list.size()}));
            });
            Minecraft.func_71410_x().func_147108_a(listScreen);
        }

        private Widget createTextBox(ListConfigOptionList.Value<String> value) {
            TextFieldWidget tf = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 260, 20, "");
            tf.func_146180_a(value.get());
            tf.func_146203_f(Integer.MAX_VALUE);
            tf.func_212954_a(value::set);
            return tf;
        }

        @Override
        public IConfigValue<List<String>> getConfigValue() {
            return this.configValue;
        }

        @Override
        public Widget asWidget() {
            return this.button;
        }
    }
}

