/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.provider;

import com.google.common.base.Joiner;
import com.mushroom.midnight.common.config.provider.ForgeConfigValue;
import com.mushroom.midnight.common.config.provider.IConfigGatherer;
import com.mushroom.midnight.common.config.provider.IConfigProvider;
import com.mushroom.midnight.common.config.provider.IConfigValue;
import com.mushroom.midnight.common.config.provider.SimpleConfigValue;
import com.mushroom.midnight.common.config.provider.TempConfigProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigProfile
implements IConfigGatherer,
IConfigProvider {
    private static final Joiner PATH_JOINER = Joiner.on((char)'.');
    private final HashMap<String, ForgeConfigSpec.ConfigValue<?>> configs = new HashMap();
    private final HashMap<String, ForgeConfigValue<?>> values = new HashMap();
    private final HashMap<String, Object> tempDefaults = new HashMap();

    @Override
    public <T> IConfigGatherer add(ForgeConfigSpec.ConfigValue<T> configValue, T tempDefault) {
        String path = PATH_JOINER.join((Iterable)configValue.getPath());
        this.configs.put(path, configValue);
        this.values.put(path, new ForgeConfigValue<T>(configValue));
        if (tempDefault != null) {
            this.tempDefaults.put(path, tempDefault);
        }
        return this;
    }

    public IConfigProvider makeTempProvider() {
        TempConfigProvider provider = new TempConfigProvider();
        for (Map.Entry<String, ForgeConfigSpec.ConfigValue<?>> entry : this.configs.entrySet()) {
            provider.withValue(entry.getKey(), new SimpleConfigValue<Object>(this.tempDefaults.containsKey(entry.getKey()) ? this.tempDefaults.get(entry.getKey()) : entry.getValue().get()));
        }
        return provider;
    }

    public void importFromProvider(IConfigProvider provider, boolean save) {
        for (Map.Entry<String, ForgeConfigSpec.ConfigValue<?>> entry : this.configs.entrySet()) {
            entry.getValue().set(provider.configValue(entry.getKey()).get());
            if (!save) continue;
            entry.getValue().save();
        }
    }

    @Override
    public <T> IConfigValue<T> configValue(String path) {
        return this.values.get(path);
    }
}

