/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.Vec3d;

public class TargetIdleTracker {
    private final MobEntity owner;
    private final double idleBreakDistanceSq;
    private LivingEntity lastTarget;
    private int idleTime;
    private Vec3d lastTargetPos;

    public TargetIdleTracker(MobEntity owner, double idleBreakDistance) {
        this.owner = owner;
        this.idleBreakDistanceSq = idleBreakDistance * idleBreakDistance;
    }

    public void update() {
        LivingEntity target = this.owner.func_70638_az();
        if (target != this.lastTarget) {
            this.reset();
        }
        if (target != null) {
            Vec3d position = target.func_174791_d();
            if (this.lastTargetPos == null || this.lastTargetPos.func_72436_e(position) > this.idleBreakDistanceSq) {
                this.idleTime = 0;
                this.lastTargetPos = position;
            } else {
                ++this.idleTime;
            }
        }
        this.lastTarget = target;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    private void reset() {
        this.idleTime = 0;
        this.lastTargetPos = null;
    }
}

