/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.common.entity.task.FindEatableFoodGoal;
import com.mushroom.midnight.common.entity.task.NeutralGoal;
import com.mushroom.midnight.common.entity.task.StealFoodGoal;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightSounds;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class SkulkEntity
extends TameableEntity {
    private static final DataParameter<Boolean> STEALTH = EntityDataManager.func_187226_a(SkulkEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int stealthCooldown = 0;
    private int eatTicks;
    public static final Predicate<ItemStack> canEatFood = food -> food.func_77973_b().func_219967_s() != null && !food.func_77973_b().func_219967_s().func_221467_c() && food.func_77973_b() != MidnightItems.RAW_SUAVIS && food.func_77973_b() != MidnightItems.COOKED_SUAVIS;
    public static final Predicate<ItemStack> dislikeFood = food -> food.func_77973_b() == MidnightItems.RAW_SUAVIS || food.func_77973_b() == MidnightItems.COOKED_SUAVIS;
    public static final Predicate<ItemStack> tameableFood = food -> food.func_77973_b() == MidnightBlocks.VIRIDSHROOM.func_199767_j() || food.func_77973_b() == MidnightBlocks.NIGHTSHROOM.func_199767_j() || food.func_77973_b() == MidnightBlocks.BOGSHROOM.func_199767_j() || food.func_77973_b() == MidnightBlocks.DEWSHROOM.func_199767_j();

    public SkulkEntity(EntityType<? extends SkulkEntity> entityType, World world) {
        super(entityType, world);
        this.func_98053_h(true);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STEALTH, (Object)Boolean.FALSE);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundPathNavigator((MobEntity)this, world);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (this.func_180425_c().func_177956_o() <= this.field_70170_p.func_181545_F()) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT dataTag) {
        this.setStealth(true);
        return livingdata;
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (Goal)new NeutralGoal((CreatureEntity)this, (Goal)new PanicGoal((CreatureEntity)this, 1.0), true));
        this.field_70714_bg.func_75776_a(3, (Goal)new NeutralGoal((CreatureEntity)this, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 5.0f, 1.0f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, LivingEntity.class, 8.0f, 1.6, 1.6){

            public boolean func_75250_a() {
                boolean valid = super.func_75250_a() && !SkulkEntity.this.func_70909_n();
                return valid && this.field_75376_d != null && (dislikeFood.test(this.field_75376_d.func_184586_b(Hand.MAIN_HAND)) || dislikeFood.test(this.field_75376_d.func_184586_b(Hand.OFF_HAND)));
            }

            public void func_75249_e() {
                super.func_75249_e();
                SkulkEntity.this.setStealth(false);
            }

            public void func_75251_c() {
                super.func_75251_c();
                SkulkEntity.this.setStealth(true);
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new FindEatableFoodGoal((MobEntity)this, this::canEatItem, 1.15));
        this.field_70714_bg.func_75776_a(6, (Goal)new StealFoodGoal(this, 1.0, 0.005f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.005f){});
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this){

            public boolean func_75250_a() {
                boolean valid = super.func_75250_a();
                if (valid && SkulkEntity.this.canStealth() && !SkulkEntity.this.func_70909_n()) {
                    SkulkEntity.this.setStealth(true);
                }
                return valid;
            }
        });
        this.field_70715_bh.func_75776_a(1, (Goal)new NeutralGoal((CreatureEntity)this, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]), false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        this.setStealth(false);
        return flag;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (itemstack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (this.field_70170_p.field_72995_K) {
            return this.func_152114_e((LivingEntity)player) || tameableFood.test(itemstack);
        }
        if (this.func_70909_n()) {
            if (item.func_219971_r() && canEatFood.test(itemstack) && this.func_110143_aJ() < this.func_110138_aP() && this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                ItemStack stack = itemstack.func_77946_l();
                stack.func_190920_e(1);
                this.func_184611_a(Hand.MAIN_HAND, stack);
                return true;
            }
            if (this.func_152114_e((LivingEntity)player) && !tameableFood.test(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (tameableFood.test(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.setStealth(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_184609_a(Hand hand) {
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            ++this.eatTicks;
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 200) {
                    ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                    if (!itemstack1.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                    }
                    this.func_70691_i(2.0f);
                    this.eatTicks = 0;
                } else if (this.eatTicks > 160 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
        }
        super.func_70636_d();
        if (this.stealthCooldown > 0) {
            --this.stealthCooldown;
        }
    }

    public boolean isStealth() {
        return (Boolean)this.field_70180_af.func_187225_a(STEALTH);
    }

    public boolean canStealth() {
        return this.stealthCooldown <= 0;
    }

    public void setStealth(boolean flag) {
        this.field_70180_af.func_187227_b(STEALTH, (Object)flag);
        this.stealthCooldown = 60;
    }

    public float func_70689_ay() {
        return super.func_70689_ay() * (this.isStealth() ? 0.3f : 1.0f);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.setStealth(false);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof SkulkEntity) {
                SkulkEntity wolfentity = (SkulkEntity)target;
                return !wolfentity.func_70909_n() || wolfentity.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("stealth", this.isStealth());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("stealth", 1)) {
            this.setStealth(compound.func_74767_n("stealth"));
        }
    }

    public float func_213348_b(Pose pose, EntitySize size) {
        return super.func_213348_b(pose, size) * 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    private boolean canEatItem(ItemStack itemstack) {
        return canEatFood.test(itemstack);
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (!this.canEatItem(this.func_184582_a(EquipmentSlotType.MAINHAND)) && this.canEatItem(itemstack) && (!this.func_70909_n() || this.func_110143_aJ() < this.func_110138_aP() && this.func_70909_n())) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int func_70627_aG() {
        return 100;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70681_au().nextInt(3) == 0 && this.isStealth()) {
            return MidnightSounds.SKULK_SNIFFING;
        }
        return MidnightSounds.SKULK_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MidnightSounds.SKULK_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MidnightSounds.SKULK_DEATH;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == MidnightBlocks.GRASS_BLOCK ? 10.0f : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity player) {
        return this.func_70068_e((Entity)player) < 8.0 || this.func_152114_e((LivingEntity)player);
    }
}

