/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.projectile;

import com.mushroom.midnight.common.item.SporeBombItem;
import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class SporeBombEntity
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> BOMB_STACK = EntityDataManager.func_187226_a(SporeBombEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public SporeBombEntity(World world) {
        super(MidnightEntities.SPORE_BOMB, world);
    }

    public SporeBombEntity(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public SporeBombEntity(World world, double x, double y, double z) {
        super(MidnightEntities.SPORE_BOMB, x, y, z, world);
    }

    public SporeBombEntity(World world, LivingEntity thrower) {
        super(MidnightEntities.SPORE_BOMB, thrower, world);
    }

    public SporeBombEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(MidnightEntities.SPORE_BOMB, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOMB_STACK, (Object)new ItemStack((IItemProvider)MidnightItems.NIGHTSHROOM_SPORE_BOMB));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("bomb_stack", (INBT)this.getBombStack().func_77955_b(new CompoundNBT()));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("bomb_stack", 10)) {
            this.setBombStack(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("bomb_stack")));
        }
    }

    public ItemStack getBombStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(BOMB_STACK);
    }

    public void setBombStack(ItemStack bombStack) {
        this.field_70180_af.func_187227_b(BOMB_STACK, (Object)bombStack);
    }

    public ITextComponent func_200200_C_() {
        return this.func_145818_k_() ? super.func_200200_C_() : this.getBombStack().func_200301_q();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.func_70099_a(new ItemStack((IItemProvider)MidnightItems.DARK_PEARL), 0.1f);
                this.func_70106_y();
            } else {
                SporeBombItem bomb = (SporeBombItem)this.getBombStack().func_77973_b();
                if (bomb.checkExplode(this.field_70170_p, this.getBombStack())) {
                    bomb.explode((ServerWorld)this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                    this.func_70106_y();
                }
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.canBreakOn(result)) {
                ((SporeBombItem)this.getBombStack().func_77973_b()).explode((ServerWorld)this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            } else {
                this.func_70099_a(this.getBombStack().func_77946_l(), 0.01f);
            }
            this.func_70106_y();
        }
    }

    private boolean canBreakOn(RayTraceResult result) {
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockState impactedState = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a());
        return impactedState.func_185904_a() == Material.field_151576_e || impactedState.func_185904_a() == Material.field_151573_f;
    }

    public ItemStack func_184543_l() {
        return this.getBombStack();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

