/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.common.entity.creature.RifterEntity;
import com.mushroom.midnight.common.entity.util.AttachmentSolver;
import com.mushroom.midnight.common.entity.util.DragVector3d;
import com.mushroom.midnight.common.util.EntityUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class DragSolver {
    private final RifterEntity owner;
    private final AttachmentSolver attachmentSolver;
    private LivingEntity dragged;
    private DragVector3d attachmentPoint;
    private DragVector3d prevAttachmentPoint;

    public DragSolver(RifterEntity owner) {
        this.owner = owner;
        this.attachmentSolver = new AttachmentSolver((LivingEntity)this.owner);
    }

    public void setDragged(LivingEntity dragged) {
        if (this.dragged != null) {
            this.resetDragged(this.dragged);
        }
        this.dragged = dragged;
        if (dragged != null) {
            this.initDragged(dragged);
        }
    }

    private void initDragged(LivingEntity entity) {
        entity.field_70145_X = true;
    }

    private void resetDragged(LivingEntity entity) {
        entity.field_70145_X = false;
        entity.func_213317_d(new Vec3d(entity.func_226277_ct_() - entity.field_70169_q, entity.func_226278_cu_() - entity.field_70167_r, entity.func_226281_cx_() - entity.field_70166_s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solveDrag() {
        if (this.dragged == null) {
            this.attachmentPoint = null;
            return;
        }
        this.prevAttachmentPoint = this.attachmentPoint;
        float entityWidth = this.getTransformedWidth();
        float dragOffset = (this.owner.func_213311_cf() + entityWidth) / 2.0f + 0.2f;
        float theta = (float)Math.toRadians(this.owner.field_70761_aq);
        double dragOriginX = MathHelper.func_76126_a((float)theta) * dragOffset;
        double dragOriginZ = -MathHelper.func_76134_b((float)theta) * dragOffset;
        this.attachmentSolver.getAttachmentPoint().moveTo(dragOriginX, 0.0, dragOriginZ);
        this.solveRotation(this.dragged);
        this.dragged.field_70145_X = false;
        try {
            AttachmentSolver.Result result = this.attachmentSolver.solveAttachment(this.dragged);
            this.attachmentPoint = result.getSnappedPoint();
        }
        finally {
            this.dragged.field_70145_X = true;
            this.dragged.func_213317_d(Vec3d.field_186680_a);
        }
    }

    private float getTransformedWidth() {
        EntityUtil.Stance stance = EntityUtil.getStance(this.dragged);
        return stance == EntityUtil.Stance.QUADRUPEDAL ? this.dragged.func_213311_cf() : this.dragged.func_213302_cg();
    }

    private void solveRotation(LivingEntity entity) {
        entity.func_181013_g(this.owner.field_70177_z);
        float deltaYaw = this.owner.field_70177_z - this.owner.field_70126_B;
        entity.field_70177_z += deltaYaw;
        entity.func_70034_d(entity.func_70079_am() + deltaYaw);
    }

    @Nullable
    public DragVector3d getAttachmentPoint() {
        return this.attachmentPoint;
    }

    @Nullable
    public DragVector3d lerpAttachmentPoint(float partialTicks) {
        if (this.attachmentPoint == null) {
            return null;
        }
        if (this.prevAttachmentPoint == null) {
            this.prevAttachmentPoint = this.attachmentPoint;
        }
        DragVector3d lerp = new DragVector3d(0.0, 0.0, 0.0);
        this.interpolate(lerp, this.prevAttachmentPoint, this.attachmentPoint, partialTicks);
        return lerp;
    }

    protected void interpolate(DragVector3d DragVector3d2, DragVector3d a, DragVector3d b, double x) {
        double t = x;
        DragVector3d2.x = (1.0 - t) * a.x + t * b.x;
        DragVector3d2.y = (1.0 - t) * a.y + t * b.y;
        DragVector3d2.z = (1.0 - t) * a.z + t * b.z;
    }
}

