/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.item;

import com.mushroom.midnight.common.entity.CloudEntity;
import com.mushroom.midnight.common.entity.projectile.SporeBombEntity;
import com.mushroom.midnight.common.particle.ParticleDataOneInt;
import com.mushroom.midnight.common.registry.MidnightEffects;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import com.mushroom.midnight.common.registry.MidnightTags;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SporeBombItem
extends Item {
    public int maxFuseTime = 200;
    private final Type bombType;

    public SporeBombItem(Type bombType, Item.Properties properties) {
        super(properties);
        this.bombType = bombType;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenserBehavior());
        this.func_185043_a(new ResourceLocation("blinking"), (stack, world, entity) -> {
            float fuseTime = world != null ? (float)this.getFuseTime(world, stack) / (float)this.maxFuseTime : 1.0f;
            float ratio = fuseTime * 10.0f % 1.0f;
            return ratio > 0.5f ? 1.0f : 0.0f;
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == this) {
            player.func_184811_cZ().func_185145_a((Item)this, 10);
            if (!world.field_72995_K) {
                SporeBombEntity bomb = this.createEntityBomb(world, heldItem, player);
                bomb.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_217376_c((Entity)bomb);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187511_aA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        this.updateBomb(world, stack, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        boolean valid = this.updateBomb(entity.field_70170_p, entity.func_92059_d(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        if (valid) {
            entity.func_70106_y();
        }
        return valid;
    }

    private boolean updateBomb(World world, ItemStack stack, double x, double y, double z) {
        if (!world.field_72995_K) {
            long fuseTime = this.getFuseTime(world, stack);
            if (fuseTime <= 0L) {
                this.explode((ServerWorld)world, x, y, z);
                stack.func_190918_g(1);
                return true;
            }
            if (fuseTime < (long)this.maxFuseTime) {
                world.func_184148_a(null, x, y, z, SoundEvents.field_187659_cY, SoundCategory.HOSTILE, world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
            }
        }
        return false;
    }

    public void setFuseTime(World world, ItemStack stack, int time) {
        if (stack.func_77973_b() == this) {
            CompoundNBT compound = stack.func_196082_o();
            compound.func_74772_a("fuse_time", world.func_82737_E() + (long)time);
        }
    }

    public long getFuseTime(World world, ItemStack stack) {
        if (!stack.func_77973_b().func_206844_a(MidnightTags.Items.SPORE_BOMBS) || !stack.func_77942_o()) {
            return this.maxFuseTime;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_150297_b("fuse_time", 4)) {
            return Math.max(0L, tag.func_74763_f("fuse_time") - world.func_82737_E());
        }
        return this.maxFuseTime;
    }

    public boolean checkExplode(World world, ItemStack stack) {
        return this.getFuseTime(world, stack) <= 0L;
    }

    public void explode(ServerWorld world, double x, double y, double z) {
        world.func_195598_a((IParticleData)new ParticleDataOneInt(MidnightParticleTypes.BOMB_EXPLOSION, this.bombType.getColor()), x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
        world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 1.0f, 1.0f);
        switch (this.bombType) {
            case NIGHTSHROOM: {
                world.func_217376_c((Entity)SporeBombItem.createLingeringCloud(this.bombType, (World)world, x, y, z).setParticleData(new ParticleDataOneInt(MidnightParticleTypes.FADING_SPORE, this.bombType.getColor())).addEffect(new EffectInstance(MidnightEffects.DARKNESS, 100, 0, false, true)));
                break;
            }
            case DEWSHROOM: {
                world.func_217376_c((Entity)SporeBombItem.createLingeringCloud(this.bombType, (World)world, x, y, z).setParticleData(new ParticleDataOneInt(MidnightParticleTypes.FADING_SPORE, this.bombType.getColor())).setRadiusPerTick(0.0025f).addEffect(new EffectInstance(MidnightEffects.STUNNED, 100, 0, false, true)).addEffect(new EffectInstance(Effects.field_76421_d, 100, 5, false, true)));
                break;
            }
            case VIRIDSHROOM: {
                world.func_217376_c((Entity)SporeBombItem.createLingeringCloud(this.bombType, (World)world, x, y, z).setAllowTeleport().setParticleData(new ParticleDataOneInt(MidnightParticleTypes.FADING_SPORE, this.bombType.getColor())).addEffect(new EffectInstance(MidnightEffects.TORMENTED, 100, 0, false, true)));
                break;
            }
            case BOGSHROOM: {
                world.func_217376_c((Entity)SporeBombItem.createLingeringCloud(this.bombType, (World)world, x, y, z).setParticleData(new ParticleDataOneInt(MidnightParticleTypes.FADING_SPORE, this.bombType.getColor())).addEffect(new EffectInstance(MidnightEffects.CONFUSION, 200, 0, false, true)));
            }
        }
    }

    private static CloudEntity createLingeringCloud(Type bombType, World world, double x, double y, double z) {
        float radius = 2.5f;
        int duration = 300;
        return new CloudEntity(world, x, y, z).setRadius(radius).setWaitTime(10).setDuration(duration).setRadiusPerTick(-radius / (float)duration).setPotion(Potions.field_185229_a).setColor(bombType.getColor());
    }

    private SporeBombEntity createEntityBomb(World world, ItemStack stack, PlayerEntity player) {
        SporeBombEntity bomb = new SporeBombEntity(world, (LivingEntity)player);
        return this.addStackToBomb(bomb, stack);
    }

    private SporeBombEntity createEntityBomb(World world, ItemStack stack, IPosition pos) {
        SporeBombEntity bomb = new SporeBombEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        return this.addStackToBomb(bomb, stack);
    }

    private SporeBombEntity addStackToBomb(SporeBombEntity bomb, ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        ItemStack newStack = stack.func_77946_l();
        if (compound == null || !compound.func_150297_b("fuse_time", 4)) {
            this.setFuseTime(bomb.field_70170_p, newStack, this.maxFuseTime);
        }
        bomb.setBombStack(newStack);
        return bomb;
    }

    private class DispenserBehavior
    extends ProjectileDispenseBehavior {
        private DispenserBehavior() {
        }

        protected IProjectile func_82499_a(World world, IPosition pos, ItemStack stack) {
            return SporeBombItem.this.createEntityBomb(world, stack, pos);
        }
    }

    public static enum Type {
        NIGHTSHROOM(7290838),
        DEWSHROOM(6937061),
        VIRIDSHROOM(4183623),
        BOGSHROOM(15103021);

        private final int color;

        private Type(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public static Type getDefault() {
            return NIGHTSHROOM;
        }
    }
}

